/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.util;

import fr.n3vision.hotspot.core.preference.StaticPreference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;

public class Log {
    private static FileOutputStream file;
    private static final String LEVEL_VERBOSE = "V";
    private static final String LEVEL_DEBUG = "D";
    private static final String LEVEL_INFO = "I";
    private static final String LEVEL_WARN = "W";
    private static final String LEVEL_ERROR = "E";
    private static boolean force;
    private static boolean logToFile;
    private static String fichier;
    private static boolean isCli;
    private static String tag;

    static {
        force = false;
        logToFile = true;
        fichier = "";
        isCli = false;
        tag = "HWR";
    }

    public static void setCli(boolean b) {
        isCli = b;
    }

    public static void d(String message) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                System.out.println(String.valueOf(Log.getNow()) + " : " + message);
            }
            if (logToFile) {
                Log.logToFile(LEVEL_DEBUG, tag, message);
            }
        }
    }

    public static void d(Exception e) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                e.printStackTrace();
            }
            if (logToFile) {
                Log.appendToFile(LEVEL_DEBUG, tag, e);
            }
        }
    }

    public static void e(String message) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                System.out.println(String.valueOf(Log.getNow()) + " : " + message);
            }
            if (logToFile) {
                Log.logToFile(LEVEL_ERROR, tag, message);
            }
        }
    }

    public static void e(Exception e) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                e.printStackTrace();
            }
            if (logToFile) {
                Log.appendToFile(LEVEL_ERROR, tag, e);
            }
        }
    }

    public static void i(String message) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                System.out.println(String.valueOf(Log.getNow()) + " : " + message);
            }
            if (logToFile) {
                Log.logToFile(LEVEL_INFO, tag, message);
            }
        }
    }

    public static void i(Exception e) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                e.printStackTrace();
            }
            if (logToFile) {
                Log.appendToFile(LEVEL_INFO, tag, e);
            }
        }
    }

    public static void v(String message) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                System.out.println(String.valueOf(Log.getNow()) + " : " + message);
            }
            if (logToFile) {
                Log.logToFile(LEVEL_VERBOSE, tag, message);
            }
        }
    }

    public static void v(Exception e) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                e.printStackTrace();
            }
            if (logToFile) {
                Log.appendToFile(LEVEL_VERBOSE, tag, e);
            }
        }
    }

    public static void w(String message) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                System.out.println(String.valueOf(Log.getNow()) + " : " + message);
            }
            if (logToFile) {
                Log.logToFile(LEVEL_WARN, tag, message);
            }
        }
    }

    public static void w(Exception e) {
        if (StaticPreference.debug || force) {
            if (!isCli) {
                e.printStackTrace();
            }
            if (logToFile) {
                Log.appendToFile(LEVEL_WARN, tag, e);
            }
        }
    }

    private static String getFileName() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        String day_str = day < 10 ? "0" + day : String.valueOf(day);
        int month = 1 + cal.get(2);
        String month_str = month < 10 ? "0" + month : String.valueOf(month);
        int year = cal.get(1);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String hour_str = hour < 10 ? "0" + hour : String.valueOf(hour);
        String minute_str = minute < 10 ? "0" + minute : String.valueOf(minute);
        String second_str = second < 10 ? "0" + second : String.valueOf(second);
        fichier = "log_hwr_3.1.7_" + year + "_" + month_str + "_" + day_str + "-" + hour_str + "_" + minute_str + "_" + second_str + ".log";
        return fichier;
    }

    private static void openFile() {
        String fileName = Log.getFileName();
        try {
            file = new FileOutputStream(new File(fileName), false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void logToFile(String level, String tag, String message) {
        if (file == null) {
            Log.openFile();
        }
        String date = Log.getNow();
        String dataLine = String.valueOf(level) + "\t" + date + "\t\t" + tag + "\t\t" + message + "\n";
        try {
            file.write(dataLine.getBytes());
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private static void appendToFile(String level, String tag, Exception e) {
        if (file == null) {
            Log.openFile();
        }
        String date = Log.getNow();
        String dataLine = String.valueOf(level) + "\t" + date + "\t\t" + tag + "\n";
        try {
            file.write(dataLine.getBytes());
            file.flush();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        e.printStackTrace(new PrintStream(file));
    }

    private static String getNow() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        String day_str = day < 10 ? "0" + day : String.valueOf(day);
        int month = 1 + cal.get(2);
        String month_str = month < 10 ? "0" + month : String.valueOf(month);
        int year = cal.get(1);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milisecond = cal.get(14);
        String hour_str = hour < 10 ? "0" + hour : String.valueOf(hour);
        String minute_str = minute < 10 ? "0" + minute : String.valueOf(minute);
        String second_str = second < 10 ? "0" + second : String.valueOf(second);
        String milisecond_str = milisecond < 10 ? "00" + milisecond : (milisecond < 100 ? "0" + milisecond : String.valueOf(milisecond));
        return String.valueOf(day_str) + "/" + month_str + "/" + year + " " + hour_str + ":" + minute_str + ":" + second_str + "." + milisecond_str;
    }

    public static void restartNewLog() {
        Log.closeFile();
        Log.openFile();
    }

    public static void closeFile() {
        if (StaticPreference.debug || force) {
            try {
                file.close();
                file = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getFichier() {
        return fichier;
    }
}

