/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.util;

import fr.n3vision.hotspot.util.Client;
import fr.n3vision.hotspot.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class HttpsClient
extends Client {
    private String className = this.getClass().getName();
    private HttpsURLConnection connection;
    private ArrayList<Integer[]> certif_hashs;

    public HttpsClient(String szUrl, ArrayList<Integer[]> certif_hashs) throws Exception {
        Log.d(String.valueOf(this.className) + " : Instanciation HttpClient ;");
        this.certif_hashs = certif_hashs;
        try {
            this.url = new URL(szUrl);
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Invalid URL");
        }
    }

    @Override
    public int connect(String method, String userAgent) throws Exception {
        return this.connect(method, null, userAgent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int connect(String method, String session, String userAgent) throws Exception {
        Log.i(String.valueOf(this.className) + " : Connexion en " + method);
        try {
            block13: {
                this.trustAllHosts();
                this.connection = (HttpsURLConnection)this.url.openConnection();
                this.connection.setHostnameVerifier((HostnameVerifier)SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                Log.i(String.valueOf(this.className) + " : v\u00e9rification du certificat");
                if (this.connection == null) return 10;
                try {
                    Log.d(String.valueOf(this.className) + " : Code de retour HTTP : " + this.connection.getResponseCode());
                    Log.d(String.valueOf(this.className) + " : Cipher Suite : " + this.connection.getCipherSuite());
                    Certificate[] certs = this.connection.getServerCertificates();
                    Log.d(String.valueOf(this.className) + " : Certificat(s)");
                    if (this.checkCertificates(certs)) {
                        Log.i(String.valueOf(this.className) + " : V\u00e9rification certificat : OK");
                        break block13;
                    }
                    Log.w(String.valueOf(this.className) + " : Erreur dans les certificats. Affichage du ou des parties du certificat : ");
                    Certificate[] certificateArray = certs;
                    int n = certs.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return 3;
                        }
                        Certificate cert = certificateArray[n2];
                        String message = "Cert Type : " + cert.getType();
                        message = String.valueOf(message) + "\nCert Hash Code : " + cert.hashCode();
                        message = String.valueOf(message) + "\nCert Public Key Algorithm : " + cert.getPublicKey().getAlgorithm();
                        message = String.valueOf(message) + "\nCert Public Key Format : " + cert.getPublicKey().getFormat();
                        message = String.valueOf(message) + "\nCert Public Key Encoded : " + cert.getPublicKey().getEncoded();
                        Log.d(String.valueOf(this.className) + " : " + message);
                        ++n2;
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    Log.e(String.valueOf(this.className) + " : SSLPeerUnverifiedException lors de la v\u00e9rification du certificat : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
                    Log.e(e);
                }
                catch (Exception e) {
                    Log.e(String.valueOf(this.className) + " : Exception lors de la v\u00e9rification du certificat : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
                    Log.e(e);
                }
            }
            Log.d(String.valueOf(this.className) + " : Connexion en " + method);
            this.connection = (HttpsURLConnection)this.url.openConnection();
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setConnectTimeout(10000);
            this.connection.setReadTimeout(10000);
            this.connection.setRequestMethod(method);
            this.connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("user-agent", userAgent);
            if (session != null && !session.isEmpty()) {
                Log.i(String.valueOf(this.className) + " : Injection d'une session : " + session);
                this.connection.setRequestProperty("Cookie", session);
            }
            this.connection.connect();
            Log.i(String.valueOf(this.className) + " : proc\u00e9dure de connexion termin\u00e9e");
            return 10;
        }
        catch (UnknownHostException e) {
            Log.e(String.valueOf(this.className) + " Hote non trouv\u00e9 : signe d'un probl\u00e8me de connectivit\u00e9 !");
            return 2;
        }
        catch (ConnectException ce) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Exception (timeout)");
            return 6;
        }
        catch (SocketTimeoutException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Timeout");
            return 6;
        }
        catch (SocketException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : signe d'un probl\u00e8me de connectivit\u00e9 ! (connection reseted during opration)");
            return 2;
        }
        catch (Exception e) {
            Log.e(e);
            return 2;
        }
    }

    @Override
    public void disconnect() {
        Log.i(String.valueOf(this.className) + " : D\u00e9connexion");
        this.connection.disconnect();
    }

    @Override
    public String getResponse() throws Exception {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration de la r\u00e9ponse");
        String result = "";
        try {
            BufferedReader s = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            String line = s.readLine();
            while (line != null) {
                result = String.valueOf(result) + line;
                line = s.readLine();
            }
            s.close();
        }
        catch (UnknownHostException e) {
            Log.e(String.valueOf(this.className) + " Hote non trouv\u00e9 : signe d'un probl\u00e8me de connectivit\u00e9 !");
            Log.e(e);
            result = String.valueOf(2);
        }
        catch (ConnectException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Exception (timeout)");
            Log.e(e);
            result = String.valueOf(6);
        }
        catch (FileNotFoundException e) {
            Log.e(e);
            result = String.valueOf(404);
        }
        catch (SocketTimeoutException e) {
            result = String.valueOf(6);
        }
        catch (Exception e) {
            result = "";
            Log.i(String.valueOf(this.className) + " : Exception lors de la r\u00e9cup\u00e9ration de la r\u00e9ponse : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
            Log.e(e);
        }
        Log.i(String.valueOf(this.className) + " : R\u00e9sultat : " + result);
        return result;
    }

    @Override
    public String getLocationHeader() {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration du header Location");
        return this.connection.getHeaderField("location");
    }

    @Override
    public String getSession() {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration de la session");
        return this.connection.getHeaderField("Set-Cookie");
    }

    @Override
    public void displayheaders() throws Exception {
        Log.i(String.valueOf(this.className) + " : Affichage des headers d'une page");
        try {
            Map<String, List<String>> headers = this.connection.getHeaderFields();
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                List<String> list = headers.get(key);
                for (String value : list) {
                    Log.d(String.valueOf(this.className) + " header: " + key + " : " + value);
                }
            }
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Unable to get headers");
        }
    }

    @Override
    public void post(String s) throws Exception {
        Log.i(String.valueOf(this.className) + " : Envoi de formulaire POST");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.connection.getOutputStream()));
            bw.write(s, 0, s.length());
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Unable to write to output stream");
        }
        Log.i(String.valueOf(this.className) + " : Envoi du formulaire termin\u00e9");
    }

    public boolean checkCertificates(Certificate[] certs) {
        Log.i(String.valueOf(this.className) + " : V\u00e9rification des certificats : ");
        for (Integer[] hashes : this.certif_hashs) {
            int valid = 0;
            int i = 0;
            while (i < certs.length) {
                if (hashes.length >= certs.length) {
                    Integer hash = hashes[i];
                    Log.d(String.valueOf(this.className) + " : (certs[" + i + "].hashCode()==" + hash + ") = " + String.valueOf(certs[i].hashCode() == hash.intValue()));
                    if (certs[i].hashCode() == hash.intValue()) {
                        ++valid;
                    }
                } else {
                    Log.e(String.valueOf(this.className) + " : Ce tableau d'empruntes '" + i + "' est trop petit pour tester ce certificat ! ");
                    break;
                }
                ++i;
            }
            Log.d("Nb de Hash valid : " + valid + " sur nb de certif dispo : " + certs.length);
            if (valid != certs.length) continue;
            return true;
        }
        return false;
    }

    private void trustAllHosts() {
        X509TrustManager easyTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{easyTrustManager};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

