/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.util;

import fr.n3vision.hotspot.util.Client;
import fr.n3vision.hotspot.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClient
extends Client {
    private String className = this.getClass().getName();
    protected HttpURLConnection connection;

    public HttpClient(String szUrl) throws Exception {
        Log.d(String.valueOf(this.className) + " : Instanciation HttpClient ;");
        try {
            this.url = new URL(szUrl);
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Invalid URL");
        }
    }

    @Override
    public int connect(String method, String userAgent) {
        return this.connect(method, null, userAgent);
    }

    @Override
    public int connect(String method, String session, String userAgent) {
        Log.i(String.valueOf(this.className) + " : Connexion en " + method);
        try {
            this.trustAllHosts();
            this.connection = (HttpURLConnection)this.url.openConnection();
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setConnectTimeout(10000);
            this.connection.setReadTimeout(10000);
            this.connection.setRequestMethod(method);
            this.connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("user-agent", userAgent);
            if (session != null && !session.isEmpty()) {
                Log.i(String.valueOf(this.className) + " : Injection d'une session : " + session);
                this.connection.setRequestProperty("Cookie", session);
            }
            this.connection.connect();
            Log.i(String.valueOf(this.className) + " : proc\u00e9dure de connexion termin\u00e9e");
        }
        catch (UnknownHostException e) {
            Log.e(String.valueOf(this.className) + " Hote non trouv\u00e9 : signe d'un probl\u00e8me de connectivit\u00e9 !");
            return 2;
        }
        catch (ConnectException ce) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Exception (timeout)");
            return 6;
        }
        catch (SocketTimeoutException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Timeout");
            return 6;
        }
        catch (SocketException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : signe d'un probl\u00e8me de connectivit\u00e9 ! (connection reseted during opration)");
            return 2;
        }
        catch (Exception e) {
            Log.e(e);
            return 2;
        }
        return 10;
    }

    @Override
    public void disconnect() {
        Log.i(String.valueOf(this.className) + " : D\u00e9connexion");
        this.connection.disconnect();
    }

    @Override
    public String getResponse() throws Exception {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration du contenu");
        String result = "";
        try {
            BufferedReader s = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            String line = s.readLine();
            while (line != null) {
                result = String.valueOf(result) + line;
                line = s.readLine();
            }
            s.close();
        }
        catch (UnknownHostException e) {
            Log.e(String.valueOf(this.className) + " Hote non trouv\u00e9 : signe d'un probl\u00e8me de connectivit\u00e9 !");
            Log.e(e);
            result = String.valueOf(2);
        }
        catch (ConnectException e) {
            Log.e(String.valueOf(this.className) + " SocketException ! : Connection Exception (timeout)");
            Log.e(e);
            result = String.valueOf(6);
        }
        catch (FileNotFoundException e) {
            result = String.valueOf(404);
        }
        catch (SocketTimeoutException e) {
            Log.d(String.valueOf(this.className) + " Request Timed Out");
            result = String.valueOf(6);
        }
        catch (Exception e) {
            result = "";
            Log.e(String.valueOf(this.className) + " : Exception lors de la r\u00e9cup\u00e9ration de la r\u00e9ponse : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
            Log.e(e);
        }
        Log.d(String.valueOf(this.className) + " : Contenu = " + result);
        return result;
    }

    @Override
    public String getLocationHeader() {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration du header Location");
        return this.connection.getHeaderField("location");
    }

    @Override
    public String getSession() {
        Log.i(String.valueOf(this.className) + " : R\u00e9cup\u00e9ration de la session");
        return this.connection.getHeaderField("Set-Cookie");
    }

    @Override
    public void displayheaders() throws Exception {
        Log.i(String.valueOf(this.className) + " : Affichage des headers");
        try {
            Map<String, List<String>> headers = this.connection.getHeaderFields();
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                List<String> list = headers.get(key);
                for (String value : list) {
                    Log.d(String.valueOf(this.className) + " header: " + key + " : " + value);
                }
            }
            Log.d(String.valueOf(this.className) + " response Code=" + this.connection.getResponseCode());
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Unable to get headers");
        }
    }

    @Override
    public void post(String data) throws Exception {
        Log.i(String.valueOf(this.className) + " : Envoi de formulaire POST");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.connection.getOutputStream()));
            bw.write(data, 0, data.length());
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Log.e(e);
            throw new Exception("Unable to write to output stream");
        }
        Log.i(String.valueOf(this.className) + " : Envoi du formulaire termin\u00e9");
    }

    private void trustAllHosts() {
        X509TrustManager easyTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{easyTrustManager};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

