/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.util;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.GlobalPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.core.preference.StaticPreference;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Log;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javax.swing.DefaultComboBoxModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Functions {
    private static String className = "fr.n3vision.hotspot3.util.Functions";

    public static String getCountFromLong(long span, boolean isForSFR) {
        span /= 1000L;
        if (isForSFR && (span = 7200L - span) < 0L) {
            return "Attente";
        }
        int heure = (int)Math.floor(span / 3600L);
        String heureStr = heure < 10 ? "0" + heure : String.valueOf(heure);
        int minute = (int)Math.floor((span - (long)(heure * 3600)) / 60L);
        String minuteStr = minute < 10 ? "0" + minute : String.valueOf(minute);
        int seconde = (int)Math.floor(span - (long)(heure * 3600) - (long)(minute * 60));
        String secondeStr = seconde < 10 ? "0" + seconde : String.valueOf(seconde);
        return String.valueOf(heureStr) + ":" + minuteStr + ":" + secondeStr;
    }

    public static String crypt(String input) {
        String output = "";
        int i = 0;
        while (i < input.length()) {
            int c = input.charAt(i) ^ 0xC;
            output = String.valueOf(output) + (char)c;
            ++i;
        }
        return output;
    }

    public static String decrypt(String input) {
        String output = "";
        int i = 0;
        while (i < input.length()) {
            int c = input.charAt(i) ^ 0xC;
            output = String.valueOf(output) + (char)c;
            ++i;
        }
        return output;
    }

    public static long getCurrentTimeStamp() {
        Date d = new Date();
        return d.getTime();
    }

    public static int getIndexFromInterval(int interval) {
        int i = 0;
        while (i < Constant.LIST_INTERVAL_VALUES.length) {
            if (Constant.LIST_INTERVAL_VALUES[i] == interval) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static int getIndexFromNotificationType(int type) {
        int i = 0;
        while (i < Constant.LIST_NOTIFICATION_VALUE.length) {
            if (Constant.LIST_NOTIFICATION_VALUE[i] == type) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static void download_file() {
        try {
            long startTime = System.currentTimeMillis();
            URL url = new URL("http://www.n3vision.net/out.php?url=http%3A%2F%2Fhwr.ntvapp.com%2Fhwr.zip%3Fauto");
            url.openConnection();
            InputStream reader = url.openStream();
            FileOutputStream writer = new FileOutputStream(String.valueOf(Constant.TEMP_DIRECTORY) + "hwr_temp.zip");
            byte[] buffer = new byte[153600];
            int totalBytesRead = 0;
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
                totalBytesRead += bytesRead;
            }
            long endTime = System.currentTimeMillis();
            Log.d(String.valueOf(className) + " Download Done. " + new Integer(totalBytesRead).toString() + " bytes read (" + new Long(endTime - startTime).toString() + " millseconds).\n");
            writer.close();
            reader.close();
        }
        catch (MalformedURLException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
    }

    public static String generatePreferenceXML() {
        GlobalPreference globalPreference = Model.getInstance().getGlobalPreference();
        HotspotsPreference hotspotsPreferences = Model.getInstance().getHotspotsPreference();
        hotspotsPreferences.reorderAccounts();
        String resultat = "";
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.setXmlVersion("1.0");
            Element rootElement = doc.createElement("configuration");
            doc.appendChild(rootElement);
            Element generalElement = doc.createElement("preferences");
            rootElement.appendChild(generalElement);
            Functions.buildGeneralPreferenceNode(generalElement, doc, "launchAtStartUp", String.valueOf(globalPreference.isLaunchAtStartUp()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "minimizeAtStartUp", String.valueOf(globalPreference.isMinimizeAtStartUp()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "lastVersionCheck", String.valueOf(globalPreference.getLastVersionCheck()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "automaticVersionCheck", String.valueOf(globalPreference.isAutomaticVersionCheck()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "timerInterval", String.valueOf(globalPreference.getTimerInterval()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "debug", String.valueOf(StaticPreference.debug));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "http", String.valueOf(globalPreference.isHttp()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "lang", String.valueOf(globalPreference.getLang()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "langchanged", String.valueOf(globalPreference.isLanguagesChanged()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "notificationType", String.valueOf(globalPreference.getNotificationType()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "numberOfCheckVersionFailed", String.valueOf(globalPreference.getNumberOfCheckVersionFailed()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "app_locked", String.valueOf(globalPreference.isApp_locked()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_bouygues", String.valueOf(globalPreference.isHotspot_locked_bouygues()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_campus_angers", String.valueOf(globalPreference.isHotspot_locked_campus_angers()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_free", String.valueOf(globalPreference.isHotspot_locked_free()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_orange", String.valueOf(globalPreference.isHotspot_locked_orange()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_sfr", String.valueOf(globalPreference.isHotspot_locked_sfr()));
            Functions.buildGeneralPreferenceNode(generalElement, doc, "hotspot_locked_sfr_gares", String.valueOf(globalPreference.isHotspot_locked_sfr_gares()));
            Element hotspotsElement = doc.createElement("hotspots");
            rootElement.appendChild(hotspotsElement);
            HashMap<Integer, ArrayList<AccountPreference>> hotspots = hotspotsPreferences.getHotspotsAccounts();
            for (ArrayList<AccountPreference> accounts : hotspots.values()) {
                for (AccountPreference accountPreference : accounts) {
                    hotspotsElement.appendChild(Functions.buildHotspotElement(accountPreference, doc));
                }
            }
            HashMap<Integer, ArrayList<AccountPreference>> hotspots2 = hotspotsPreferences.getHotspotsAccountsDisabled();
            for (ArrayList<AccountPreference> accounts : hotspots2.values()) {
                for (AccountPreference accountPreference : accounts) {
                    hotspotsElement.appendChild(Functions.buildHotspotElement(accountPreference, doc));
                }
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            writer.close();
            resultat = writer.toString();
        }
        catch (ParserConfigurationException pce) {
            Log.e(pce);
        }
        catch (TransformerException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
        return resultat;
    }

    private static Element buildGeneralPreferenceNode(Element parent, Document doc, String key, String value) {
        Element element = doc.createElement("config");
        parent.appendChild(element);
        Attr attrName = doc.createAttribute("name");
        attrName.setValue(key);
        element.setAttributeNode(attrName);
        Attr attrValue = doc.createAttribute("value");
        attrValue.setValue(value);
        element.setAttributeNode(attrValue);
        return element;
    }

    private static Element buildHotspotElement(AccountPreference accountPreference, Document doc) {
        Element hotspotElement = doc.createElement("hotspot");
        Attr hotspotName = doc.createAttribute("name");
        String hotspotXmlTag = Constant.HOTSPOTS_ALL_TYPE.get(accountPreference.getType()).getXmlTagName();
        hotspotName.setValue(hotspotXmlTag);
        hotspotElement.setAttributeNode(hotspotName);
        Attr hotspotUsername = doc.createAttribute("username");
        hotspotUsername.setValue(accountPreference.getUsername());
        hotspotElement.setAttributeNode(hotspotUsername);
        Attr hotspotPassword = doc.createAttribute("password");
        hotspotPassword.setValue(accountPreference.getPassword());
        hotspotElement.setAttributeNode(hotspotPassword);
        Attr hotspotUse = doc.createAttribute("use");
        hotspotUse.setValue(String.valueOf(!accountPreference.isInactive()));
        hotspotElement.setAttributeNode(hotspotUse);
        Attr hotspotPriority = doc.createAttribute("priority");
        hotspotPriority.setValue(String.valueOf(accountPreference.getPriority()));
        hotspotElement.setAttributeNode(hotspotPriority);
        return hotspotElement;
    }

    public static void parseConfig(String content) {
        Log.i(String.valueOf(className) + " Parse du fichier de configuration");
        GlobalPreference globalPreference = Model.getInstance().getGlobalPreference();
        HotspotsPreference hotspotsPreference = Model.getInstance().getHotspotsPreference();
        try {
            String name;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
            Document doc = docBuilder.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = null;
            Element element = null;
            nodeList = doc.getElementsByTagName("config");
            Log.i(String.valueOf(className) + " Nombre de configurations \u00e0 charger : " + nodeList.getLength());
            int i = 0;
            while (i < nodeList.getLength()) {
                element = (Element)nodeList.item(i);
                name = element.getAttribute("name");
                String value = element.getAttribute("value");
                if (name.equals("launchAtStartUp")) {
                    globalPreference.setLaunchAtStartUp((boolean)Boolean.valueOf(value));
                } else if (name.equals("minimizeAtStartUp")) {
                    globalPreference.setMinimizeAtStartUp((boolean)Boolean.valueOf(value));
                } else if (name.equals("lastVersionCheck")) {
                    globalPreference.setLastVersionCheck(Long.valueOf(value));
                } else if (name.equals("automaticVersionCheck")) {
                    globalPreference.setAutomaticVersionCheck(Boolean.valueOf(value));
                } else if (name.equals("timerInterval")) {
                    globalPreference.setTimerInterval(Integer.valueOf(value));
                } else if (name.equals("debug")) {
                    StaticPreference.debug = Boolean.valueOf(value);
                } else if (name.equals("http")) {
                    globalPreference.setHttp(Boolean.valueOf(value));
                } else if (name.equals("lang")) {
                    globalPreference.setLang(value);
                } else if (name.equals("langchanged")) {
                    globalPreference.setLanguagesChanged(Boolean.valueOf(value));
                } else if (name.equals("notificationType")) {
                    globalPreference.setNotificationType(Integer.valueOf(value));
                } else if (name.equals("numberOfCheckVersionFailed")) {
                    globalPreference.setNumberOfCheckVersionFailed(Integer.valueOf(value));
                } else if (name.equals("app_locked")) {
                    globalPreference.setApp_locked(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_bouygues")) {
                    globalPreference.setHotspot_locked_bouygues(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_campus_angers")) {
                    globalPreference.setHotspot_locked_campus_angers(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_free")) {
                    globalPreference.setHotspot_locked_free(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_orange")) {
                    globalPreference.setHotspot_locked_orange(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_sfr")) {
                    globalPreference.setHotspot_locked_sfr(Boolean.valueOf(value));
                } else if (name.equals("hotspot_locked_sfr_gares")) {
                    globalPreference.setHotspot_locked_sfr_gares(Boolean.valueOf(value));
                }
                ++i;
            }
            nodeList = doc.getElementsByTagName("hotspot");
            Log.i(String.valueOf(className) + " Il y a " + nodeList.getLength() + " comptes \u00e0 charger");
            i = 0;
            while (i < nodeList.getLength()) {
                element = (Element)nodeList.item(i);
                name = element.getAttribute("name");
                int accountType = AccountPreference.getTypeFromXmlTag(name);
                String username = element.getAttribute("username");
                String password = element.getAttribute("password");
                String use = element.getAttribute("use");
                boolean isInactive = use.equals("false");
                int priority = 5;
                try {
                    priority = Integer.parseInt(element.getAttribute("priority"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AccountPreference account = new AccountPreference(accountType, username, password, priority, isInactive);
                hotspotsPreference.addAccount(account);
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            Log.e(e);
        }
        catch (SAXException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
    }

    public static String getAppId() {
        Log.i(String.valueOf(className) + " R\u00e9cup\u00e9ration AppId");
        byte[] hash = null;
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String javaVersion = System.getProperty("java.version");
        String javaVmSpecVersion = System.getProperty("java.vm.specification.version");
        String javaVmVersion = System.getProperty("java.vm.version");
        String javaClassVersion = System.getProperty("java.class.version");
        String userName = System.getProperty("user.name");
        String chaine = String.valueOf(osName) + ":" + osVersion + ":" + osArch + ":" + javaVersion + ":" + javaVmSpecVersion + ":" + javaVmVersion + ":" + javaClassVersion + ":" + userName;
        try {
            byte[] bytesOfMessage = chaine.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            hash = md.digest(bytesOfMessage);
            StringBuilder hashString = new StringBuilder();
            int i = 0;
            while (i < hash.length) {
                String hex = Integer.toHexString(hash[i]);
                if (hex.length() == 1) {
                    hashString.append('0');
                    hashString.append(hex.charAt(hex.length() - 1));
                } else {
                    hashString.append(hex.substring(hex.length() - 2));
                }
                ++i;
            }
            return hashString.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.e(e);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e(e);
        }
        return "";
    }

    public static ArrayList<String> getInfo() {
        Log.i(String.valueOf(className) + " R\u00e9cup\u00e9ration infos Syst\u00e8mes");
        ArrayList<String> info = new ArrayList<String>();
        info.add(Functions.getAppId());
        info.add(System.getProperty("os.name"));
        info.add(System.getProperty("os.version"));
        info.add(System.getProperty("os.arch"));
        info.add(System.getProperty("java.version"));
        info.add(System.getProperty("java.vm.specification.version"));
        info.add(System.getProperty("java.vm.version"));
        info.add(System.getProperty("java.class.version"));
        info.add(Constant.CURRENT_DIRECTORY);
        info.add(Log.getFichier());
        info.add("3.1.7");
        info.add(String.valueOf(57));
        return info;
    }

    public static String getRandomUrlCheckConnection() {
        Random randomGenerator = new Random();
        int index = randomGenerator.nextInt(Constant.URLS_CHECK_CONNECTION.length);
        String url = Constant.URLS_CHECK_CONNECTION[index];
        String custom = "";
        int length = 8 + randomGenerator.nextInt(6);
        int i = 0;
        while (i < length) {
            int idx = randomGenerator.nextInt(Constant.ALPHABET.length);
            custom = String.valueOf(custom) + Constant.ALPHABET[idx];
            ++i;
        }
        url = String.valueOf(url) + "/" + custom;
        Log.i(String.valueOf(className) + " Url \u00e0 appeler : " + url);
        return url;
    }

    public static String getRandomUserAgent() {
        Random randomGenerator = new Random();
        int index = randomGenerator.nextInt(Constant.USER_AGENTS.length);
        String useragent = Constant.USER_AGENTS[index];
        return useragent;
    }

    public static DefaultComboBoxModel<Integer> buildListModelFromList(ArrayList<Integer> list) {
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
        int i = 0;
        while (i < list.size()) {
            model.addElement(list.get(i));
            ++i;
        }
        return model;
    }
}

