/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.v3;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.NotificationListener;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.DialogHolder;
import fr.n3vision.hotspot.ui.common.ImagePanel;
import fr.n3vision.hotspot.ui.common.Notification;
import fr.n3vision.hotspot.ui.common.dialogs.DialogDownload;
import fr.n3vision.hotspot.ui.common.dialogs.DialogError;
import fr.n3vision.hotspot.ui.common.dialogs.DialogInfo;
import fr.n3vision.hotspot.ui.common.dialogs.DialogNewVersion;
import fr.n3vision.hotspot.ui.common.dialogs.DialogNoInternet;
import fr.n3vision.hotspot.ui.common.dialogs.DialogSSL;
import fr.n3vision.hotspot.ui.v3.BannerPanel;
import fr.n3vision.hotspot.ui.v3.MainFrame;
import fr.n3vision.hotspot.ui.v3.MainToolBar;
import fr.n3vision.hotspot.ui.v3.listener.NotificationEndListener;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainPanel
extends ImagePanel
implements NotificationEndListener,
NotificationListener {
    private static final long serialVersionUID = -1273575965516013017L;
    private String className = this.getClass().getName();
    private static URL fondUrl = MainPanel.class.getResource("/fr/n3vision/hotspot/res/fond.png");
    private JPanel countPanel = null;
    private JLabel jLabelCount = null;
    private JButton startButton = null;
    private JButton reduceButton = null;
    private BannerPanel bannerPanel = null;
    private MainFrame view;
    private Model model = null;
    private DialogHolder dialogHolder = new DialogHolder();
    private MainToolBar toolbar = null;
    private ArrayList<Notification> notifications = null;

    public MainPanel(MainFrame view) {
        super(Toolkit.getDefaultToolkit().getImage(fondUrl));
        this.view = view;
        this.model = Model.getInstance();
        this.model.setNotificationListener(this);
        this.notifications = new ArrayList();
        Log.d(String.valueOf(this.className) + " : Constructeur MainPanel");
        this.setLayout(null);
        this.toolbar = new MainToolBar();
        this.add(this.toolbar);
        this.add(this.getCountPanel());
        this.add(this.getStartButton());
        this.add(this.getReduceButton());
        if (this.model.getGlobalPreference().isApp_locked()) {
            this.getStartButton().setEnabled(false);
            this.getStartButton().setToolTipText(Lang.get("DIALOG_LOCK_APP_BUTTON"));
        }
    }

    private JPanel getCountPanel() {
        if (this.countPanel == null) {
            Log.d(String.valueOf(this.className) + " : Construction CountPanel");
            this.jLabelCount = new JLabel("00:00:00", 0);
            this.jLabelCount.setFont(new Font("SansSerif", 0, 60));
            this.jLabelCount.setForeground(Color.WHITE);
            this.jLabelCount.setBounds(new Rectangle(0, 0, 269, 146));
            URL fondUrl = this.getClass().getResource("/fr/n3vision/hotspot/res/fond_general.png");
            this.countPanel = new ImagePanel(Toolkit.getDefaultToolkit().getImage(fondUrl));
            this.countPanel.setBounds(new Rectangle(70, 12, 269, 146));
            this.countPanel.setLayout(null);
            this.countPanel.add((Component)this.jLabelCount, null);
        }
        return this.countPanel;
    }

    public JButton getStartButton() {
        if (this.startButton == null) {
            Log.d(String.valueOf(this.className) + " : Construction StartButton");
            this.startButton = new JButton(Lang.get("BUTTON_LAUNCH"));
            this.startButton.setBounds(new Rectangle(40, 162, 116, 25));
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Log.d(String.valueOf(MainPanel.this.className) + " : Clic Bouton Lancer/Arr\u00eater");
                    if (MainPanel.this.model.isLaunched()) {
                        MainPanel.this.view.stop();
                    } else if (MainPanel.this.model.getHotspotsPreference().getHotspotsAccounts().size() > 0) {
                        MainPanel.this.view.launchUI();
                    } else {
                        MainPanel.this.notify(Lang.get("DIALOG_ADD_ACCOUNT_FIRST_LONG"), Lang.get("DIALOG_ADD_ACCOUNT_FIRST_SHORT"), 1, true, false, false);
                    }
                }
            });
        }
        return this.startButton;
    }

    private JButton getReduceButton() {
        if (this.reduceButton == null) {
            this.reduceButton = new JButton(Lang.get("BUTTON_REDUCE"));
            this.reduceButton.setBounds(new Rectangle(190, 162, 116, 25));
            this.reduceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Log.i(String.valueOf(MainPanel.this.className) + " : R\u00e9duction en systray");
                    MainPanel.this.view.reduire();
                }
            });
        }
        return this.reduceButton;
    }

    @Override
    public void endOfNotification() {
        Log.d(String.valueOf(this.className) + " Fin de Notification de banner");
        if (this.bannerPanel != null) {
            Log.d(String.valueOf(this.className) + " Bandeau d\u00e9ja pr\u00e9sent, suppression");
            this.remove(this.bannerPanel);
            this.repaint();
            this.view.repaint();
            this.bannerPanel = null;
            this.changeViewTrayIcon(false);
        }
        Timer timer = new Timer();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                MainPanel.this.displayBanner();
            }
        };
        timer.schedule(tt, 1000L);
    }

    private void displayBanner() {
        Log.d(String.valueOf(this.className) + " Display Banner");
        if (this.bannerPanel == null) {
            if (this.notifications.size() > 0) {
                Log.d(String.valueOf(this.className) + " Il y a des notifications \u00e0 afficher : " + this.notifications.size());
                Notification notification = this.notifications.get(0);
                this.bannerPanel = new BannerPanel(this, notification.getType(), notification.getMessage());
                this.notifications.remove(0);
                this.add(this.bannerPanel);
                this.repaint();
                if (notification.getType() != 1) {
                    this.changeViewTrayIcon(true);
                }
            }
        } else {
            Log.d(String.valueOf(this.className) + " Un bandeau est d\u00e9ja pr\u00e9sent ! on attend la fin");
        }
    }

    public DialogHolder getDialogHolder() {
        return this.dialogHolder;
    }

    private void changeViewTrayIcon(boolean error) {
        if (error) {
            if (!this.view.isVisible()) {
                this.view.changeTrayIcon(true);
            }
        } else {
            this.view.changeTrayIcon(false);
        }
    }

    @Override
    public void notify(String longMessage, String shortMessage, int nbLigne, boolean mutex, boolean hold, boolean forceDialog) {
        if (!forceDialog) {
            switch (this.model.getGlobalPreference().getNotificationType()) {
                case 1: {
                    this.notifications.add(new Notification(1, shortMessage));
                    this.displayBanner();
                    break;
                }
                case 2: {
                    new DialogInfo(longMessage, nbLigne, mutex, this.dialogHolder, hold);
                }
            }
        } else {
            new DialogInfo(longMessage, nbLigne, mutex, this.dialogHolder, hold);
        }
    }

    @Override
    public void errorSSL(String longMessage, String shortMessage) {
        switch (this.model.getGlobalPreference().getNotificationType()) {
            case 1: {
                this.notifications.add(new Notification(2, shortMessage));
                this.displayBanner();
                break;
            }
            case 2: {
                new DialogSSL(longMessage, this.dialogHolder, true);
            }
        }
    }

    @Override
    public void newVersion(String version) {
        new DialogNewVersion(version, this.dialogHolder, false);
    }

    @Override
    public void noInternet(String longMessage, String shortMessage) {
        switch (this.model.getGlobalPreference().getNotificationType()) {
            case 1: {
                this.notifications.add(new Notification(4, shortMessage));
                this.displayBanner();
                break;
            }
            case 2: {
                new DialogNoInternet(longMessage, this.dialogHolder, true);
            }
        }
    }

    @Override
    public void error(String longMessage, String shortMessage) {
        switch (this.model.getGlobalPreference().getNotificationType()) {
            case 1: {
                this.notifications.add(new Notification(5, shortMessage));
                this.displayBanner();
                break;
            }
            case 2: {
                new DialogError(longMessage, this.dialogHolder, true);
            }
        }
    }

    @Override
    public void download(String version) {
        new DialogDownload(version, this.dialogHolder, true);
    }

    @Override
    public void count(String message) {
        this.jLabelCount.setText(message);
        this.repaint();
        this.changeTrayIconTooltip(message);
    }

    private void changeTrayIconTooltip(String additionnalText) {
        String tooltip = this.view.getOriginalTrayIconTooltip();
        if (!additionnalText.isEmpty()) {
            tooltip = String.valueOf(tooltip) + "\r\n " + additionnalText;
        }
        this.view.getTrayIcon().setToolTip(tooltip);
    }

    @Override
    public void connected() {
        if (this.bannerPanel != null) {
            this.remove(this.bannerPanel);
            this.repaint();
            this.view.repaint();
        }
        this.notifications.clear();
        this.dialogHolder.closeAll();
        JLabel labelIsConnected = this.toolbar.getLabelIsConnected();
        labelIsConnected.setText(Lang.get("TEXT_CONNECTED"));
        labelIsConnected.setBackground(new Color(211, 255, 211));
        labelIsConnected.setForeground(new Color(0, 102, 0));
        this.repaint();
    }

    @Override
    public void disconnected() {
        JLabel labelIsConnected = this.toolbar.getLabelIsConnected();
        labelIsConnected.setText(Lang.get("TEXT_DISCONNECTED"));
        labelIsConnected.setBackground(new Color(255, 211, 211));
        labelIsConnected.setForeground(new Color(163, 0, 0));
        this.repaint();
        this.changeTrayIconTooltip("");
    }

    @Override
    public void disconnectFromModel() {
        JLabel labelIsConnected = this.toolbar.getLabelIsConnected();
        labelIsConnected.setText(Lang.get("TEXT_DISCONNECTED"));
        labelIsConnected.setBackground(new Color(255, 211, 211));
        labelIsConnected.setForeground(new Color(163, 0, 0));
        this.view.stopUI();
        this.repaint();
        this.changeTrayIconTooltip("");
    }

    @Override
    public void lastHotspot(int hotspot, String lastLogin) {
        URL urlLastHotspot = null;
        if (hotspot == -1) {
            urlLastHotspot = this.getClass().getResource("/fr/n3vision/hotspot/res/hwr/normal/icon_hwr_16.png");
        } else {
            String iconString = Constant.HOTSPOTS_ALL_TYPE.get(hotspot).getIcon_16();
            urlLastHotspot = this.getClass().getResource("/fr/n3vision/hotspot/res/hotspots/" + iconString);
        }
        ImageIcon iconLastHotspot = new ImageIcon(urlLastHotspot, "");
        JLabel jImageLastHotspot = this.toolbar.getJImageLastHotspot();
        jImageLastHotspot.setIcon(iconLastHotspot);
        JLabel jlabelLastLogin = this.toolbar.getJLabelLastLogin();
        if (!lastLogin.isEmpty()) {
            jlabelLastLogin.setText("(" + lastLogin + ")");
        } else {
            jlabelLastLogin.setText("");
        }
        this.repaint();
    }

    @Override
    public void newCheck(int number) {
        JLabel jLabelNumberOfCheck = this.toolbar.getJLabelNumberOfCheck();
        jLabelNumberOfCheck.setText(String.valueOf(Lang.get("TEXT_CHECK")) + " : " + number);
        this.repaint();
    }

    @Override
    public void newReconnection(int number) {
        JLabel jLabelNumberOfReco = this.toolbar.getJLabelNumberOfReco();
        jLabelNumberOfReco.setText(String.valueOf(Lang.get("TEXT_RECO")) + " : " + number);
        this.repaint();
    }

    @Override
    public void cleanUp() {
        if (this.bannerPanel != null) {
            this.remove(this.bannerPanel);
            this.repaint();
            this.view.repaint();
        }
        this.notifications.clear();
        this.dialogHolder.closeAll();
    }

    @Override
    public void lockHotspot(String longMessage, String shortMessage) {
        switch (this.model.getGlobalPreference().getNotificationType()) {
            case 1: {
                this.notifications.add(new Notification(4, shortMessage));
                this.displayBanner();
                break;
            }
            case 2: {
                new DialogNoInternet(longMessage, this.dialogHolder, true);
            }
        }
    }

    @Override
    public void lockApp(String longMessage, String shortMessage) {
        switch (this.model.getGlobalPreference().getNotificationType()) {
            case 1: {
                this.notifications.add(new Notification(4, shortMessage));
                this.displayBanner();
                break;
            }
            case 2: {
                new DialogNoInternet(longMessage, this.dialogHolder, true);
            }
        }
        this.getStartButton().setEnabled(false);
        this.getStartButton().setToolTipText(Lang.get("DIALOG_LOCK_APP_BUTTON"));
    }

    @Override
    public void unLockApp() {
        this.getStartButton().setEnabled(true);
        this.getStartButton().setToolTipText(null);
    }

    @Override
    public void SFRNearEnd(int minutesLeft) {
        String message = minutesLeft > 1 ? Lang.get("SFR_NOTIFICATION_END_PLURIEL") : Lang.get("SFR_NOTIFICATION_END_SINGULIER");
        message = message.replace("{0}", String.valueOf(minutesLeft));
        this.view.getTrayIcon().displayMessage("HWR 3.1.7", message, TrayIcon.MessageType.INFO);
    }
}

