/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.v3;

import fr.n3vision.hotspot.Main;
import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.preference.GlobalPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.v3.MainMenu;
import fr.n3vision.hotspot.ui.v3.MainPanel;
import fr.n3vision.hotspot.util.Log;
import fr.n3vision.hotspot.util.OpenBrowser;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 6476673427654929954L;
    private String className = this.getClass().getName();
    private Model model = null;
    private GlobalPreference globalPreferences = null;
    private MainPanel mainPanel = null;
    private MainMenu mainMenu = null;
    private TrayIcon trayIcon = null;
    private Main main = null;
    private Runnable runner = new Runnable(){

        @Override
        public void run() {
            if (SystemTray.isSupported()) {
                Log.d(String.valueOf(MainFrame.this.className) + " : Systray : supported");
                SystemTray tray = SystemTray.getSystemTray();
                PopupMenu popup = new PopupMenu();
                MenuItem item0 = new MenuItem(String.valueOf(Lang.get("TEXT_TITLE")) + " " + "3.1.7");
                item0.setEnabled(false);
                popup.add(item0);
                MenuItem item1 = new MenuItem(Lang.get("MENU_SYSTRAY_REDUCE"));
                item1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Log.i(String.valueOf(MainFrame.this.className) + " : R\u00e9duction/aggrandissement en systray");
                        MainFrame.this.reduire();
                    }
                });
                popup.add(item1);
                MenuItem item2 = new MenuItem(Lang.get("MENU_SYSTRAY_HWR"));
                item2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Log.i(String.valueOf(MainFrame.this.className) + " : Ouverture n3vision.net depuis systray");
                        OpenBrowser.openURL("http://hwr.ntvapp.com/");
                    }
                });
                popup.add(item2);
                MenuItem item3 = new MenuItem(Lang.get("MENU_SYSTRAY_QUIT"));
                item3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Log.i(String.valueOf(MainFrame.this.className) + " : Fermeture depuis la systray");
                        MainFrame.this.model.getPreferencesAccess().saveConfig(false, false);
                        System.exit(0);
                    }
                });
                popup.add(item3);
                String systray_icon = MainFrame.this.getTrayIcon(false);
                URL iconUrl = this.getClass().getResource("/fr/n3vision/hotspot/res/hwr/" + systray_icon);
                Image image = Toolkit.getDefaultToolkit().getImage(iconUrl);
                MainFrame.this.trayIcon = new TrayIcon(image, MainFrame.this.getOriginalTrayIconTooltip(), popup);
                MainFrame.this.trayIcon.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getModifiers() != 1024) {
                            Log.i(String.valueOf(MainFrame.this.className) + " : R\u00e9duction/aggrandissement en systray");
                            MainFrame.this.reduire();
                        } else {
                            Log.d(String.valueOf(MainFrame.this.className) + " : Clic sur le message de notification de la trayIcon");
                            MainFrame.this.toFront();
                            MainFrame.this.repaint();
                        }
                    }
                });
                try {
                    tray.add(MainFrame.this.trayIcon);
                }
                catch (AWTException e) {
                    Log.e(String.valueOf(MainFrame.this.className) + " : Exception : impossible d'ajouter la systray Exception : " + e.getMessage());
                    Log.e(e);
                }
                if (MainFrame.this.globalPreferences.isMinimizeAtStartUp().booleanValue()) {
                    Log.i(String.valueOf(MainFrame.this.className) + " : Minimisation au d\u00e9marrage");
                    MainFrame.this.reduire();
                }
            } else {
                Log.w(String.valueOf(MainFrame.this.className) + " : SYSTRAY NOT SUPPORTED");
            }
        }
    };

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public String getOriginalTrayIconTooltip() {
        return String.valueOf(Lang.get("TEXT_TITLE")) + " " + "3.1.7";
    }

    public MainFrame(Main main) {
        this.main = main;
        this.mainPanel = new MainPanel(this);
        this.model = Model.getInstance();
        this.globalPreferences = this.model.getGlobalPreference();
        this.setContentPane(this.mainPanel);
        this.mainMenu = new MainMenu(this);
        this.setJMenuBar(this.mainMenu);
        if (!this.globalPreferences.isLanguagesChanged()) {
            Log.d(String.valueOf(this.className) + " : La pr\u00e9f\u00e9rence n'a jamais \u00e9t\u00e9 chang\u00e9e manuellement, recherche de la langue du PC");
            this.getLang();
        }
        Log.d(String.valueOf(this.className) + " : Constructeur MainView");
        if (System.getProperty("os.name").contains("Mac")) {
            Log.d(String.valueOf(this.className) + " : C'est un mac");
            this.setSize(408, 251);
        } else if (System.getProperty("os.name").contains("SunOS")) {
            Log.d(String.valueOf(this.className) + " : C'est un Solaris");
            this.setSize(412, 251);
        } else {
            Log.d(String.valueOf(this.className) + " : Ce n'est pas un Mac");
            this.setSize(414, 271);
        }
        URL iconUrl = MainFrame.class.getResource("/fr/n3vision/hotspot/res/hwr/normal/icon_hwr_64_marge.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconUrl));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setTitle(Lang.get("TEXT_TITLE"));
        this.setVisible(true);
        this.repaint();
        EventQueue.invokeLater(this.runner);
        if (this.globalPreferences.isLaunchAtStartUp().booleanValue()) {
            Log.i(String.valueOf(this.className) + " : Lancement automatique");
            this.launchUI();
        }
    }

    private void getLang() {
        String lang = System.getProperty("user.language");
        Log.d(String.valueOf(this.className) + " : Langue d\u00e9tect\u00e9e :" + lang);
        if (System.getProperty("user.language").equals("en")) {
            this.globalPreferences.setLang(System.getProperty("user.language"));
        } else {
            this.globalPreferences.setLang("fr");
        }
        Log.d(String.valueOf(this.className) + " : Lange Appliqu\u00e9e : " + this.globalPreferences.getLang());
    }

    public void launchUI() {
        this.mainMenu.lockPreferences();
        this.mainPanel.getStartButton().setText(Lang.get("BUTTON_LAUNCH"));
        Log.i(String.valueOf(this.className) + " : Pas d'erreur : lancement du processus");
        this.mainPanel.getStartButton().setText(Lang.get("BUTTON_STOP"));
        this.model.start();
    }

    public void stop() {
        Log.i(String.valueOf(this.className) + " : Method Stop()");
        this.model.stop();
        this.stopUI();
    }

    public void stopUI() {
        this.mainPanel.lastHotspot(-1, "");
        this.mainPanel.newCheck(0);
        this.mainPanel.newReconnection(0);
        Log.i(String.valueOf(this.className) + " : Method StopUI()");
        this.mainPanel.getStartButton().setText(Lang.get("BUTTON_LAUNCH"));
        this.mainMenu.unlockPreferences();
    }

    public void reduire() {
        if (this.isVisible()) {
            Log.i(String.valueOf(this.className) + " : R\u00e9duction en systray");
            this.setVisible(false);
            this.main.changeMacDockIcon(true);
        } else {
            Log.i(String.valueOf(this.className) + " : Aggrandissement depuis la systray");
            this.setVisible(true);
            this.main.changeMacDockIcon(false);
            this.changeTrayIcon(false);
        }
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public void changeTrayIcon(boolean error) {
        String systray_icon = this.getTrayIcon(error);
        URL iconUrl = this.getClass().getResource("/fr/n3vision/hotspot/res/hwr/" + systray_icon);
        Image image = Toolkit.getDefaultToolkit().getImage(iconUrl);
        this.trayIcon.setImage(image);
    }

    private String getTrayIcon(boolean error) {
        String iconStr = "";
        if (error) {
            iconStr = "error/icon_hwr_16.png";
            if (System.getProperty("os.name").contains("Linux")) {
                iconStr = "error/icon_hwr_24_marge.png";
            } else if (System.getProperty("os.name").contains("Mac")) {
                iconStr = "error/icon_hwr_24_marge.png";
            }
        } else {
            iconStr = "normal/icon_hwr_16.png";
            if (System.getProperty("os.name").contains("Linux")) {
                iconStr = "normal/icon_hwr_24_marge.png";
            } else if (System.getProperty("os.name").contains("Mac")) {
                iconStr = "normal/icon_hwr_24_marge.png";
            }
        }
        return iconStr;
    }
}

