/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.v3;

import fr.n3vision.hotspot.ui.common.JImageButton;
import fr.n3vision.hotspot.ui.v3.listener.NotificationEndListener;
import fr.n3vision.hotspot.util.Log;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BannerPanel
extends JPanel {
    private static final long serialVersionUID = -1361880759749574125L;
    private String className = this.getClass().getName();
    private NotificationEndListener notificationListeners = null;
    private JLabel label = null;
    private JLabel image = null;
    private JImageButton close = null;
    private int notificationType = 0;
    private String message;
    private Timer timer = null;

    public BannerPanel(NotificationEndListener listener, int notificationType, String message) {
        Log.d(String.valueOf(this.className) + " : Constructeur BannerPanel");
        this.notificationListeners = listener;
        this.notificationType = notificationType;
        this.message = message;
        this.setBounds(0, 0, 410, 25);
        this.setLayout(null);
        this.add(this.getIcon());
        this.add(this.getLabel());
        this.add(this.getCloseIcon());
        this.timer = new Timer();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                Log.d(String.valueOf(BannerPanel.this.className) + " : Timer End of Notification");
                BannerPanel.this.fireEndOfDisplayingNotification();
            }
        };
        this.timer.schedule(tt, 10000L);
    }

    public void resetTimerEndOfDisplaying() {
        this.timer.cancel();
        this.timer.purge();
    }

    private JLabel getIcon() {
        if (this.image == null) {
            this.image = new JLabel();
            this.image.setBounds(new Rectangle(4, 5, 16, 16));
        }
        return this.image;
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.message);
            this.label.setBounds(25, 3, 350, 20);
        }
        return this.label;
    }

    private JImageButton getCloseIcon() {
        if (this.close == null) {
            this.close = new JImageButton("/fr/n3vision/hotspot/res/icon_hide_banner.png");
            this.close.setBounds(new Rectangle(390, 4, 16, 16));
            this.close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Log.d(String.valueOf(BannerPanel.this.className) + " : Click on close icon");
                    BannerPanel.this.resetTimerEndOfDisplaying();
                    BannerPanel.this.fireEndOfDisplayingNotification();
                }
            });
        }
        return this.close;
    }

    private void fireEndOfDisplayingNotification() {
        this.notificationListeners.endOfNotification();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        URL url = null;
        ImageIcon icon = null;
        Color backgroung = null;
        Color foreground = null;
        switch (this.notificationType) {
            case 2: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_ssl_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(237, 161, 79);
                foreground = new Color(130, 76, 19);
                break;
            }
            case 3: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_new_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(169, 231, 164);
                foreground = new Color(17, 107, 10);
                break;
            }
            case 4: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_warning_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(241, 230, 135);
                foreground = new Color(111, 100, 10);
                break;
            }
            case 5: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_error_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(241, 137, 129);
                foreground = new Color(116, 14, 6);
                break;
            }
            case 6: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_valid_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(169, 231, 164);
                foreground = new Color(17, 107, 10);
                break;
            }
            default: {
                url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_info_16.png");
                icon = new ImageIcon(url, "");
                backgroung = new Color(160, 223, 255);
                foreground = new Color(19, 126, 181);
            }
        }
        this.image.setIcon(icon);
        this.setBackground(backgroung);
        this.label.setForeground(foreground);
    }
}

