/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.preferences;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.preference.GlobalPreference;
import fr.n3vision.hotspot.core.preference.StaticPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelConfig
extends JPanel {
    private static final long serialVersionUID = 2326393534283879191L;
    private final String className = this.getClass().getName();
    private Model model;
    private GlobalPreference globalPreferences;
    private JLabel title = null;
    private JCheckBox cbStartAtLaunch = null;
    private JCheckBox cbStartMinimized;
    private JCheckBox cbAutoUpdate;
    private JCheckBox cbDebug;
    private JCheckBox cbForceHttp;
    private JComboBox<?> selectInterval;
    private JComboBox<?> selectNotificationType;

    public PanelConfig() {
        Log.d(String.valueOf(this.className) + " : constructeur PanelConfig (preferences)");
        this.model = Model.getInstance();
        this.globalPreferences = this.model.getGlobalPreference();
        this.setLayout(null);
        this.add(this.getTitle());
        this.add(this.getStartAtLaunch());
        this.add(this.getStartMinimized());
        this.add(this.getAutoUpdate());
        this.add(this.getEnableDebug());
        this.add(this.getForceHttp());
        this.add(this.getIntervalBetweenCheck());
        this.add(this.getNotificationType());
        Log.d(String.valueOf(this.className) + " Fin d'affichage de Panel Config");
    }

    private JLabel getTitle() {
        if (this.title == null) {
            this.title = new JLabel(Lang.get("TEXT_PREF_LABEL_PREFERENCE"), 0);
            this.title.setFont(new Font("SansSerif", 0, 30));
            this.title.setBounds(new Rectangle(10, 0, 650, 40));
        }
        return this.title;
    }

    private JCheckBox getStartAtLaunch() {
        if (this.cbStartAtLaunch == null) {
            this.cbStartAtLaunch = new JCheckBox(Lang.get("TEXT_PREF_GENERAL_LAUNCH"));
            this.cbStartAtLaunch.setSelected(this.globalPreferences.isLaunchAtStartUp());
            this.cbStartAtLaunch.setBounds(new Rectangle(10, 40, 300, 25));
            this.cbStartAtLaunch.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : launch at startup : " + String.valueOf(PanelConfig.this.cbStartAtLaunch.isSelected()));
                    PanelConfig.this.globalPreferences.setLaunchAtStartUp(PanelConfig.this.cbStartAtLaunch.isSelected());
                }
            });
        }
        return this.cbStartAtLaunch;
    }

    private JCheckBox getStartMinimized() {
        if (this.cbStartMinimized == null) {
            this.cbStartMinimized = new JCheckBox(Lang.get("TEXT_PREF_GENERAL_MINIMIZE"));
            this.cbStartMinimized.setSelected(this.globalPreferences.isMinimizeAtStartUp());
            this.cbStartMinimized.setBounds(new Rectangle(10, 80, 300, 25));
            this.cbStartMinimized.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : minimiezed : " + String.valueOf(PanelConfig.this.cbStartMinimized.isSelected()));
                    PanelConfig.this.globalPreferences.setMinimizeAtStartUp(PanelConfig.this.cbStartMinimized.isSelected());
                }
            });
        }
        return this.cbStartMinimized;
    }

    private JCheckBox getAutoUpdate() {
        if (this.cbAutoUpdate == null) {
            this.cbAutoUpdate = new JCheckBox(Lang.get("TEXT_PREF_AUTO_UPDATE"));
            this.cbAutoUpdate.setSelected(this.globalPreferences.isAutomaticVersionCheck());
            this.cbAutoUpdate.setBounds(new Rectangle(10, 120, 300, 25));
            this.cbAutoUpdate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : autoUpdate : " + String.valueOf(PanelConfig.this.cbAutoUpdate.isSelected()));
                    PanelConfig.this.globalPreferences.setAutomaticVersionCheck(PanelConfig.this.cbAutoUpdate.isSelected());
                }
            });
        }
        return this.cbAutoUpdate;
    }

    private JCheckBox getEnableDebug() {
        if (this.cbDebug == null) {
            this.cbDebug = new JCheckBox(Lang.get("TEXT_PREF_DEBUG"));
            this.cbDebug.setSelected(StaticPreference.debug);
            this.cbDebug.setFont(new Font("SansSerif", 2, 11));
            this.cbDebug.setBounds(new Rectangle(10, 160, 300, 25));
            this.cbDebug.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : debug : " + String.valueOf(PanelConfig.this.cbDebug.isSelected()));
                    StaticPreference.debug = PanelConfig.this.cbDebug.isSelected();
                }
            });
        }
        return this.cbDebug;
    }

    private JCheckBox getForceHttp() {
        if (this.cbForceHttp == null) {
            this.cbForceHttp = new JCheckBox(Lang.get("TEXT_PREF_HTTP"));
            this.cbForceHttp.setSelected(this.globalPreferences.isHttp());
            this.cbForceHttp.setFont(new Font("SansSerif", 2, 11));
            this.cbForceHttp.setBounds(new Rectangle(10, 200, 300, 25));
            this.cbForceHttp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : FORCEHTTP : " + String.valueOf(PanelConfig.this.cbForceHttp.isSelected()));
                    PanelConfig.this.globalPreferences.setHttp(PanelConfig.this.cbForceHttp.isSelected());
                }
            });
        }
        return this.cbForceHttp;
    }

    private JComboBox getIntervalBetweenCheck() {
        if (this.selectInterval == null) {
            this.selectInterval = new JComboBox<Object>((Object[])Constant.LIST_INTERVAL_NAME.get(this.globalPreferences.getLang()));
            this.selectInterval.setSelectedIndex(Functions.getIndexFromInterval(this.globalPreferences.getTimerInterval()));
            this.selectInterval.setBounds(new Rectangle(10, 240, 300, 25));
            this.selectInterval.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : Interval : " + Constant.LIST_INTERVAL_VALUES[PanelConfig.this.selectInterval.getSelectedIndex()]);
                    PanelConfig.this.globalPreferences.setTimerInterval(Constant.LIST_INTERVAL_VALUES[PanelConfig.this.selectInterval.getSelectedIndex()]);
                }
            });
        }
        return this.selectInterval;
    }

    private JComboBox getNotificationType() {
        if (this.selectNotificationType == null) {
            this.selectNotificationType = new JComboBox<Object>((Object[])Constant.LIST_NOTIFICATION_TYPE.get(this.globalPreferences.getLang()));
            this.selectNotificationType.setSelectedIndex(Functions.getIndexFromNotificationType(this.globalPreferences.getNotificationType()));
            this.selectNotificationType.setBounds(new Rectangle(10, 280, 300, 25));
            this.selectNotificationType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Log.i(String.valueOf(PanelConfig.this.className) + " : Pref : Notification Type : " + Constant.LIST_NOTIFICATION_VALUE[PanelConfig.this.selectNotificationType.getSelectedIndex()]);
                    PanelConfig.this.globalPreferences.setNotificationType(Constant.LIST_NOTIFICATION_VALUE[PanelConfig.this.selectNotificationType.getSelectedIndex()]);
                }
            });
        }
        return this.selectNotificationType;
    }
}

