/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.preferences;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.preference.AccountDisabledComparator;
import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.Notification;
import fr.n3vision.hotspot.ui.preferences.AccountRenderer;
import fr.n3vision.hotspot.ui.preferences.AddAccountPanel;
import fr.n3vision.hotspot.ui.preferences.DefaultRightPanel;
import fr.n3vision.hotspot.ui.preferences.EditAccountPanel;
import fr.n3vision.hotspot.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PanelAccounts
extends JPanel {
    private String className = this.getClass().getName();
    private static final long serialVersionUID = -4321777490098929632L;
    StringSelection transferable;
    private HotspotsPreference hotspotsPreference = Model.getInstance().getHotspotsPreference();
    private JPanel leftPanel = null;
    private JPanel rightPanel = null;
    private JButton buttonAdd = null;
    private JScrollPane scrollPane = null;
    private JList<AccountPreference> list = null;
    private DefaultListModel<AccountPreference> model = null;
    private DefaultRightPanel defaultRightPanel = null;

    public PanelAccounts() {
        this.setLayout(null);
        this.model = new DefaultListModel();
        this.defaultRightPanel = new DefaultRightPanel();
        this.add(this.getLeftPanel());
        this.add(this.getRightPanel());
        Log.d(String.valueOf(this.className) + " Fin d'affichage de Panel Accounts");
    }

    private JPanel getLeftPanel() {
        if (this.leftPanel == null) {
            this.leftPanel = new JPanel();
            this.leftPanel.setLayout(new BorderLayout());
            this.leftPanel.setSize(new Dimension(250, 480));
            this.leftPanel.setPreferredSize(this.leftPanel.getSize());
            this.leftPanel.setLocation(0, 0);
            this.leftPanel.add((Component)this.getButtonAdd(), "North");
            this.leftPanel.add((Component)this.getScrollPane(), "Center");
        }
        return this.leftPanel;
    }

    private JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(null);
            this.rightPanel.setSize(new Dimension(390, 480));
            this.rightPanel.setPreferredSize(this.rightPanel.getSize());
            this.rightPanel.setLocation(250, 0);
            this.displayDefaultRightPanel(null);
        }
        return this.rightPanel;
    }

    private JButton getButtonAdd() {
        if (this.buttonAdd == null) {
            this.buttonAdd = new JButton(Lang.get("TEXT_PREF_BUTTON_ADD_ACCOUNT"));
            this.buttonAdd.setBounds(0, 0, 300, 30);
            this.buttonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Log.d(String.valueOf(PanelAccounts.this.className) + " Clic bouton Ajout d'un nouveau Compte");
                    PanelAccounts.this.list.clearSelection();
                    PanelAccounts.this.displayAddAccountRightPanel();
                }
            });
        }
        return this.buttonAdd;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getAccountList());
        }
        return this.scrollPane;
    }

    private JList<AccountPreference> getAccountList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setCellRenderer(new AccountRenderer());
            this.list.setSelectionMode(0);
            this.list.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    if (PanelAccounts.this.model.size() > 0) {
                        int idx = PanelAccounts.this.list.getSelectedIndex();
                        AccountPreference account = (AccountPreference)PanelAccounts.this.model.get(idx);
                        Log.d(String.valueOf(PanelAccounts.this.className) + " Compte r\u00e9cup\u00e9r\u00e9 : " + account.getUsername());
                        PanelAccounts.this.displayEditAccountRightPanel(account);
                    }
                }
            });
            this.refreshList(null);
        }
        return this.list;
    }

    public void refreshList(AccountPreference selectAccount) {
        Log.d(String.valueOf(this.className) + " Raffraichissement de la liste des comptes");
        this.hotspotsPreference.printAccounts();
        HashMap<Integer, ArrayList<AccountPreference>> listWithAllAccount = new HashMap<Integer, ArrayList<AccountPreference>>();
        Collection<ArrayList<AccountPreference>> accountsEnabled = this.hotspotsPreference.getHotspotsAccounts().values();
        for (ArrayList<AccountPreference> arrayList : accountsEnabled) {
            for (AccountPreference accountPreference : arrayList) {
                ArrayList accountPreferences = (ArrayList)listWithAllAccount.get(accountPreference.getType());
                if (accountPreferences == null) {
                    accountPreferences = new ArrayList();
                    listWithAllAccount.put(accountPreference.getType(), accountPreferences);
                }
                accountPreferences.add(accountPreference);
            }
        }
        Collection<ArrayList<AccountPreference>> accountsFromModel = this.hotspotsPreference.getHotspotsAccountsDisabled().values();
        for (ArrayList<AccountPreference> arrayList : accountsFromModel) {
            for (AccountPreference accountPreference : arrayList) {
                ArrayList<AccountPreference> accountPreferences = (ArrayList<AccountPreference>)listWithAllAccount.get(accountPreference.getType());
                if (accountPreferences == null) {
                    accountPreferences = new ArrayList<AccountPreference>();
                    listWithAllAccount.put(accountPreference.getType(), accountPreferences);
                }
                accountPreferences.add(accountPreference);
            }
        }
        Collection accountsFromThirdList = listWithAllAccount.values();
        ArrayList<AccountPreference> arrayList = new ArrayList<AccountPreference>();
        for (ArrayList arrayList2 : accountsFromThirdList) {
            Collections.sort(arrayList2, new AccountDisabledComparator());
            for (AccountPreference accountPreference : arrayList2) {
                arrayList.add(accountPreference);
            }
        }
        Log.d(String.valueOf(this.className) + " Il y a " + arrayList.size() + " compte(s) \u00e0 afficher");
        this.model.removeAllElements();
        int indexToSelect = 0;
        int i = 0;
        while (i < arrayList.size()) {
            this.model.add(i, (AccountPreference)arrayList.get(i));
            if (selectAccount != null && selectAccount == arrayList.get(i)) {
                indexToSelect = i;
            }
            ++i;
        }
        this.list.setModel(this.model);
        if (selectAccount != null) {
            this.list.setSelectedIndex(indexToSelect);
        }
        this.list.repaint();
    }

    public void displayDefaultRightPanel(Notification notification) {
        this.rightPanel.removeAll();
        this.rightPanel.add(this.defaultRightPanel);
        this.defaultRightPanel.displayMessage(notification);
        this.repaint();
    }

    private void displayAddAccountRightPanel() {
        this.rightPanel.removeAll();
        this.rightPanel.add(new AddAccountPanel(this));
        this.rightPanel.updateUI();
        this.repaint();
    }

    private void displayEditAccountRightPanel(AccountPreference account) {
        this.rightPanel.removeAll();
        this.rightPanel.add(new EditAccountPanel(account, this));
        this.rightPanel.updateUI();
        this.repaint();
    }

    public void resetDefaultRightPanelBannerTimer() {
        this.defaultRightPanel.resetTimerEndOfDisplayingBanner();
    }
}

