/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.preferences;

import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.preferences.MainDialog;
import fr.n3vision.hotspot.ui.preferences.PanelAccounts;
import fr.n3vision.hotspot.ui.preferences.PanelConfig;
import fr.n3vision.hotspot.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainPanel
extends JPanel {
    private static final long serialVersionUID = -3453012643483702406L;
    private String className = this.getClass().getName();
    private JTabbedPane jTabbedPane = null;
    private MainDialog dialog;
    private JButton buttonSave;

    public MainPanel(MainDialog dialog) {
        this.dialog = dialog;
        Log.d(String.valueOf(this.className) + " : constructeur MainPanel (preferences)");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJTabbedPane(), "Center");
        this.add((Component)this.getSaveButton(), "South");
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            Log.d(String.valueOf(this.className) + " : initialisation TabPane Preferences");
            this.jTabbedPane = new JTabbedPane(1);
            this.jTabbedPane.setOpaque(false);
            URL url_icon_config = this.getClass().getResource("/fr/n3vision/hotspot/res/icon_config.png");
            ImageIcon icon_config = new ImageIcon(url_icon_config, "");
            URL url_icon_account = this.getClass().getResource("/fr/n3vision/hotspot/res/icon_account.png");
            ImageIcon icon_account = new ImageIcon(url_icon_account, "");
            this.jTabbedPane.addTab(Lang.get("TEXT_TAB_CONFIGURATION"), icon_config, new PanelConfig());
            this.jTabbedPane.addTab(Lang.get("TEXT_TAB_ACCOUNT"), icon_account, new PanelAccounts());
        }
        return this.jTabbedPane;
    }

    private JButton getSaveButton() {
        if (this.buttonSave == null) {
            this.buttonSave = new JButton(Lang.get("TEXT_PREF_SAVE"));
            this.buttonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainPanel.this.dialog.dispose();
                }
            });
        }
        return this.buttonSave;
    }
}

