/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.preferences;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.PreferencesAccess;
import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.Notification;
import fr.n3vision.hotspot.ui.preferences.HotspotTypeRenderer;
import fr.n3vision.hotspot.ui.preferences.PanelAccounts;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class EditAccountPanel
extends JPanel {
    private String className = this.getClass().getName();
    private static final long serialVersionUID = -7674125929535884440L;
    private HotspotsPreference hotspotsPreference = Model.getInstance().getHotspotsPreference();
    private PreferencesAccess preferencesAccess = Model.getInstance().getPreferencesAccess();
    private int hotspotType = 0;
    private AccountPreference account;
    private PanelAccounts view;
    private JLabel labelEditOk = null;
    private JButton buttonDelete = null;
    private JLabel labelDeleteConfirm = null;
    private JButton buttonDeleteConfirm = null;
    private JCheckBox cbInactive = null;
    private JComboBox<?> selectType = null;
    private JTextField textUsername = null;
    private JPasswordField textPassword = null;

    public EditAccountPanel(final AccountPreference account, final PanelAccounts view) {
        this.view = view;
        this.account = account;
        view.resetDefaultRightPanelBannerTimer();
        this.setLayout(null);
        this.setBounds(0, 0, 390, 480);
        this.hotspotType = account.getType();
        int index = Constant.HOTSPOTS_DISTINCT_TYPE.indexOf(this.hotspotType);
        JLabel labelEdit = new JLabel(Lang.get("TEXT_PREF_LABEL_EDIT_ACCOUNT"), 0);
        labelEdit.setFont(new Font("SansSerif", 0, 30));
        labelEdit.setBounds(0, 0, 390, 40);
        this.add(labelEdit);
        this.cbInactive = new JCheckBox();
        this.cbInactive.setText(Lang.get("TEXT_PREF_LABEL_HOTSPOT_INACTIVE"));
        this.cbInactive.setBounds(10, 65, 200, 25);
        this.cbInactive.setSelected(account.isInactive());
        this.add(this.cbInactive);
        JLabel labelType = new JLabel(Lang.get("TEXT_PREF_LABEL_HOTSPOT_TYPE"), 4);
        labelType.setBounds(10, 110, 150, 25);
        this.add(labelType);
        DefaultComboBoxModel<Integer> types = Functions.buildListModelFromList(Constant.HOTSPOTS_DISTINCT_TYPE);
        this.selectType = new JComboBox<Integer>(types);
        this.selectType.setBounds(170, 100, 200, 40);
        this.selectType.setSelectedIndex(index);
        this.selectType.setRenderer(new HotspotTypeRenderer());
        this.selectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditAccountPanel.this.changeAccountType();
            }
        });
        this.add(this.selectType);
        JLabel labelUsername = new JLabel(Lang.get("TEXT_PREF_LABEL_USERNAME"), 4);
        labelUsername.setBounds(10, 160, 150, 25);
        this.add(labelUsername);
        this.textUsername = new JTextField();
        this.textUsername.setText(account.getUsername());
        this.textUsername.setBounds(170, 150, 200, 40);
        this.textUsername.setFont(new Font("SansSerif", 0, 15));
        this.add(this.textUsername);
        JLabel labelPassword = new JLabel(Lang.get("TEXT_PREF_LABEL_PASSWORD"), 4);
        labelPassword.setBounds(10, 210, 150, 25);
        this.add(labelPassword);
        this.textPassword = new JPasswordField();
        this.textPassword.setText(account.getPassword());
        this.textPassword.setBounds(170, 200, 200, 40);
        this.textPassword.setFont(new Font("SansSerif", 0, 15));
        this.add(this.textPassword);
        JButton buttonPriorityDown = new JButton(Lang.get("TEXT_PREF_BUTTON_PRIORITY_DOWN"));
        buttonPriorityDown.setBounds(70, 250, 110, 30);
        buttonPriorityDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EditAccountPanel.this.hotspotsPreference.priorityUp(account);
                EditAccountPanel.this.saveAndRefresh(account);
            }
        });
        this.add(buttonPriorityDown);
        JButton buttonPriorityUp = new JButton(Lang.get("TEXT_PREF_BUTTON_PRIORITY_UP"));
        buttonPriorityUp.setBounds(210, 250, 110, 30);
        buttonPriorityUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EditAccountPanel.this.hotspotsPreference.priorityDown(account);
                EditAccountPanel.this.saveAndRefresh(account);
            }
        });
        this.add(buttonPriorityUp);
        this.labelDeleteConfirm = new JLabel(Lang.get("TEXT_PREF_LABEL_DELETE_CONFIRM"), 4);
        this.labelDeleteConfirm.setForeground(new Color(28, 121, 0));
        this.labelDeleteConfirm.setBounds(10, 290, 170, 25);
        this.labelDeleteConfirm.setVisible(false);
        this.add(this.labelDeleteConfirm);
        this.buttonDeleteConfirm = new JButton(Lang.get("TEXT_PREF_BUTTON_DELETE_CONFIRM"));
        this.buttonDeleteConfirm.setBounds(200, 290, 120, 30);
        this.buttonDeleteConfirm.setVisible(false);
        this.buttonDeleteConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log.d(String.valueOf(EditAccountPanel.this.className) + " Bouton Suppression Compte Confirmation");
                EditAccountPanel.this.hotspotsPreference.removeAccount(account);
                EditAccountPanel.this.deleteAccount();
            }
        });
        this.add(this.buttonDeleteConfirm);
        this.buttonDelete = new JButton(Lang.get("TEXT_PREF_BUTTON_DELETE"));
        this.buttonDelete.setBounds(120, 330, 150, 30);
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log.d(String.valueOf(EditAccountPanel.this.className) + " Bouton Suppression Compte, affichage confirmaton");
                EditAccountPanel.this.buttonDelete.setEnabled(false);
                EditAccountPanel.this.labelDeleteConfirm.setVisible(true);
                EditAccountPanel.this.buttonDeleteConfirm.setVisible(true);
            }
        });
        this.add(this.buttonDelete);
        JButton buttonSubmit = new JButton(Lang.get("TEXT_PREF_BUTTON_EDIT"));
        buttonSubmit.setBounds(40, 370, 150, 30);
        buttonSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EditAccountPanel.this.editAccount();
            }
        });
        this.add(buttonSubmit);
        JButton buttonCancel = new JButton(Lang.get("TEXT_PREF_BUTTON_CANCEL_EDIT"));
        buttonCancel.setBounds(200, 370, 150, 30);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log.d(String.valueOf(EditAccountPanel.this.className) + " Bouton Annuler edit");
                view.displayDefaultRightPanel(null);
            }
        });
        this.add(buttonCancel);
        this.labelEditOk = new JLabel(Lang.get("TEXT_PREF_LABEL_EDIT_OK"), 0);
        this.labelEditOk.setFont(new Font("SansSerif", 0, 20));
        this.labelEditOk.setForeground(new Color(28, 121, 0));
        this.labelEditOk.setBounds(0, 410, 420, 25);
        this.labelEditOk.setVisible(false);
        this.add(this.labelEditOk);
    }

    private void saveAndRefresh(AccountPreference account) {
        Log.d(String.valueOf(this.className) + " Save And Refresh");
        this.preferencesAccess.saveConfig(false, false);
        this.view.refreshList(account);
    }

    private void changeAccountType() {
        int hotspotType = Constant.HOTSPOTS_DISTINCT_TYPE.get(this.selectType.getSelectedIndex());
        if (hotspotType != this.account.getType()) {
            Log.d(String.valueOf(this.className) + " Changement de type pour le compte " + this.account.getUsername());
            this.hotspotsPreference.changeAccountType(this.account, hotspotType);
            this.account.setType(hotspotType);
            this.saveAndRefresh(this.account);
        }
    }

    private void deleteAccount() {
        this.saveAndRefresh(null);
        String message = Lang.get("TEXT_PREF_LABEL_ACCOUNT_DELETED");
        message = message.replace("###ACCOUNT###", this.account.getUsername());
        this.view.displayDefaultRightPanel(new Notification(6, message));
    }

    private void editAccount() {
        String username = this.textUsername.getText();
        String password = new String(this.textPassword.getPassword());
        boolean inactive = this.cbInactive.isSelected();
        if (inactive != this.account.isInactive()) {
            Log.d(String.valueOf(this.className) + " Changement de inactif d\u00e9tect\u00e9");
            this.hotspotsPreference.changeAccountDisability(this.account, inactive);
        }
        boolean error = false;
        if (username.isEmpty()) {
            error = true;
            this.textUsername.setBackground(Color.pink);
        } else {
            this.textUsername.setBackground(null);
        }
        if (password.isEmpty()) {
            error = true;
            this.textPassword.setBackground(Color.pink);
        } else {
            this.textPassword.setBackground(null);
        }
        if (!error) {
            this.account.setUsername(username);
            this.account.setPassword(password);
            this.saveAndRefresh(this.account);
            this.labelEditOk.setVisible(true);
            Timer timer = new Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    EditAccountPanel.this.labelEditOk.setVisible(false);
                }
            };
            timer.schedule(tt, 5000L);
        }
    }
}

