/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.preferences;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.Notification;
import fr.n3vision.hotspot.ui.preferences.HotspotTypeRenderer;
import fr.n3vision.hotspot.ui.preferences.PanelAccounts;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AddAccountPanel
extends JPanel {
    private String className = this.getClass().getName();
    private static final long serialVersionUID = -7867729490791887761L;
    private HotspotsPreference hotspotsPreference = Model.getInstance().getHotspotsPreference();
    private PanelAccounts view = null;
    private JCheckBox cbInactive = null;
    private JComboBox<?> selectType = null;
    private JTextField textUsername = null;
    private JPasswordField textPassword = null;

    public AddAccountPanel(final PanelAccounts view) {
        this.view = view;
        this.setLayout(null);
        this.setBounds(0, 0, 390, 480);
        view.resetDefaultRightPanelBannerTimer();
        JLabel labelTitle = new JLabel(Lang.get("TEXT_PREF_LABEL_ADD_ACCOUNT"), 0);
        labelTitle.setFont(new Font("SansSerif", 0, 30));
        labelTitle.setBounds(0, 0, 390, 40);
        this.add(labelTitle);
        this.cbInactive = new JCheckBox();
        this.cbInactive.setText(Lang.get("TEXT_PREF_LABEL_HOTSPOT_INACTIVE"));
        this.cbInactive.setBounds(10, 65, 200, 25);
        this.cbInactive.setSelected(false);
        this.add(this.cbInactive);
        JLabel labelType = new JLabel(Lang.get("TEXT_PREF_LABEL_HOTSPOT_TYPE"), 4);
        labelType.setBounds(10, 110, 150, 25);
        this.add(labelType);
        DefaultComboBoxModel<Integer> types = Functions.buildListModelFromList(Constant.HOTSPOTS_DISTINCT_TYPE);
        this.selectType = new JComboBox<Integer>(types);
        this.selectType.setSelectedIndex(0);
        this.selectType.setBounds(170, 100, 200, 40);
        this.selectType.setRenderer(new HotspotTypeRenderer());
        this.add(this.selectType);
        JLabel labelUsername = new JLabel(Lang.get("TEXT_PREF_LABEL_USERNAME"), 4);
        labelUsername.setBounds(10, 160, 150, 25);
        this.add(labelUsername);
        this.textUsername = new JTextField();
        this.textUsername.setBounds(170, 150, 200, 40);
        this.textUsername.setFont(new Font("SansSerif", 0, 15));
        this.add(this.textUsername);
        JLabel labelPassword = new JLabel(Lang.get("TEXT_PREF_LABEL_PASSWORD"), 4);
        labelPassword.setBounds(10, 210, 150, 25);
        this.add(labelPassword);
        this.textPassword = new JPasswordField();
        this.textPassword.setBounds(170, 200, 200, 40);
        this.textPassword.setFont(new Font("SansSerif", 0, 15));
        this.add(this.textPassword);
        JButton buttonSubmit = new JButton(Lang.get("TEXT_PREF_BUTTON_ADD"));
        buttonSubmit.setBounds(40, 370, 150, 30);
        buttonSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log.d(String.valueOf(AddAccountPanel.this.className) + " Bouton ajouter pour add Account");
                AddAccountPanel.this.addAccount();
            }
        });
        this.add(buttonSubmit);
        JButton buttonCancel = new JButton(Lang.get("TEXT_PREF_BUTTON_CANCEL_ADD"));
        buttonCancel.setBounds(200, 370, 150, 30);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log.d(String.valueOf(AddAccountPanel.this.className) + " Bouton Annuler add");
                view.displayDefaultRightPanel(null);
            }
        });
        this.add(buttonCancel);
    }

    private void addAccount() {
        String username = this.textUsername.getText();
        String password = new String(this.textPassword.getPassword());
        int hotspotType = Constant.HOTSPOTS_DISTINCT_TYPE.get(this.selectType.getSelectedIndex());
        int priority = 0;
        boolean inactive = this.cbInactive.isSelected();
        boolean error = false;
        if (username.isEmpty()) {
            error = true;
            this.textUsername.setBackground(Color.pink);
        } else {
            this.textUsername.setBackground(null);
        }
        if (password.isEmpty()) {
            error = true;
            this.textPassword.setBackground(Color.pink);
        } else {
            this.textPassword.setBackground(null);
        }
        if (!error) {
            AccountPreference account = new AccountPreference(hotspotType, username, password, priority, inactive);
            this.hotspotsPreference.addAccount(account);
            Model.getInstance().getPreferencesAccess().saveConfig(false, false);
            this.view.refreshList(null);
            String message = Lang.get("TEXT_PREF_LABEL_ACCOUNT_ADDED");
            message = message.replace("###ACCOUNT###", username);
            this.view.displayDefaultRightPanel(new Notification(6, message));
        }
    }
}

