/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.ui.common.dialogs;

import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.DialogHolder;
import fr.n3vision.hotspot.ui.common.dialogs.AbstractDialog;
import fr.n3vision.hotspot.util.Log;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class DialogSystemInfo
extends AbstractDialog
implements ClipboardOwner {
    private static final String className = "fr.n3vision.hotspot3.ui.common.dialogs.DialogSystemInfo";
    private static final long serialVersionUID = -2131906202579477128L;
    private JButton buttonCopy = null;

    public DialogSystemInfo(final String message, int nbLigne, boolean mutex, DialogHolder holder, boolean hold) {
        super(mutex, holder, hold);
        this.setSize(new Dimension(548, 100 + 20 * nbLigne));
        this.getButton().setBounds(new Rectangle(290, 25 + 20 * nbLigne, 110, 24));
        URL url = this.getClass().getResource("/fr/n3vision/hotspot/res/dialog/icon_info_32.png");
        ImageIcon icon = new ImageIcon(url, "");
        this.getImage().setIcon(icon);
        this.getLabel().setBounds(new Rectangle(40, 4, 500, 25 + 20 * nbLigne));
        this.getLabel().setText("<html><body>" + message + "</body></html>");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.buttonCopy = new JButton();
        this.buttonCopy.setText(Lang.get("DIALOG_COPY_CLIPBOARD"));
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = message.replace("<br>", "");
                msg = msg.replace("<b>", "").replace("</b>", "");
                msg = msg.replace("<li>", "").replace("</li>", "");
                msg = msg.replace("<ul>", "").replace("</ul>", "");
                DialogSystemInfo.this.copyToClipBoard(msg, DialogSystemInfo.this);
            }
        });
        this.buttonCopy.setBounds(new Rectangle(160, 25 + 20 * nbLigne, 110, 24));
        this.add(this.buttonCopy);
        Log.d("fr.n3vision.hotspot3.ui.common.dialogs.DialogSystemInfo : Initialisation d'un dialog : message = " + message);
    }

    public void copyToClipBoard(String str, ClipboardOwner owner) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(str);
        clipboard.setContents(contents, owner);
        this.buttonCopy.setText(Lang.get("DIALOG_COPY_CLIPBOARD_OK"));
        Log.d("fr.n3vision.hotspot3.ui.common.dialogs.DialogSystemInfo : Copie dans le presse Papier");
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.buttonCopy.setText(Lang.get("DIALOG_COPY_CLIPBOARD"));
        Log.d("fr.n3vision.hotspot3.ui.common.dialogs.DialogSystemInfo : Remplacement du presse-papier par autre chose");
    }
}

