/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.core.preference;

import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.AccountPriorityComparator;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class HotspotsPreference {
    private String className = this.getClass().getName();
    private HashMap<Integer, ArrayList<AccountPreference>> hotspotsAccounts = new HashMap();
    private HashMap<Integer, ArrayList<AccountPreference>> hotspotsAccountsDisabled = new HashMap();

    public void addAccount(AccountPreference account) {
        int type = account.getType();
        HashMap<Integer, ArrayList<AccountPreference>> hashmap = this.getHotspotMapFromAccount(account);
        ArrayList<AccountPreference> accounts = hashmap.get(type);
        Log.d(String.valueOf(this.className) + " Ajout d'un compte de type " + Constant.HOTSPOTS_ALL_TYPE.get(type).getName() + " ; inactive ? " + account.isInactive());
        if (accounts == null) {
            Log.d(String.valueOf(this.className) + " La liste de type " + Constant.HOTSPOTS_ALL_TYPE.get(type).getName() + " doit \u00eatre cr\u00e9\u00e9e");
            accounts = new ArrayList();
            hashmap.put(type, accounts);
        }
        accounts.add(account);
        this.reorderAccounts();
    }

    public void removeAccount(AccountPreference account) {
        Log.d(String.valueOf(this.className) + " Suppression du compte " + account.getUsername() + " ; compte inactif : " + account.isInactive());
        HashMap<Integer, ArrayList<AccountPreference>> hashmap = this.getHotspotMapFromAccount(account);
        ArrayList<AccountPreference> list = hashmap.get(account.getType());
        if (list != null) {
            if (list.contains(account)) {
                if (list.remove(account)) {
                    Log.d(String.valueOf(this.className) + " Suppression effectu\u00e9e");
                } else {
                    Log.d(String.valueOf(this.className) + " Erreur \u00e0 la suppression");
                }
            } else {
                Log.d(String.valueOf(this.className) + " liste comptes ne contient pas ce compte");
            }
        } else {
            Log.d(String.valueOf(this.className) + " Demande de suppression d'un compte de la liste des comptes en erreur");
        }
        this.reorderAccounts();
    }

    public void printAccounts() {
        for (ArrayList<AccountPreference> arrayList : this.hotspotsAccounts.values()) {
            Collections.sort(arrayList, new AccountPriorityComparator());
            for (AccountPreference accountPreference : arrayList) {
                Log.d(String.valueOf(this.className) + " : compte actif : " + accountPreference.getUsername() + " type : " + Constant.HOTSPOTS_ALL_TYPE.get(accountPreference.getType()).getName());
            }
        }
        Log.d(String.valueOf(this.className) + " Fin des comptes actifs");
        for (ArrayList<AccountPreference> arrayList : this.hotspotsAccountsDisabled.values()) {
            Collections.sort(arrayList, new AccountPriorityComparator());
            for (AccountPreference accountPreference : arrayList) {
                Log.d(String.valueOf(this.className) + " : compte inactif : " + accountPreference.getUsername() + " type : " + Constant.HOTSPOTS_ALL_TYPE.get(accountPreference.getType()).getName());
            }
        }
    }

    public void reorderAccounts() {
        int priority;
        Log.d(String.valueOf(this.className) + " Reorder Accounts");
        for (ArrayList<AccountPreference> arrayListActive : this.hotspotsAccounts.values()) {
            Collections.sort(arrayListActive, new AccountPriorityComparator());
            priority = 1;
            for (AccountPreference accountPreference : arrayListActive) {
                accountPreference.setPriority(priority);
                ++priority;
            }
        }
        for (ArrayList<AccountPreference> arrayListInactive : this.hotspotsAccountsDisabled.values()) {
            Collections.sort(arrayListInactive, new AccountPriorityComparator());
            priority = 1;
            for (AccountPreference accountPreference : arrayListInactive) {
                accountPreference.setPriority(priority);
                ++priority;
            }
        }
    }

    public int getMaxPriorityForType(int type, HashMap<Integer, ArrayList<AccountPreference>> hashmap) {
        ArrayList<AccountPreference> accounts = hashmap.get(type);
        if (accounts == null) {
            return 0;
        }
        return accounts.get(accounts.size() - 1).getPriority();
    }

    public void priorityDown(AccountPreference account) {
        HashMap<Integer, ArrayList<AccountPreference>> hashmap = this.getHotspotMapFromAccount(account);
        ArrayList<AccountPreference> accounts = hashmap.get(account.getType());
        int priority = account.getPriority();
        int idx = accounts.indexOf(account);
        if (idx > 0) {
            accounts.get(idx - 1).setPriority(priority);
            account.setPriority(priority - 1);
        }
        this.reorderAccounts();
    }

    public void priorityUp(AccountPreference account) {
        HashMap<Integer, ArrayList<AccountPreference>> hashmap = this.getHotspotMapFromAccount(account);
        ArrayList<AccountPreference> accounts = hashmap.get(account.getType());
        int priority = account.getPriority();
        int idx = accounts.indexOf(account);
        if (idx < this.getMaxPriorityForType(account.getType(), hashmap) - 1) {
            account.setPriority(priority + 1);
            accounts.get(idx + 1).setPriority(priority);
        }
        this.reorderAccounts();
    }

    public void changeAccountType(AccountPreference account, int newType) {
        Log.d(String.valueOf(this.className) + " Changement de type pour le compte " + account.getUsername() + " de " + Constant.HOTSPOTS_ALL_TYPE.get(account.getType()).getName() + " en " + Constant.HOTSPOTS_ALL_TYPE.get(newType).getName());
        this.removeAccount(account);
        account.setType(newType);
        account.setPriority(0);
        this.addAccount(account);
    }

    public void changeAccountDisability(AccountPreference account, boolean disabled) {
        Log.d(String.valueOf(this.className) + " Change Account disability");
        this.removeAccount(account);
        account.setInactive(disabled);
        this.addAccount(account);
    }

    public HashMap<Integer, ArrayList<AccountPreference>> getHotspotMapFromAccount(AccountPreference account) {
        if (account.isInactive()) {
            return this.getHotspotsAccountsDisabled();
        }
        return this.getHotspotsAccounts();
    }

    public HashMap<Integer, ArrayList<AccountPreference>> getHotspotsAccounts() {
        return this.hotspotsAccounts;
    }

    public HashMap<Integer, ArrayList<AccountPreference>> getHotspotsAccountsDisabled() {
        return this.hotspotsAccountsDisabled;
    }
}

