/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.core;

import fr.n3vision.hotspot.core.EnumAppLocked;
import fr.n3vision.hotspot.core.EnumHotspotLocked;
import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.Versions;
import fr.n3vision.hotspot.core.hotspots.BouyguesModel;
import fr.n3vision.hotspot.core.hotspots.CampusAngersModel;
import fr.n3vision.hotspot.core.hotspots.FreeModel;
import fr.n3vision.hotspot.core.hotspots.NeufOLDModel;
import fr.n3vision.hotspot.core.hotspots.OrangeModel;
import fr.n3vision.hotspot.core.hotspots.SFRGaresModel;
import fr.n3vision.hotspot.core.hotspots.SFRModel;
import fr.n3vision.hotspot.core.preference.AccountPreference;
import fr.n3vision.hotspot.core.preference.GlobalPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.hotspots.Bouygues;
import fr.n3vision.hotspot.ui.common.hotspots.CampusAngers;
import fr.n3vision.hotspot.ui.common.hotspots.Free;
import fr.n3vision.hotspot.ui.common.hotspots.Orange;
import fr.n3vision.hotspot.ui.common.hotspots.SFR;
import fr.n3vision.hotspot.ui.common.hotspots.SFRGares;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.HttpClient;
import fr.n3vision.hotspot.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Reconnecter {
    private final String className = this.getClass().getName();
    private boolean mutexCheck = false;
    private Model model = null;
    private Timer timerVersion;
    private TimerTask timertaskVersion;
    private int lastHotspot = -1;
    private long timeOfLastConnection = 0L;
    private int numberOfNoConnection = 0;
    private boolean mutexCheckVersion = false;
    private boolean timerCheckVersionRunning = false;
    private GlobalPreference globalPreference = null;
    private HotspotsPreference hotspotsPreference = null;
    private Timer timer;
    private AccountPreference lastAccountUsed = null;

    public Reconnecter(Model _model) {
        this.model = _model;
        this.globalPreference = this.model.getGlobalPreference();
        this.hotspotsPreference = this.model.getHotspotsPreference();
        this.timerCheckVersionRunning = false;
    }

    public void start() {
        this.timer = new Timer();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!Reconnecter.this.mutexCheck) {
                        Reconnecter.this.mutexCheck = true;
                        Log.i(String.valueOf(Reconnecter.this.className) + " : V\u00e9rification INTERNET");
                        Reconnecter.this.model.fireNotificationNewCheck();
                        HttpClient c = new HttpClient(Functions.getRandomUrlCheckConnection());
                        int error_code = c.connect("GET", Functions.getRandomUserAgent());
                        if (error_code == 10) {
                            String headerLocation = c.getLocationHeader();
                            String hotspot_url = "";
                            Matcher matcher = null;
                            if (headerLocation != null && !headerLocation.isEmpty()) {
                                Log.d(String.valueOf(Reconnecter.this.className) + " : Header Location = " + headerLocation);
                                matcher = Constant.PATTERN_HOTSPOT_TYPE_HEADER_REDIRECTION.matcher(headerLocation);
                                if (matcher.find()) {
                                    hotspot_url = matcher.group(1);
                                    Log.d(String.valueOf(Reconnecter.this.className) + " Trouv\u00e9 l'url du hotspot : " + hotspot_url);
                                } else {
                                    hotspot_url = headerLocation;
                                    Log.e("Le Hotspot " + headerLocation + " ne correspond pas au pattern : " + Constant.PATTERN_HOTSPOT_TYPE_HEADER_REDIRECTION);
                                }
                            } else {
                                String content = c.getResponse();
                                if (content.equals(String.valueOf(404))) {
                                    hotspot_url = content;
                                } else if (content.equals(String.valueOf(6))) {
                                    hotspot_url = content;
                                } else if (content != null && !content.isEmpty()) {
                                    Log.v("Pas de redirection directe en header Location, on cherche dans le code de la page");
                                    matcher = Constant.PATTERN_HOTSPOT_TYPE_CONTENT.matcher(content);
                                    if (matcher.find()) {
                                        hotspot_url = matcher.group(1);
                                        headerLocation = "";
                                        Log.d("HOTSPOT URL (depuis contenu) : " + hotspot_url);
                                    }
                                } else {
                                    Log.e(String.valueOf(Reconnecter.this.className) + " : Le contenu retourn\u00e9 est vide !");
                                }
                            }
                            int result = -1;
                            if (!hotspot_url.isEmpty()) {
                                ArrayList<Object> accounts;
                                Log.d(String.valueOf(Reconnecter.this.className) + " : R\u00e9cup\u00e9ration de l'URL du hotspot : " + hotspot_url);
                                if (hotspot_url.equals("hotspot.wifi.sfr.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL SFR ou Fonero identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_sfr()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type SFR ou Fonero identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0) != null) {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type SFR identifi\u00e9");
                                            accounts.addAll((Collection)Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0));
                                        }
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(7) != null) {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type FONERO identifi\u00e9");
                                            accounts.addAll((Collection<Object>)Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(7));
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            SFRModel sfr = SFRModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = sfr.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = Reconnecter.this.lastAccountUsed.getType();
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte SFR configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("hotspot.neuf.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL Neuf identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_sfr()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Anciein Hotspot Neuf Identifi\u00e9 !");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            NeufOLDModel neuf = NeufOLDModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = neuf.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 4;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte SFR Configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("wifi.free.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL Free identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_free()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type FREE identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(1) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(1);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            FreeModel free = FreeModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = free.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 1;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte Free configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("hotspotwifi.bouyguestelecom.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL Bouygues identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_bouygues()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type BOUYGUES identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(2) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(2);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            BouyguesModel bouygues = BouyguesModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = bouygues.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 2;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte Bouygues configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("gare.wifi.sfr.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL SFR Gare identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_sfr_gares()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type SFRGares identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(0);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            SFRGaresModel sfrGares = SFRGaresModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = sfrGares.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 3;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte SFR Configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("hautdebitmobile.orange.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL Orange identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_orange()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type ORANGE identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(5) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(5);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            OrangeModel orange = OrangeModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = orange.reconnection(hotspot_url, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 5;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte Orange configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals("wifi.univ-angers.fr")) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : URL Campus Angers identifi\u00e9e");
                                    if (!Reconnecter.this.globalPreference.isHotspot_locked_campus_angers()) {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Hotspot de Type CampusAngers identifi\u00e9");
                                        accounts = new ArrayList();
                                        if (Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(6) != null) {
                                            accounts = Reconnecter.this.hotspotsPreference.getHotspotsAccounts().get(6);
                                        }
                                        if (accounts != null && accounts.size() > 0) {
                                            CampusAngersModel campusAngers = CampusAngersModel.getInstance();
                                            Reconnecter.this.lastAccountUsed = (AccountPreference)accounts.get(0);
                                            result = campusAngers.reconnection(headerLocation, Reconnecter.this.lastAccountUsed);
                                            Reconnecter.this.lastHotspot = 6;
                                        } else {
                                            Log.d(String.valueOf(Reconnecter.this.className) + " : Pas de compte Campus Angers configur\u00e9");
                                            result = 4;
                                        }
                                    } else {
                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Impossible d'utiliser ce hotspot");
                                        result = 9;
                                    }
                                } else if (hotspot_url.equals(String.valueOf(404))) {
                                    Log.i(String.valueOf(Reconnecter.this.className) + " : INTERNET pr\u00e9sent");
                                    result = -1;
                                } else if (hotspot_url.equals(String.valueOf(6))) {
                                    Log.i(String.valueOf(Reconnecter.this.className) + " : Connection Time Out !");
                                    result = 6;
                                } else {
                                    result = 5;
                                }
                            } else {
                                result = 2;
                            }
                            c.disconnect();
                            if (Reconnecter.this.timeOfLastConnection == 0L) {
                                Reconnecter.this.timeOfLastConnection = Functions.getCurrentTimeStamp();
                            }
                            if (result == 10) {
                                Log.i(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion \"ok\"");
                                Reconnecter.this.setTimeOfLastConnection();
                                Reconnecter.this.model.fireNotificationLastHotspot(Reconnecter.this.lastHotspot, Reconnecter.this.lastAccountUsed.getUsername());
                                Reconnecter.this.model.fireNotificationConnected();
                                Reconnecter.this.model.fireNotificationNewReconnection();
                                Reconnecter.this.numberOfNoConnection = 0;
                            } else if (result == -1) {
                                Reconnecter.this.model.setConnected(true);
                                Reconnecter.this.model.fireNotificationConnected();
                                Reconnecter.this.numberOfNoConnection = 0;
                                if (!Reconnecter.this.timerCheckVersionRunning) {
                                    Log.d(String.valueOf(Reconnecter.this.className) + " : Lancement de la v\u00e9rification de nouvelle version");
                                    Reconnecter.this.timerVersion = new Timer();
                                    Reconnecter.this.timertaskVersion = new TimerTask(){

                                        @Override
                                        public void run() {
                                            Reconnecter.this.timerCheckVersionRunning = true;
                                            if (!Reconnecter.this.mutexCheckVersion) {
                                                try {
                                                    Reconnecter.this.mutexCheckVersion = true;
                                                    Date date = new Date();
                                                    long now = date.getTime();
                                                    if (Reconnecter.this.globalPreference.getLastVersionCheck() < now - 86400000L) {
                                                        Log.d(String.valueOf(Reconnecter.this.className) + " : Cela fait au moins " + 1 + " jours sans v\u00e9rification");
                                                        Reconnecter.this.getNewVersionNumber(false);
                                                    } else {
                                                        Log.i(String.valueOf(Reconnecter.this.className) + " : Pas de v\u00e9rification de version, derni\u00e9re v\u00e9rification trop r\u00e9cente");
                                                    }
                                                }
                                                catch (Exception e) {
                                                    Log.e(String.valueOf(Reconnecter.this.className) + " : Exception dans le timer lors de la v\u00e9rification de version : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
                                                    Log.e(e);
                                                }
                                                Reconnecter.this.mutexCheckVersion = true;
                                            } else {
                                                Log.w(String.valueOf(Reconnecter.this.className) + " : Mutex de check de version occup\u00e9e, pas de v\u00e9rification");
                                            }
                                        }
                                    };
                                    Reconnecter.this.timerVersion.schedule(Reconnecter.this.timertaskVersion, 2000L, 3600000L);
                                }
                            } else {
                                switch (result) {
                                    case 1: {
                                        Reconnecter.this.reOrderAccountPriorities();
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Erreur g\u00e9n\u00e9rale \"ERROR\"");
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        Reconnecter.this.model.fireNotificationError(Lang.get("DIALOG_GLOBAL_ERROR_LONG"), Lang.get("DIALOG_GLOBAL_ERROR_SHORT"));
                                        break;
                                    }
                                    case 2: {
                                        Log.w(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Erreur de connexion \"NO_CONNECTION\"");
                                        if (Reconnecter.this.numberOfNoConnection > 5) {
                                            Log.w(String.valueOf(Reconnecter.this.className) + " : Trop de check sans internet ; on coupe l'application ");
                                            Reconnecter.this.stop();
                                            Reconnecter.this.model.fireNotificationDisconnectFromModel();
                                            Reconnecter.this.model.fireNotificationNoInternet(Lang.get("DIALOG_NO_INTERNET_LONG"), Lang.get("DIALOG_NO_INTERNET_SHORT"));
                                            break;
                                        }
                                        Log.w(String.valueOf(Reconnecter.this.className) + " : (encore) un check sans internet, mais pas encore \"trop\" ");
                                        Reconnecter reconnecter = Reconnecter.this;
                                        reconnecter.numberOfNoConnection = reconnecter.numberOfNoConnection + 1;
                                        Reconnecter.this.model.fireNotificationNoInternet(Lang.get("DIALOG_NO_INTERNET_RETRY_LONG"), Lang.get("DIALOG_NO_INTERNET_RETRY_SHORT"));
                                        break;
                                    }
                                    case 3: {
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Erreur de certificat \"SSL_ERROR\"");
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        Reconnecter.this.model.fireNotificationErrorSSL(Lang.get("DIALOG_CHECK_CERTIFICATE_ERROR_LONG"), Lang.get("DIALOG_CHECK_CERTIFICATE_ERROR_SHORT"));
                                        break;
                                    }
                                    case 4: {
                                        Log.w(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Pas de pr\u00e9f\u00e9rences renseign\u00e9es pour ce hotspot \"NO_PREF\"");
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        Reconnecter.this.model.fireNotificationInfo(Lang.get("DIALOG_NO_HOTSPOT_ACCOUNT_LONG"), Lang.get("DIALOG_NO_HOTSPOT_ACCOUNT_SHORT"), 2, false, false, false);
                                        break;
                                    }
                                    case 9: {
                                        Log.w(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Ce hotspot est verrouill\u00e9 \"HOTSPOT_LOCK\"");
                                        Reconnecter.this.model.fireNotificationDisconnectFromModel();
                                        Reconnecter.this.model.fireNotificationError(Lang.get("DIALOG_HOTSPOT_LOCK_LONG"), Lang.get("DIALOG_HOTSPOT_LOCK_SHORT"));
                                        Reconnecter.this.model.stop();
                                        break;
                                    }
                                    case 5: {
                                        Log.w(String.valueOf(Reconnecter.this.className) + " : retour du processus : non support\u00e9");
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        String messageLong = Lang.get("DIALOG_HOTSPOT_UNKNOWN_LONG");
                                        messageLong = messageLong.replace("###HOTSPOT###", hotspot_url);
                                        Reconnecter.this.model.fireNotificationInfo(messageLong, Lang.get("DIALOG_HOTSPOT_UNKNOWN_SHORT"), 1, true, true, false);
                                        break;
                                    }
                                    case 6: {
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion. Time out durant la phase de reconnexion \"CONNECTION_TIMED_OUT\"");
                                        if (Reconnecter.this.numberOfNoConnection > 5) {
                                            Log.e(String.valueOf(Reconnecter.this.className) + " : trop de tentatives en timeout (trop loin surement) on arr\u00eate les check !");
                                            Reconnecter.this.stop();
                                            Reconnecter.this.model.fireNotificationDisconnectFromModel();
                                            Reconnecter.this.model.fireNotificationError(Lang.get("DIALOG_TIMED_OUT_LONG"), Lang.get("DIALOG_TIMED_OUT_SHORT"));
                                            break;
                                        }
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : (encore) un check sans \u00eatre \"trop\" on va retenter !");
                                        Reconnecter reconnecter = Reconnecter.this;
                                        reconnecter.numberOfNoConnection = reconnecter.numberOfNoConnection + 1;
                                        Reconnecter.this.model.fireNotificationError(Lang.get("DIALOG_TIMED_OUT_RETRY_LONG"), Lang.get("DIALOG_TIMED_OUT_RETRY_SHORT"));
                                        break;
                                    }
                                    case 7: {
                                        Reconnecter.this.setAccountDisabled();
                                        Reconnecter.this.reOrderAccountPriorities();
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion. Compte invalide, marquage comme compte d\u00e9sactiv\u00e9");
                                        String messageInvalidLong = Lang.get("DIALOG_ACCOUNT_INVALID_LONG");
                                        messageInvalidLong = messageInvalidLong.replace("###ACCOUNT###", Reconnecter.this.lastAccountUsed.getUsername());
                                        String messageInvalidShort = Lang.get("DIALOG_ACCOUNT_INVALID_SHORT");
                                        messageInvalidShort = messageInvalidShort.replace("###ACCOUNT###", Reconnecter.this.lastAccountUsed.getUsername());
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        Reconnecter.this.model.fireNotificationError(messageInvalidLong, messageInvalidShort);
                                        break;
                                    }
                                    case 8: {
                                        Reconnecter.this.reOrderAccountPriorities();
                                        Log.e(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion. Compte d\u00e9ja utilis\u00e9");
                                        String messageUsedLong = Lang.get("DIALOG_ACCOUNT_USED_LONG");
                                        messageUsedLong = messageUsedLong.replace("###ACCOUNT###", Reconnecter.this.lastAccountUsed.getUsername());
                                        String messageUsedShort = Lang.get("DIALOG_ACCOUNT_USED_SHORT");
                                        messageUsedShort = messageUsedShort.replace("###ACCOUNT###", Reconnecter.this.lastAccountUsed.getUsername());
                                        Reconnecter.this.model.fireNotificationDisconnected();
                                        Reconnecter.this.model.fireNotificationError(messageUsedLong, messageUsedShort);
                                    }
                                }
                            }
                        } else if (error_code == 2) {
                            Log.w(String.valueOf(Reconnecter.this.className) + " : Retour du processus de reconnexion Erreur de connexion \"NO_CONNECTION\"");
                            if (Reconnecter.this.numberOfNoConnection > 5) {
                                Log.w(String.valueOf(Reconnecter.this.className) + " : Trop de check sans internet ; on coupe l'application ");
                                Reconnecter.this.stop();
                                Reconnecter.this.model.fireNotificationDisconnectFromModel();
                                Reconnecter.this.model.fireNotificationNoInternet(Lang.get("DIALOG_NO_INTERNET_LONG"), Lang.get("DIALOG_NO_INTERNET_SHORT"));
                            } else {
                                Log.w(String.valueOf(Reconnecter.this.className) + " : (encore) un check sans internet, mais pas encore \"trop\" ");
                                Reconnecter reconnecter = Reconnecter.this;
                                reconnecter.numberOfNoConnection = reconnecter.numberOfNoConnection + 1;
                                Reconnecter.this.model.fireNotificationNoInternet(Lang.get("DIALOG_NO_INTERNET_RETRY_LONG"), Lang.get("DIALOG_NO_INTERNET_RETRY_SHORT"));
                            }
                        }
                        Reconnecter.this.mutexCheck = false;
                        Log.i(String.valueOf(Reconnecter.this.className) + " : lib\u00e9ration de mutexCheck");
                    } else {
                        Log.w(String.valueOf(Reconnecter.this.className) + " : mutexCheck est occup\u00e9e");
                    }
                }
                catch (Exception e) {
                    Reconnecter.this.mutexCheck = false;
                    Log.i(String.valueOf(Reconnecter.this.className) + " : lib\u00e9ration de mutexCheck");
                    Log.e(String.valueOf(Reconnecter.this.className) + " : Exception durant le processus de v\u00e9rification : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
                    Log.e(e);
                }
            }
        };
        Log.d(String.valueOf(this.className) + " : Lancement de la v\u00e9rification");
        this.timer.schedule(tt, 1000L, (long)this.globalPreference.getTimerInterval());
    }

    public void stop() {
        this.numberOfNoConnection = 0;
        this.lastAccountUsed = null;
        this.lastHotspot = -1;
        this.mutexCheck = false;
        Log.i(String.valueOf(this.className) + " : lib\u00e9ration de mutexCheck");
        this.timerCheckVersionRunning = false;
        this.timer.cancel();
        this.timer.purge();
        this.resetTimeOfLastConnection();
    }

    public void getNewVersionNumber(boolean fromUI) {
        Log.d(String.valueOf(this.className) + " : V\u00e9rification de nouvelle version");
        Date date = new Date();
        long now = date.getTime();
        this.globalPreference.setLastVersionCheck(now);
        try {
            HttpClient client = new HttpClient("http://hwr.ntvapp.com/get_new_version.php?id=" + this.model.getAppId() + "&version=" + 57);
            int error_code = client.connect("GET", Functions.getRandomUserAgent());
            if (error_code == 10) {
                String content = client.getResponse();
                if (!content.equals("")) {
                    if (content.equals("404") || content.equals("401") || content.equals("403")) {
                        this.errorWhileCheckVersionAndLock();
                    } else {
                        JSONObject json = (JSONObject)new JSONParser().parse(content);
                        Versions versions = new Versions(json);
                        int versionCode = versions.getVersion_code();
                        String versionNum = versions.getVersion();
                        this.globalPreference.setNumberOfCheckVersionFailed(0);
                        this.traiterLock(versions);
                        this.model.getPreferencesAccess().saveConfig(false, false);
                        Log.i(String.valueOf(this.className) + " : R\u00e9sultat de la demande : version officielle : " + versionCode + " ; num\u00e9ro :" + versionNum);
                        if (versionCode > 57) {
                            if (fromUI || this.globalPreference.isAutomaticVersionCheck()) {
                                this.model.fireNotificationNewVersion(versionNum);
                                Log.i(String.valueOf(this.className) + " : Proposition de mise \u00e0 jour vers la version " + versionNum);
                            } else {
                                Log.i(String.valueOf(this.className) + " : PAS DE Proposition de mise \u00e0 jour vers la version " + versionNum + " Car l'utilisateur n'a pas le check auto des versions");
                            }
                        } else if (fromUI || this.globalPreference.isAutomaticVersionCheck()) {
                            this.model.fireNotificationInfo(Lang.get("DIALOG_LAST_VERSION_LONG"), Lang.get("DIALOG_LAST_VERSION_SHORT"), 1, false, false, false);
                        }
                    }
                } else if (fromUI || this.globalPreference.isAutomaticVersionCheck()) {
                    this.model.fireNotificationNoInternet(Lang.get("DIALOG_NO_INTERNET_CHECK_VERSION_LONG"), Lang.get("DIALOG_NO_INTERNET_CHECK_VERSION_SHORT"));
                }
            } else if (error_code != 2) {
                this.errorWhileCheckVersionAndLock();
            }
            client.disconnect();
        }
        catch (Exception e) {
            Log.w(String.valueOf(this.className) + " : Exception lors de la v\u00e9rification de version : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
            Log.e(e);
        }
    }

    private void errorWhileCheckVersionAndLock() {
        if (this.globalPreference.getNumberOfCheckVersionFailed() < 4) {
            this.globalPreference.setNumberOfCheckVersionFailed(this.globalPreference.getNumberOfCheckVersionFailed() + 1);
        } else {
            this.globalPreference.setApp_locked(true);
            this.model.fireNotificationLockApp(Lang.get("DIALOG_LOCK_APP_2_LONG"), Lang.get("DIALOG_LOCK_APP_2_SHORT"));
            this.model.stop();
        }
        this.model.getPreferencesAccess().saveConfig(false, false);
    }

    private void traiterLock(Versions versions) {
        if (versions.getApp_locked() != EnumAppLocked.NO) {
            this.globalPreference.setLock_text(versions.getLock_text());
        } else {
            this.globalPreference.setLock_text("");
            this.globalPreference.setApp_locked(false);
            this.globalPreference.setHotspot_locked_bouygues(false);
            this.globalPreference.setHotspot_locked_campus_angers(false);
            this.globalPreference.setHotspot_locked_free(false);
            this.globalPreference.setHotspot_locked_orange(false);
            this.globalPreference.setHotspot_locked_sfr(false);
            this.globalPreference.setHotspot_locked_sfr_gares(false);
            this.model.fireUnlockApp();
        }
        if (versions.getApp_locked() == EnumAppLocked.YES) {
            Log.w(String.valueOf(this.className) + " : L'application est verrouill\u00e9e !!");
            this.globalPreference.setApp_locked(true);
            this.globalPreference.setHotspot_locked_bouygues(false);
            this.globalPreference.setHotspot_locked_campus_angers(false);
            this.globalPreference.setHotspot_locked_free(false);
            this.globalPreference.setHotspot_locked_orange(false);
            this.globalPreference.setHotspot_locked_sfr(false);
            this.globalPreference.setHotspot_locked_sfr_gares(false);
            this.model.fireNotificationLockApp(Lang.get("DIALOG_LOCK_APP_LONG").replace("{0}", this.globalPreference.getLock_text()), Lang.get("DIALOG_LOCK_APP_SHORT"));
            this.model.stop();
            this.model.fireNotificationDisconnectFromModel();
        }
        if (versions.getApp_locked() == EnumAppLocked.BY_HOTSPOT) {
            Log.w(String.valueOf(this.className) + " : au moins un hotspot est verrouill\u00e9");
            this.model.fireUnlockApp();
            this.globalPreference.setApp_locked(false);
            EnumHotspotLocked[] hotspot_locked = versions.getHotspot_locked();
            this.globalPreference.setHotspot_locked_bouygues(false);
            this.globalPreference.setHotspot_locked_campus_angers(false);
            this.globalPreference.setHotspot_locked_free(false);
            this.globalPreference.setHotspot_locked_orange(false);
            this.globalPreference.setHotspot_locked_sfr(false);
            this.globalPreference.setHotspot_locked_sfr_gares(false);
            int i = 0;
            while (i < hotspot_locked.length) {
                EnumHotspotLocked e = hotspot_locked[i];
                switch (e) {
                    case BOUYGUES: {
                        this.globalPreference.setHotspot_locked_bouygues(true);
                        if (this.lastHotspot != 2) break;
                        this.callLiveLockHotspot(Bouygues.getInstance().getName());
                        break;
                    }
                    case CAMPUS_ANGERS: {
                        this.globalPreference.setHotspot_locked_campus_angers(true);
                        if (this.lastHotspot != 6) break;
                        this.callLiveLockHotspot(CampusAngers.getInstance().getName());
                        break;
                    }
                    case FREE: {
                        this.globalPreference.setHotspot_locked_free(true);
                        if (this.lastHotspot != 1) break;
                        this.callLiveLockHotspot(Free.getInstance().getName());
                        break;
                    }
                    case ORANGE: {
                        this.globalPreference.setHotspot_locked_orange(true);
                        if (this.lastHotspot != 5) break;
                        this.callLiveLockHotspot(Orange.getInstance().getName());
                        break;
                    }
                    case SFR: {
                        this.globalPreference.setHotspot_locked_sfr(true);
                        if (this.lastHotspot != 0 && this.lastHotspot != 7) break;
                        this.callLiveLockHotspot(SFR.getInstance().getName());
                        break;
                    }
                    case SFR_GARES: {
                        this.globalPreference.setHotspot_locked_sfr_gares(true);
                        if (this.lastHotspot != 0) break;
                        this.callLiveLockHotspot(SFRGares.getInstance().getName());
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void callLiveLockHotspot(String hotspot) {
        this.model.fireNotificationLockHotspot(Lang.get("DIALOG_LOCK_HOTSPOT_LONG").replace("{0}", hotspot).replace("{1}", this.globalPreference.getLock_text()), Lang.get("DIALOG_LOCK_HOTSPOT_SHORT").replace("{0}", hotspot));
        this.model.stop();
        this.model.fireNotificationDisconnectFromModel();
    }

    private void reOrderAccountPriorities() {
        HashMap<Integer, ArrayList<AccountPreference>> hashmap = this.hotspotsPreference.getHotspotMapFromAccount(this.lastAccountUsed);
        int priorityAccount = this.hotspotsPreference.getMaxPriorityForType(this.lastHotspot, hashmap);
        this.lastAccountUsed.setPriority(priorityAccount + 1);
        this.hotspotsPreference.reorderAccounts();
    }

    private void setAccountDisabled() {
        this.hotspotsPreference.changeAccountDisability(this.lastAccountUsed, true);
    }

    public long getTimeOfLastConnection() {
        return this.timeOfLastConnection;
    }

    public void resetTimeOfLastConnection() {
        this.timeOfLastConnection = 0L;
    }

    public void setTimeOfLastConnection() {
        this.timeOfLastConnection = Functions.getCurrentTimeStamp();
    }

    public int getLastHotspot() {
        return this.lastHotspot;
    }
}

