/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.core;

import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.util.FileWriter;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import java.io.File;

public class PreferencesAccess {
    private final String className = this.getClass().getName();
    private Model model = null;

    public PreferencesAccess(Model model) {
        File configFile;
        Log.i(String.valueOf(this.className) + " Initialisation des accessPreferences");
        this.model = model;
        String executionPath = System.getProperty("user.dir").replace("\\", "/");
        File configDir = new File(executionPath);
        if (!configDir.canWrite()) {
            model.fireNotificationError(Lang.get("DIALOG_UNABLE_TO_WRITE_LONG"), Lang.get("DIALOG_UNABLE_TO_WRITE_SHORT"));
            System.out.println("\u00e9criture du fichier impossible \u00e0 cet emplacement !");
            Log.d(String.valueOf(this.className) + " : Ecriture du fichier de configuration impossible");
        }
        if ((configFile = new File("HWR_config")).exists()) {
            Log.i(String.valueOf(this.className) + " : Le fichier de configuration existe");
            this.readConfig();
        } else {
            Log.i(String.valueOf(this.className) + " : Le fichier de configuration n'existe pas");
        }
    }

    private void readConfig() {
        Log.d(String.valueOf(this.className) + " : Lecture de la configuration");
        try {
            String config = FileWriter.read("HWR_config");
            Functions.parseConfig(Functions.decrypt(config));
        }
        catch (Exception e) {
            Log.e(String.valueOf(this.className) + " : Exception durant la lecture de la configuration : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
            Log.e(e);
        }
        Log.d(String.valueOf(this.className) + " : Lecture termin\u00e9e");
    }

    public void saveConfig(boolean displayResult, boolean forceDialog) {
        Log.d(String.valueOf(this.className) + " : Sauvegarde de la configuration");
        try {
            String xml = Functions.generatePreferenceXML();
            String configuration = Functions.crypt(xml);
            FileWriter.record("HWR_config", configuration);
            if (displayResult) {
                this.model.fireNotificationInfo(Lang.get("DIALOG_MANUAL_UPDATE_DONE_LONG"), Lang.get("DIALOG_MANUAL_UPDATE_DONE_SHORT"), 2, false, false, forceDialog);
            }
        }
        catch (Exception e) {
            if (displayResult) {
                this.model.fireNotificationError(Lang.get("DIALOG_MANUEL_UPDATE_ERROR_LONG"), Lang.get("DIALOG_MANUEL_UPDATE_ERROR_SHORT"));
            }
            Log.e(String.valueOf(this.className) + " : Exception durant la sauvegarde de la configuration : " + e.getMessage() + " ; Cause : " + e.getCause() + " ; Classe : " + e.getClass().getName());
            Log.e(e);
        }
        Log.d(String.valueOf(this.className) + " : sauvegarde termin\u00e9e");
    }
}

