/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot.core;

import fr.n3vision.hotspot.core.NotificationListener;
import fr.n3vision.hotspot.core.PreferencesAccess;
import fr.n3vision.hotspot.core.Reconnecter;
import fr.n3vision.hotspot.core.preference.GlobalPreference;
import fr.n3vision.hotspot.core.preference.HotspotsPreference;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.common.hotspots.SFR;
import fr.n3vision.hotspot.ui.common.hotspots.SFRGares;
import fr.n3vision.hotspot.util.Constant;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import fr.n3vision.hotspot.util.Zip;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;

public class Model {
    private final String className = this.getClass().getName();
    private static Model instance = null;
    private String appId = "";
    private Timer timerCount;
    private TimerTask timertaskCount;
    private int numberOfReconnection = 0;
    private int numberOfCheck = 0;
    private boolean launched = false;
    private boolean connected = false;
    private Reconnecter reconnecter = null;
    private PreferencesAccess preferencesAccess = null;
    private GlobalPreference globalPreference = null;
    private HotspotsPreference hotspotsPreference = null;
    private final Collection<NotificationListener> notificationListeners = new ArrayList<NotificationListener>();

    private Model() {
        Log.i(String.valueOf(this.className) + " Initialisation du mod\u00e8le Sans Listener");
        this.globalPreference = new GlobalPreference();
        this.hotspotsPreference = new HotspotsPreference();
    }

    private void initializeModel() {
        this.reconnecter = new Reconnecter(this);
        this.preferencesAccess = new PreferencesAccess(this);
        this.appId = Functions.getAppId();
        if (this.globalPreference.isLaunchAtStartUp().booleanValue()) {
            this.start();
        } else {
            Log.d(String.valueOf(this.className) + " : Pas de lancement automatique");
        }
        this.timerCount = new Timer();
        this.timertaskCount = new TimerTask(){

            @Override
            public void run() {
                if (Model.this.launched && Model.this.connected) {
                    long span = Functions.getCurrentTimeStamp() - Model.this.reconnecter.getTimeOfLastConnection();
                    boolean isForSFR = false;
                    if (Model.this.getReconnecter().getLastHotspot() == SFR.getInstance().getType() || Model.this.getReconnecter().getLastHotspot() == SFRGares.getInstance().getType()) {
                        isForSFR = true;
                        if (span / 1000L * 1L == 6900L) {
                            Model.this.fireNotificationSFRNearEnd(5);
                        }
                    }
                    String count = Functions.getCountFromLong(span, isForSFR);
                    Model.this.fireNotificationCount(count);
                }
            }
        };
        this.timerCount.schedule(this.timertaskCount, 100L, 1000L);
    }

    public static Model getInstance() {
        if (instance == null) {
            instance = new Model();
            instance.initializeModel();
        }
        return instance;
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListeners.add(listener);
    }

    public long getLastConnection() {
        if (this.connected) {
            return this.reconnecter.getTimeOfLastConnection();
        }
        return 0L;
    }

    public void start() {
        Log.d(String.valueOf(this.className) + " : lancement du processus de reconnexion");
        if (!this.launched) {
            this.launched = true;
            this.preferencesAccess.saveConfig(false, false);
            this.startCheck();
        }
    }

    private void startCheck() {
        Log.d(String.valueOf(this.className) + " StartCheck : appId = " + this.appId);
        if (this.globalPreference.isApp_locked()) {
            Log.d(String.valueOf(this.className) + " L'application est verrouill\u00e9e. On block le lancement");
            return;
        }
        this.reconnecter.start();
    }

    public void update(String longMessage) {
        this.fireNotificationDownload(longMessage);
        new Thread(){

            @Override
            public void run() {
                Functions.download_file();
                Zip.unzip(new File(String.valueOf(Constant.TEMP_DIRECTORY) + "hwr_temp.zip"), new File(Constant.CURRENT_DIRECTORY));
                Model.this.fireNotificationCleanUp();
                Model.this.fireNotificationInfo(Lang.get("DIALOG_DOWNLOAD_NEW_VERSION_OK_LONG"), Lang.get("DIALOG_DOWNLOAD_NEW_VERSION_OK_SHORT"), 1, false, false, false);
            }
        }.start();
    }

    public void setConnected(boolean b) {
        this.connected = b;
    }

    public Reconnecter getReconnecter() {
        return this.reconnecter;
    }

    public boolean isLaunched() {
        return this.launched;
    }

    public void stop() {
        if (this.launched) {
            this.reconnecter.stop();
            this.connected = false;
            this.launched = false;
            this.numberOfCheck = 0;
            this.numberOfReconnection = 0;
            this.reconnecter.resetTimeOfLastConnection();
            this.fireNotificationCount("00:00:00");
            this.fireNotificationDisconnected();
            Log.i(String.valueOf(this.className) + " : Arret stopAll");
        } else {
            Log.d(String.valueOf(this.className) + " : Arret stopAll c'etait d\u00e9j\u00e0 \u00e9teint");
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public PreferencesAccess getPreferencesAccess() {
        return this.preferencesAccess;
    }

    public GlobalPreference getGlobalPreference() {
        return this.globalPreference;
    }

    public void setGlobalPreference(GlobalPreference globalPreference) {
        this.globalPreference = globalPreference;
    }

    public HotspotsPreference getHotspotsPreference() {
        return this.hotspotsPreference;
    }

    public void setHotspotsPreference(HotspotsPreference hotspotsPreference) {
        this.hotspotsPreference = hotspotsPreference;
    }

    public void fireNotificationInfo(String longMessage, String shortMessage, int nbLigne, boolean mutex, boolean hold, boolean forceDialog) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Message\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.notify(longMessage, shortMessage, nbLigne, mutex, hold, forceDialog);
        }
    }

    public void fireNotificationErrorSSL(String longMessage, String shortMessage) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"ErrorSSL\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.errorSSL(longMessage, shortMessage);
        }
    }

    public void fireNotificationNewVersion(String version) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"NewVersion\" : version = " + version);
        for (NotificationListener listener : this.notificationListeners) {
            listener.newVersion(version);
        }
    }

    public void fireNotificationNoInternet(String longMessage, String shortMessage) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"NoInternet\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.noInternet(longMessage, shortMessage);
        }
    }

    public void fireNotificationError(String longMessage, String shortMessage) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Error\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.error(longMessage, shortMessage);
        }
    }

    private void fireNotificationDownload(String version) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Download\" : version = " + version);
        for (NotificationListener listener : this.notificationListeners) {
            listener.download(version);
        }
    }

    private void fireNotificationCount(String message) {
        for (NotificationListener listener : this.notificationListeners) {
            listener.count(message);
        }
    }

    private void fireNotificationSFRNearEnd(int minutesLeft) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"SFRNearEnd\" : minutesLeft = " + minutesLeft);
        for (NotificationListener listener : this.notificationListeners) {
            listener.SFRNearEnd(minutesLeft);
        }
    }

    public void fireNotificationConnected() {
        this.connected = true;
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Connected\"");
        for (NotificationListener listener : this.notificationListeners) {
            listener.connected();
        }
    }

    public void fireNotificationDisconnected() {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Disconnected\"");
        for (NotificationListener listener : this.notificationListeners) {
            listener.disconnected();
        }
    }

    public void fireNotificationDisconnectFromModel() {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"Disconnected From Model\"");
        for (NotificationListener listener : this.notificationListeners) {
            listener.disconnectFromModel();
        }
    }

    public void fireNotificationLastHotspot(int hotspot, String lastLogin) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"LastHotspot\"");
        for (NotificationListener listener : this.notificationListeners) {
            listener.lastHotspot(hotspot, lastLogin);
        }
    }

    void fireNotificationNewCheck() {
        int number = ++this.numberOfCheck;
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"NewCheck\" : number = " + number);
        for (NotificationListener listener : this.notificationListeners) {
            listener.newCheck(number);
        }
    }

    public void fireNotificationNewReconnection() {
        int number = ++this.numberOfReconnection;
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"NewReconnection\" : number = " + number);
        for (NotificationListener listener : this.notificationListeners) {
            listener.newReconnection(number);
        }
    }

    private void fireNotificationCleanUp() {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"CleanUp\" ");
        for (NotificationListener listener : this.notificationListeners) {
            listener.cleanUp();
        }
    }

    public void fireNotificationLockHotspot(String longMessage, String shortMessage) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"LockHotspot\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.lockHotspot(longMessage, shortMessage);
        }
    }

    public void fireNotificationLockApp(String longMessage, String shortMessage) {
        Log.d(String.valueOf(this.className) + " : Lancement d'une nouvelle notification type \"LockApp\" : message = " + longMessage);
        for (NotificationListener listener : this.notificationListeners) {
            listener.lockApp(longMessage, shortMessage);
        }
    }

    public void fireUnlockApp() {
        Log.d(String.valueOf(this.className) + " : Unlock application ");
        for (NotificationListener listener : this.notificationListeners) {
            listener.unLockApp();
        }
    }

    public static void main(String[] args) {
        Log.v("MODEL MAIN :  Main Depuis model (test)");
        Model m = Model.getInstance();
        m.start();
    }
}

