/*
 * Decompiled with CFR 0.152.
 */
package fr.n3vision.hotspot;

import com.apple.eawt.Application;
import fr.n3vision.hotspot.core.Model;
import fr.n3vision.hotspot.core.ModifiableField;
import fr.n3vision.hotspot.lang.Lang;
import fr.n3vision.hotspot.ui.v3.MainFrame;
import fr.n3vision.hotspot.util.Functions;
import fr.n3vision.hotspot.util.Log;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    private static final String className = "fr.n3vision.hotspot3.Main";
    private static boolean start_cli = false;

    public static void main(String[] args) {
        Main main = new Main();
        if (args.length == 1 && args[0].equals("cli")) {
            start_cli = true;
        }
        if (start_cli) {
            main.startCLI();
        } else {
            main.startUI();
        }
    }

    private void startCLI() {
        Log.setCli(true);
        Log.i("fr.n3vision.hotspot3.Main : Starting HWR as CLI ; VERSION :3.1.7 ; VERSION_INT57");
        Model model = Model.getInstance();
        if (model.getGlobalPreference().isLaunchAtStartUp().booleanValue()) {
            model.start();
        }
        System.out.println("Hotspot Wifi Reconnecteur N3Vision.net");
        System.out.println("Vous pouvez taper des commandes ci-dessous :");
        block2: while (true) {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String command = "";
            try {
                command = br.readLine();
                if (command.equals("INFO")) {
                    ArrayList<String> system_info = Functions.getInfo();
                    int i = 0;
                    while (true) {
                        if (i >= system_info.size()) continue block2;
                        int j = i + 2;
                        System.out.println(String.valueOf(Lang.get("DIALOG_INFO" + j)) + " : " + system_info.get(i));
                        ++i;
                    }
                }
                if (command.equals("START")) {
                    if (!model.isLaunched()) {
                        System.out.println("D\u00e9marrage du HWR demand\u00e9");
                        model.start();
                        continue;
                    }
                    System.out.println("Le HWR est d\u00e9ja d\u00e9marr\u00e9");
                    continue;
                }
                if (command.equals("STOP")) {
                    if (model.isLaunched()) {
                        System.out.println("Arret du HWR demand\u00e9");
                        model.stop();
                        continue;
                    }
                    System.out.println("Le HWR est d\u00e9j\u00e0 \u00e9teint");
                    continue;
                }
                if (command.equals("PRINT")) {
                    if (model.isLaunched()) {
                        System.out.println("Le HWR est lanc\u00e9, il est impossible de modifier les pr\u00e9f\u00e9rences");
                        continue;
                    }
                    System.out.println("Affichage des Pr\u00e9f\u00e9rences :");
                    System.out.println("Cl\u00e9 : \t\t\t\tValeur :");
                    System.out.println(model.getGlobalPreference().readModifiablePreferences());
                    System.out.println("Pour modifier : EDIT + cl\u00e9 + valeur");
                    continue;
                }
                if (!command.startsWith("EDIT")) continue;
                String[] a = command.split(" ");
                String fieldName = a[1];
                String fieldValue = a[2];
                ModifiableField field = model.getGlobalPreference().getModifiabledFields().get(fieldName);
                if (field != null) {
                    boolean modificationFaite = field.changeValue(fieldValue);
                    if (modificationFaite) {
                        System.out.println("Remplacement du de la valeur de " + fieldName + " par " + fieldValue);
                        model.getPreferencesAccess().saveConfig(false, false);
                        continue;
                    }
                    System.out.println("Impossible de remplacer la valeur de " + fieldName + " par " + fieldValue + ". Les seules valeurs possibles sont : " + field.getAllowedValues());
                    continue;
                }
                System.out.println("Erreur : Le parametre modifi\u00e9 n'existe pas");
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IO error trying to read your name!");
                Log.e(ioe);
                continue;
            }
            break;
        }
    }

    private void startUI() {
        Log.i("fr.n3vision.hotspot3.Main : Launching of the UI application ; VERSION : 3.1.7 ; VERSION_INT : 57 ; hwrId : " + Functions.getAppId());
        if (System.getProperty("os.name").contains("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", Lang.get("TEXT_TITLE"));
            Application application = Application.getApplication();
            URL iconUrl = MainFrame.class.getResource("/fr/n3vision/hotspot/res/hwr/normal/icon_hwr_64.png");
            Image image = Toolkit.getDefaultToolkit().getImage(iconUrl);
            application.setDockIconImage(image);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException e) {
                Log.e(e);
            }
            catch (InstantiationException e) {
                Log.e(e);
            }
            catch (IllegalAccessException e) {
                Log.e(e);
            }
            catch (UnsupportedLookAndFeelException e) {
                Log.e(e);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log.i("fr.n3vision.hotspot3.Main : Swing : invokeLater : start graphical app");
                new MainFrame(Main.this);
            }
        });
    }

    public void changeMacDockIcon(boolean deleteIcon) {
    }
}

