#ifndef PSCAN_INCLUDED
#define PSCAN_INCLUDED


#define PSCAN_VERSION	"4.0"

typedef enum
{
	CLOSED = 0,
	OPEN = 1,
	TIMEDOUT = 2
} port_response;


#define OPTIONS_ALL_PORTS			0x00000001
#define OPTIONS_DONT_RESOLVE_PORTS	0x00000002
#define OPTIONS_RESOLVE_MAC			0x00000004
#define OPTIONS_ONFLY_HIDE			0x00000008
#define OPTIONS_SYN_SCAN			0x00000010

// output file types
#define TEXTFILE	1
#define XMLFILE		2
#define HTMLFILE	3


#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef void (*rescb)(port_response resp, unsigned short port);

// function prototypes
void on_response(port_response, unsigned short);
void net_init();
void net_end();
void struct_init(rescb cb, unsigned long wait_time);
void net_uninit();
int net_add(unsigned long ip, unsigned short port, unsigned long time);
int net_check(unsigned long time);
char *net_get_aip(unsigned long ip);
unsigned long net_get_iip(char *aip);
unsigned long ResolveHostname(char *);
void print_general(FILE *);
void print_general_to_file();
void print_help();
void print_config();
void print_port(unsigned short, char *, port_response);
void print_totals(unsigned long);
void print_mac(char *);
void output_init();
void output_end();
void SynScan(char *, int);

#endif //PSCAN_INCLUDED
