/*
 * Decompiled with CFR 0.152.
 */
package freenet.tools;

import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NodeHelloMessage;
import freenet.support.SimpleFieldSet;
import freenet.support.io.LineReadingInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class AddRef {
    public static void main(String[] args) {
        File reference;
        if (args.length < 1) {
            System.err.println("Please provide a file name as the first argument.");
            System.exit(-1);
        }
        if ((reference = new File(args[0])) == null || !reference.isFile() || !reference.canRead()) {
            System.err.println("Please provide a file name as the first argument.");
            System.exit(-1);
        }
        new AddRef(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    AddRef(File reference) {
        block15: {
            FCPMessage fcpm;
            Socket fcpSocket = null;
            SimpleFieldSet sfs = new SimpleFieldSet(true);
            fcpSocket = new Socket("127.0.0.1", 9481);
            fcpSocket.setSoTimeout(2000);
            InputStream is = fcpSocket.getInputStream();
            LineReadingInputStream lis = new LineReadingInputStream(is);
            OutputStream os = fcpSocket.getOutputStream();
            try {
                sfs.putSingle("Name", "AddRef");
                sfs.putSingle("ExpectedVersion", "2.0");
                fcpm = FCPMessage.create("ClientHello", sfs);
                fcpm.send(os);
                os.flush();
                String messageName = lis.readLine(128, 128, true);
                sfs = this.getMessage(lis);
                fcpm = FCPMessage.create(messageName, sfs);
                if (fcpm == null || !(fcpm instanceof NodeHelloMessage)) {
                    System.err.println("Not a valid FRED node!");
                    System.exit(1);
                }
            }
            catch (MessageInvalidException me) {
                me.printStackTrace();
            }
            try {
                sfs = SimpleFieldSet.readFrom(reference, false, true);
                fcpm = FCPMessage.create("AddPeer", sfs);
                fcpm.send(os);
                os.flush();
            }
            catch (MessageInvalidException me) {
                System.err.println("Invalid reference file!" + me);
                me.printStackTrace();
            }
            lis.close();
            is.close();
            os.close();
            fcpSocket.close();
            System.out.println("That reference has been added");
            Object var10_13 = null;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {}
            break block15;
            {
                catch (SocketException se) {
                    System.err.println(se);
                    se.printStackTrace();
                    System.exit(1);
                    Object var10_14 = null;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {}
                    break block15;
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                    ioe.printStackTrace();
                    System.exit(2);
                    Object var10_15 = null;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected SimpleFieldSet getMessage(LineReadingInputStream lis) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        try {
            while (lis.available() > 0) {
                String line = lis.readLine(128, 128, true);
                int index = line.indexOf(61);
                if (index == -1 || line.startsWith("End")) {
                    return sfs;
                }
                sfs.putSingle(line.substring(0, index), line.substring(index + 1));
            }
        }
        catch (IOException e) {
            return sfs;
        }
        return sfs;
    }
}

