/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.transport.ip;

import freenet.io.AddressIdentifier;
import freenet.node.NodeIPDetector;
import freenet.support.Logger;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressDetector
implements Runnable {
    private final int interval;
    private final NodeIPDetector detector;
    InetAddress[] lastAddressList = null;
    long lastDetectedTime = -1L;
    boolean old = false;

    public IPAddressDetector(int interval, NodeIPDetector detector) {
        this.interval = interval;
        this.detector = detector;
    }

    public String getCheckpointName() {
        return "Autodetection of IP addresses";
    }

    public long nextCheckpoint() {
        return System.currentTimeMillis() + (long)this.interval;
    }

    public InetAddress[] getAddress() {
        return this.getAddress(this.interval);
    }

    public InetAddress[] getAddress(long recheckTime) {
        if (System.currentTimeMillis() > this.lastDetectedTime + recheckTime) {
            this.checkpoint();
        }
        return this.lastAddressList == null ? new InetAddress[]{} : this.lastAddressList;
    }

    protected synchronized void checkpoint() {
        boolean logDEBUG = Logger.shouldLog(2, this);
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            Logger.error(this, "SocketException trying to detect NetworkInterfaces: " + e, e);
            addrs.add(this.oldDetect());
            this.old = true;
        }
        if (!this.old) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (logDEBUG) {
                    Logger.debug(this, "Scanning NetworkInterface " + iface.getDisplayName());
                }
                Enumeration<InetAddress> ee = iface.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress addr = ee.nextElement();
                    addrs.add(addr);
                    if (!logDEBUG) continue;
                    Logger.debug(this, "Adding address " + addr + " from " + iface.getDisplayName());
                }
                if (!logDEBUG) continue;
                Logger.debug(this, "Finished scanning interface " + iface.getDisplayName());
            }
            if (logDEBUG) {
                Logger.debug(this, "Finished scanning interfaces");
            }
        }
        Object[] oldAddressList = this.lastAddressList;
        this.onGetAddresses(addrs);
        this.lastDetectedTime = System.currentTimeMillis();
        if (oldAddressList != this.lastAddressList && (oldAddressList == null && this.lastAddressList != null || oldAddressList != null && this.lastAddressList != null && !Arrays.equals(oldAddressList, this.lastAddressList))) {
            this.detector.redetectAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetAddress oldDetect() {
        boolean shouldLog = Logger.shouldLog(2, this);
        if (shouldLog) {
            Logger.debug(this, "Running old style detection code");
        }
        DatagramSocket ds = null;
        try {
            try {
                ds = new DatagramSocket();
            }
            catch (SocketException e) {
                Logger.error(this, "SocketException", e);
                InetAddress inetAddress = null;
                Object var6_8 = null;
                if (ds != null) {
                    ds.close();
                }
                return inetAddress;
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_11 = null;
                if (ds == null) break block12;
                ds.close();
            }
            throw throwable;
        }
        try {
            ds.connect(InetAddress.getByName("198.41.0.4"), 53);
        }
        catch (UnknownHostException ex) {
            Logger.error(this, "UnknownHostException", ex);
            InetAddress inetAddress = null;
            Object var6_9 = null;
            if (ds != null) {
                ds.close();
            }
            return inetAddress;
        }
        InetAddress inetAddress = ds.getLocalAddress();
        Object var6_10 = null;
        if (ds != null) {
            ds.close();
        }
        return inetAddress;
    }

    protected void onGetAddresses(List<InetAddress> addrs) {
        ArrayList<InetAddress> output = new ArrayList<InetAddress>();
        boolean logDEBUG = Logger.shouldLog(2, this);
        if (logDEBUG) {
            Logger.debug(this, "onGetAddresses found " + addrs.size() + " potential addresses)");
        }
        if (addrs.size() == 0) {
            Logger.error(this, "No addresses found!");
            this.lastAddressList = null;
            return;
        }
        for (int x = 0; x < addrs.size(); ++x) {
            if (addrs.get(x) == null) continue;
            InetAddress i = addrs.get(x);
            if (logDEBUG) {
                Logger.debug(this, "Address " + x + ": " + i);
            }
            if (i.isAnyLocalAddress()) continue;
            if (i.isLinkLocalAddress() || i.isLoopbackAddress() || i.isSiteLocalAddress()) {
                output.add(i);
                continue;
            }
            if (i.isMulticastAddress() || AddressIdentifier.isAnISATAPIPv6Address(i.toString())) continue;
            output.add(i);
        }
        this.lastAddressList = output.toArray(new InetAddress[output.size()]);
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.checkpoint();
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                continue;
            }
            break;
        }
    }

    public void clearCached() {
        this.lastAddressList = null;
        this.lastDetectedTime = -1L;
    }
}

