/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.math.RunningAverage;

public class TrivialRunningAverage
implements RunningAverage {
    private static final long serialVersionUID = 1L;
    private long reports;
    private double total;

    public TrivialRunningAverage(TrivialRunningAverage average) {
        this.reports = average.reports;
        this.total = average.total;
    }

    public TrivialRunningAverage() {
        this.reports = 0L;
        this.total = 0.0;
    }

    public synchronized long countReports() {
        return this.reports;
    }

    public synchronized double currentValue() {
        return this.total / (double)this.reports;
    }

    public synchronized void report(double d) {
        this.total += d;
        ++this.reports;
    }

    public void report(long d) {
        this.report((double)d);
    }

    public synchronized double valueIfReported(double r) {
        return (this.total + r) / (double)(this.reports + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        TrivialRunningAverage trivialRunningAverage = this;
        synchronized (trivialRunningAverage) {
            return new TrivialRunningAverage(this);
        }
    }
}

