/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.node.TimeSkewDetectorCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.math.RunningAverage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TimeDecayingRunningAverage
implements RunningAverage {
    private static final long serialVersionUID = -1L;
    static final int MAGIC = 1609870484;
    double curValue;
    final double halfLife;
    long lastReportTime;
    long createdTime;
    long totalReports;
    boolean started;
    double defaultValue;
    double minReport;
    double maxReport;
    boolean logDEBUG;
    private final TimeSkewDetectorCallback timeSkewCallback;

    public final Object clone() {
        return new TimeDecayingRunningAverage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long now = System.currentTimeMillis();
        TimeDecayingRunningAverage timeDecayingRunningAverage = this;
        synchronized (timeDecayingRunningAverage) {
            return super.toString() + ": currentValue=" + this.curValue + ", halfLife=" + this.halfLife + ", lastReportTime=" + (now - this.lastReportTime) + "ms ago, createdTime=" + (now - this.createdTime) + "ms ago, totalReports=" + this.totalReports + ", started=" + this.started + ", defaultValue=" + this.defaultValue + ", min=" + this.minReport + ", max=" + this.maxReport;
        }
    }

    public TimeDecayingRunningAverage(double defaultValue, long halfLife, double min, double max, TimeSkewDetectorCallback callback) {
        this.curValue = defaultValue;
        this.defaultValue = defaultValue;
        this.started = false;
        this.halfLife = halfLife;
        this.createdTime = this.lastReportTime = System.currentTimeMillis();
        this.minReport = min;
        this.maxReport = max;
        this.totalReports = 0L;
        this.logDEBUG = Logger.shouldLog(2, this);
        if (this.logDEBUG) {
            Logger.debug(this, "Created " + this, new Exception("debug"));
        }
        this.timeSkewCallback = callback;
    }

    public TimeDecayingRunningAverage(double defaultValue, long halfLife, double min, double max, SimpleFieldSet fs, TimeSkewDetectorCallback callback) {
        this.curValue = defaultValue;
        this.defaultValue = defaultValue;
        this.started = false;
        this.halfLife = halfLife;
        this.createdTime = System.currentTimeMillis();
        this.lastReportTime = -1L;
        this.minReport = min;
        this.maxReport = max;
        this.totalReports = 0L;
        this.logDEBUG = Logger.shouldLog(2, this);
        if (this.logDEBUG) {
            Logger.debug(this, "Created " + this, new Exception("debug"));
        }
        if (fs != null) {
            this.started = fs.getBoolean("Started", false);
            if (this.started) {
                this.curValue = fs.getDouble("CurrentValue", this.curValue);
                if (this.curValue > this.maxReport || this.curValue < this.minReport || Double.isNaN(this.curValue)) {
                    this.curValue = defaultValue;
                    this.totalReports = 0L;
                    this.createdTime = System.currentTimeMillis();
                } else {
                    this.totalReports = fs.getLong("TotalReports", 0L);
                    long uptime = fs.getLong("Uptime", 0L);
                    this.createdTime = System.currentTimeMillis() - uptime;
                }
            }
        }
        this.timeSkewCallback = callback;
    }

    public TimeDecayingRunningAverage(double defaultValue, double halfLife, double min, double max, DataInputStream dis, TimeSkewDetectorCallback callback) throws IOException {
        int m = dis.readInt();
        if (m != 1609870484) {
            throw new IOException("Invalid magic " + m);
        }
        int v = dis.readInt();
        if (v != 1) {
            throw new IOException("Invalid version " + v);
        }
        this.curValue = dis.readDouble();
        if (Double.isInfinite(this.curValue) || Double.isNaN(this.curValue)) {
            throw new IOException("Invalid weightedTotal: " + this.curValue);
        }
        if (this.curValue < min || this.curValue > max) {
            throw new IOException("Out of range: curValue = " + this.curValue);
        }
        this.started = dis.readBoolean();
        long priorExperienceTime = dis.readLong();
        this.halfLife = halfLife;
        this.minReport = min;
        this.maxReport = max;
        this.defaultValue = defaultValue;
        this.logDEBUG = Logger.shouldLog(2, this);
        this.lastReportTime = -1L;
        this.createdTime = System.currentTimeMillis() - priorExperienceTime;
        this.totalReports = dis.readLong();
        this.timeSkewCallback = callback;
    }

    public TimeDecayingRunningAverage(TimeDecayingRunningAverage a) {
        this.createdTime = a.createdTime;
        this.defaultValue = a.defaultValue;
        this.halfLife = a.halfLife;
        this.lastReportTime = a.lastReportTime;
        this.maxReport = a.maxReport;
        this.minReport = a.minReport;
        this.started = a.started;
        this.totalReports = a.totalReports;
        this.curValue = a.curValue;
        this.timeSkewCallback = a.timeSkewCallback;
    }

    public synchronized double currentValue() {
        return this.curValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(double d) {
        TimeDecayingRunningAverage timeDecayingRunningAverage = this;
        synchronized (timeDecayingRunningAverage) {
            long now = System.currentTimeMillis();
            if (d < this.minReport) {
                Logger.error(this, "Impossible: " + d + " on " + this, new Exception("error"));
                return;
            }
            if (d > this.maxReport) {
                Logger.error(this, "Impossible: " + d + " on " + this, new Exception("error"));
                return;
            }
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                Logger.error(this, "Reported infinity or NaN to " + this + " : " + d, new Exception("error"));
                return;
            }
            ++this.totalReports;
            if (!this.started) {
                this.curValue = d;
                this.started = true;
                if (this.logDEBUG) {
                    Logger.debug(this, "Reported " + d + " on " + this + " when just started");
                }
            } else if (this.lastReportTime != -1L) {
                long thisInterval = now - this.lastReportTime;
                long uptime = now - this.createdTime;
                if (thisInterval < 0L) {
                    Logger.error(this, "Clock (reporting) went back in time, ignoring report: " + now + " was " + this.lastReportTime + " (back " + -thisInterval + "ms)");
                    this.lastReportTime = now;
                    if (this.timeSkewCallback != null) {
                        this.timeSkewCallback.setTimeSkewDetectedUserAlert();
                    }
                    return;
                }
                double thisHalfLife = this.halfLife;
                if (uptime < 0L) {
                    Logger.error(this, "Clock (uptime) went back in time, ignoring report: " + now + " was " + this.createdTime + " (back " + -uptime + "ms)");
                    if (this.timeSkewCallback != null) {
                        this.timeSkewCallback.setTimeSkewDetectedUserAlert();
                    }
                    return;
                }
                if (thisHalfLife == 0.0) {
                    thisHalfLife = 1.0;
                }
                double changeFactor = Math.pow(0.5, (double)thisInterval / thisHalfLife);
                double oldCurValue = this.curValue;
                this.curValue = this.curValue * changeFactor + (1.0 - changeFactor) * d;
                if (this.curValue < this.minReport || this.curValue > this.maxReport) {
                    Logger.error(this, "curValue=" + this.curValue + " was " + oldCurValue + " - out of range");
                    this.curValue = oldCurValue;
                }
                if (this.logDEBUG) {
                    Logger.debug(this, "Reported " + d + " on " + this + ": thisInterval=" + thisInterval + ", halfLife=" + this.halfLife + ", uptime=" + uptime + ", thisHalfLife=" + thisHalfLife + ", changeFactor=" + changeFactor + ", oldCurValue=" + oldCurValue + ", currentValue=" + this.currentValue() + ", thisInterval=" + thisInterval + ", thisHalfLife=" + thisHalfLife + ", uptime=" + uptime + ", changeFactor=" + changeFactor);
                }
            }
            this.lastReportTime = now;
        }
    }

    public void report(long d) {
        this.report((double)d);
    }

    public double valueIfReported(double r) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataTo(DataOutputStream out) throws IOException {
        long now = System.currentTimeMillis();
        TimeDecayingRunningAverage timeDecayingRunningAverage = this;
        synchronized (timeDecayingRunningAverage) {
            out.writeInt(1609870484);
            out.writeInt(1);
            out.writeDouble(this.curValue);
            out.writeBoolean(this.started);
            out.writeLong(this.totalReports);
            out.writeLong(now - this.createdTime);
        }
    }

    public int getDataLength() {
        return 41;
    }

    public synchronized long countReports() {
        return this.totalReports;
    }

    public synchronized long lastReportTime() {
        return this.lastReportTime;
    }

    public synchronized SimpleFieldSet exportFieldSet(boolean shortLived) {
        SimpleFieldSet fs = new SimpleFieldSet(shortLived);
        fs.putSingle("Type", "TimeDecayingRunningAverage");
        fs.put("CurrentValue", this.curValue);
        fs.put("Started", this.started);
        fs.put("TotalReports", this.totalReports);
        fs.put("Uptime", System.currentTimeMillis() - this.createdTime);
        return fs;
    }
}

