/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.node.Location;
import freenet.support.SimpleFieldSet;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.RunningAverage;

public class DecayingKeyspaceAverage
implements RunningAverage {
    private static final long serialVersionUID = 5129429614949179428L;
    BootstrappingDecayingRunningAverage avg;

    public DecayingKeyspaceAverage(double defaultValue, int maxReports, SimpleFieldSet fs) {
        this.avg = new BootstrappingDecayingRunningAverage(defaultValue, -2.0, 2.0, maxReports, fs);
    }

    public DecayingKeyspaceAverage(BootstrappingDecayingRunningAverage a) {
        this.avg = (BootstrappingDecayingRunningAverage)a.clone();
    }

    public synchronized Object clone() {
        return new DecayingKeyspaceAverage(this.avg);
    }

    public synchronized double currentValue() {
        return this.avg.currentValue();
    }

    public synchronized void report(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Not a valid normalized key: " + d);
        }
        double superValue = this.avg.currentValue();
        double thisValue = Location.normalize(superValue);
        double diff = Location.change(thisValue, d);
        double toAverage = superValue + diff;
        this.avg.report(toAverage);
        double newValue = this.avg.currentValue();
        if (newValue < 0.0 || newValue > 1.0) {
            this.avg.setCurrentValue(Location.normalize(newValue));
        }
    }

    public synchronized double valueIfReported(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Not a valid normalized key: " + d);
        }
        double superValue = this.avg.currentValue();
        double thisValue = Location.normalize(superValue);
        double diff = Location.change(thisValue, d);
        return Location.normalize(this.avg.valueIfReported(superValue + diff));
    }

    public synchronized long countReports() {
        return this.avg.countReports();
    }

    public void report(long d) {
        throw new IllegalArgumentException("KeyspaceAverage does not like longs");
    }

    public synchronized void changeMaxReports(int maxReports) {
        this.avg.changeMaxReports(maxReports);
    }

    public synchronized SimpleFieldSet exportFieldSet(boolean shortLived) {
        return this.avg.exportFieldSet(shortLived);
    }

    public static void main(String[] args) {
        int i;
        int wrap;
        int i2;
        DecayingKeyspaceAverage a = new DecayingKeyspaceAverage(0.9, 10, null);
        a.report(0.9);
        for (i2 = 10; i2 != 0; --i2) {
            a.report(0.2);
            System.out.println("<-0.2-- current=" + a.currentValue());
        }
        for (i2 = 10; i2 != 0; --i2) {
            a.report(0.8);
            System.out.println("--0.8-> current=" + a.currentValue());
        }
        System.out.println("--- positive wrap test ---");
        for (wrap = 3; wrap != 0; --wrap) {
            System.out.println("wrap test #" + wrap);
            for (i = 10; i != 0; --i) {
                a.report(0.25);
                System.out.println("<-0.25- current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(0.5);
                System.out.println("--0.5-> current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(0.75);
                System.out.println("-0.75-> current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(1.0);
                System.out.println("<-1.0-- current=" + a.currentValue());
            }
        }
        System.out.println("--- negative wrap test ---");
        a = new DecayingKeyspaceAverage(0.2, 10, null);
        a.report(0.2);
        for (wrap = 3; wrap != 0; --wrap) {
            System.out.println("negwrap test #" + wrap);
            for (i = 10; i != 0; --i) {
                a.report(0.75);
                System.out.println("-0.75-> current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(0.5);
                System.out.println("<-0.5-- current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(0.25);
                System.out.println("<-0.25- current=" + a.currentValue());
            }
            for (i = 10; i != 0; --i) {
                a.report(1.0);
                System.out.println("--1.0-> current=" + a.currentValue());
            }
        }
    }
}

