/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.math.RunningAverage;

public final class BootstrappingDecayingRunningAverage
implements RunningAverage {
    private static final long serialVersionUID = -1L;
    private final double min;
    private final double max;
    private double currentValue;
    private long reports;
    private int maxReports;

    public final Object clone() {
        return new BootstrappingDecayingRunningAverage(this);
    }

    public BootstrappingDecayingRunningAverage(double defaultValue, double min, double max, int maxReports, SimpleFieldSet fs) {
        this.min = min;
        this.max = max;
        this.reports = 0L;
        this.currentValue = defaultValue;
        this.maxReports = maxReports;
        if (fs != null) {
            this.currentValue = fs.getDouble("CurrentValue", this.currentValue);
            this.reports = fs.getLong("Reports", this.reports);
        }
    }

    public synchronized double currentValue() {
        return this.currentValue;
    }

    protected synchronized double setCurrentValue(double d) {
        double old = this.currentValue;
        this.currentValue = d;
        return old;
    }

    public synchronized void report(double d) {
        if (d < this.min) {
            if (Logger.shouldLog(2, this)) {
                Logger.debug(this, "Too low: " + d, new Exception("debug"));
            }
            d = this.min;
        }
        if (d > this.max) {
            if (Logger.shouldLog(2, this)) {
                Logger.debug(this, "Too high: " + d, new Exception("debug"));
            }
            d = this.max;
        }
        ++this.reports;
        double decayFactor = 1.0 / (double)Math.min(this.reports, (long)this.maxReports);
        this.currentValue = d * decayFactor + this.currentValue * (1.0 - decayFactor);
    }

    public void report(long d) {
        this.report((double)d);
    }

    public synchronized double valueIfReported(double d) {
        if (d < this.min) {
            Logger.error(this, "Too low: " + d, new Exception("debug"));
            d = this.min;
        }
        if (d > this.max) {
            Logger.error(this, "Too high: " + d, new Exception("debug"));
            d = this.max;
        }
        double decayFactor = 1.0 / (double)Math.min(this.reports + 1L, (long)this.maxReports);
        return d * decayFactor + this.currentValue * (1.0 - decayFactor);
    }

    public synchronized void changeMaxReports(int maxReports) {
        this.maxReports = maxReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BootstrappingDecayingRunningAverage(BootstrappingDecayingRunningAverage a) {
        BootstrappingDecayingRunningAverage bootstrappingDecayingRunningAverage = a;
        synchronized (bootstrappingDecayingRunningAverage) {
            this.currentValue = a.currentValue;
            this.max = a.max;
            this.maxReports = a.maxReports;
            this.min = a.min;
            this.reports = a.reports;
        }
    }

    public synchronized long countReports() {
        return this.reports;
    }

    public synchronized SimpleFieldSet exportFieldSet(boolean shortLived) {
        SimpleFieldSet fs = new SimpleFieldSet(shortLived);
        fs.putSingle("Type", "BootstrappingDecayingRunningAverage");
        fs.put("CurrentValue", this.currentValue);
        fs.put("Reports", this.reports);
        return fs;
    }
}

