/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.SerializableToFieldSetBucket;
import java.io.File;
import java.io.IOException;

public class TempFileBucket
extends BaseFileBucket
implements Bucket,
SerializableToFieldSetBucket {
    long filenameID;
    final FilenameGenerator generator;
    private static boolean logDebug = true;
    private boolean readOnly;
    private final boolean deleteOnFree;

    public TempFileBucket(long id, FilenameGenerator generator) {
        this(id, generator, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TempFileBucket(long id, FilenameGenerator generator, boolean deleteOnExit, boolean deleteOnFree) {
        super(generator.getFilename(id), deleteOnExit);
        this.filenameID = id;
        this.generator = generator;
        this.deleteOnFree = deleteOnFree;
        TempFileBucket tempFileBucket = this;
        synchronized (tempFileBucket) {
            logDebug = Logger.shouldLog(2, this);
        }
        tempFileBucket = this;
        synchronized (tempFileBucket) {
            if (logDebug) {
                Logger.debug(this, "Initializing TempFileBucket(" + this.getFile() + " deleteOnExit=" + deleteOnExit);
            }
        }
    }

    protected boolean deleteOnFinalize() {
        return this.deleteOnFree;
    }

    public SimpleFieldSet toFieldSet() {
        if (this.deleteOnFinalize()) {
            return null;
        }
        return super.toFieldSet();
    }

    protected boolean createFileOnly() {
        return false;
    }

    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    public File getFile() {
        return this.generator.getFilename(this.filenameID);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    protected boolean deleteOnExit() {
        return true;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this.generator);
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Removing from database: " + this);
        }
        container.delete((Object)this);
    }

    public Bucket createShadow() throws IOException {
        TempFileBucket ret = new TempFileBucket(this.filenameID, this.generator, true, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }
}

