/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.RandomSource;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.ArrayBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.TempFileBucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;

public class TempBucketFactory
implements BucketFactory {
    public static final long defaultIncrement = 4096L;
    public static final float DEFAULT_FACTOR = 1.25f;
    private final FilenameGenerator filenameGenerator;
    private long bytesInUse = 0L;
    private final RandomSource strongPRNG;
    private final Random weakPRNG;
    private final Executor executor;
    private volatile boolean logMINOR;
    private volatile boolean reallyEncrypt;
    private long maxRAMBucketSize;
    private long maxRamUsed;
    private final int RAMBUCKET_MAX_AGE = 300000;
    static final int RAMBUCKET_CONVERSION_FACTOR = 4;
    static final boolean TRACE_BUCKET_LEAKS = false;
    private final Queue<WeakReference<TempBucket>> ramBucketQueue = new LinkedBlockingQueue<WeakReference<TempBucket>>();

    public TempBucketFactory(Executor executor, FilenameGenerator filenameGenerator, long maxBucketSizeKeptInRam, long maxRamUsed, RandomSource strongPRNG, Random weakPRNG, boolean reallyEncrypt) {
        this.filenameGenerator = filenameGenerator;
        this.maxRamUsed = maxRamUsed;
        this.maxRAMBucketSize = maxBucketSizeKeptInRam;
        this.strongPRNG = strongPRNG;
        this.weakPRNG = weakPRNG;
        this.reallyEncrypt = reallyEncrypt;
        this.executor = executor;
        this.logMINOR = Logger.shouldLog(4, this);
    }

    public Bucket makeBucket(long size) throws IOException {
        return this.makeBucket(size, 1.25f, 4096L);
    }

    public Bucket makeBucket(long size, float factor) throws IOException {
        return this.makeBucket(size, factor, 4096L);
    }

    private synchronized void _hasTaken(long size) {
        this.bytesInUse += size;
    }

    private synchronized void _hasFreed(long size) {
        this.bytesInUse -= size;
    }

    public synchronized long getRamUsed() {
        return this.bytesInUse;
    }

    public synchronized void setMaxRamUsed(long size) {
        this.logMINOR = Logger.shouldLog(4, this);
        this.maxRamUsed = size;
    }

    public synchronized long getMaxRamUsed() {
        this.logMINOR = Logger.shouldLog(4, this);
        return this.maxRamUsed;
    }

    public synchronized void setMaxRAMBucketSize(long size) {
        this.logMINOR = Logger.shouldLog(4, this);
        this.maxRAMBucketSize = size;
    }

    public synchronized long getMaxRAMBucketSize() {
        this.logMINOR = Logger.shouldLog(4, this);
        return this.maxRAMBucketSize;
    }

    public void setEncryption(boolean value) {
        this.logMINOR = Logger.shouldLog(4, this);
        this.reallyEncrypt = value;
    }

    public boolean isEncrypting() {
        return this.reallyEncrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempBucket makeBucket(long size, float factor, long increment) throws IOException {
        Bucket realBucket = null;
        boolean useRAMBucket = false;
        long now = System.currentTimeMillis();
        this.cleanBucketQueue(now);
        TempBucketFactory tempBucketFactory = this;
        synchronized (tempBucketFactory) {
            if (size > 0L && size <= this.maxRAMBucketSize && this.bytesInUse <= this.maxRamUsed) {
                useRAMBucket = true;
            }
        }
        realBucket = useRAMBucket ? new ArrayBucket() : this._makeFileBucket();
        TempBucket toReturn = new TempBucket(now, realBucket);
        if (useRAMBucket) {
            Queue<WeakReference<TempBucket>> queue = this.ramBucketQueue;
            synchronized (queue) {
                this.ramBucketQueue.add(toReturn.getReference());
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBucketQueue(long now) {
        boolean shouldContinue = true;
        final LinkedList<TempBucket> toMigrate = new LinkedList<TempBucket>();
        do {
            Queue<WeakReference<TempBucket>> queue = this.ramBucketQueue;
            synchronized (queue) {
                WeakReference<TempBucket> tmpBucketRef = this.ramBucketQueue.peek();
                if (tmpBucketRef == null) {
                    shouldContinue = false;
                } else {
                    TempBucket tmpBucket = (TempBucket)tmpBucketRef.get();
                    if (tmpBucket == null) {
                        this.ramBucketQueue.remove(tmpBucketRef);
                        continue;
                    }
                    if (tmpBucket.creationTime + 300000L > now) {
                        shouldContinue = false;
                    } else {
                        if (this.logMINOR) {
                            Logger.minor(this, "The bucket is " + TimeUtil.formatTime(now - tmpBucket.creationTime) + " old: we will force-migrate it to disk.");
                        }
                        this.ramBucketQueue.remove(tmpBucketRef);
                        toMigrate.add(tmpBucket);
                    }
                }
            }
        } while (shouldContinue);
        if (toMigrate.size() > 0) {
            this.executor.execute(new Runnable(){

                public void run() {
                    if (TempBucketFactory.this.logMINOR) {
                        Logger.minor(this, "We are going to migrate " + toMigrate.size() + " RAMBuckets");
                    }
                    for (TempBucket tmpBucket : toMigrate) {
                        try {
                            tmpBucket.migrateToFileBucket();
                        }
                        catch (IOException e) {
                            Logger.error(tmpBucket, "An IOE occured while migrating long-lived buckets:" + e.getMessage(), e);
                        }
                    }
                }
            }, "RAMBucket migrator (" + now + ')');
        }
    }

    private Bucket _makeFileBucket() {
        TempFileBucket fileBucket = new TempFileBucket(this.filenameGenerator.makeRandomFilename(), this.filenameGenerator, true, true);
        return this.reallyEncrypt ? new PaddedEphemerallyEncryptedBucket(fileBucket, 1024, this.strongPRNG, this.weakPRNG) : fileBucket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempBucket
    implements Bucket {
        private Bucket currentBucket;
        private long currentSize;
        private boolean hasWritten;
        private OutputStream os = null;
        private final Vector<TempBucketInputStream> tbis;
        private short osIndex;
        public final long creationTime;
        private boolean hasBeenFreed = false;
        private final Throwable tracer;
        private WeakReference<TempBucket> weakRef = new WeakReference<TempBucket>(this);

        public TempBucket(long now, Bucket cur) {
            if (cur == null) {
                throw new NullPointerException();
            }
            this.tracer = null;
            this.currentBucket = cur;
            this.creationTime = now;
            this.osIndex = 0;
            this.tbis = new Vector(1);
            if (TempBucketFactory.this.logMINOR) {
                Logger.minor(this, "Created " + this, (Throwable)new Exception("debug"));
            }
        }

        private synchronized void closeInputStreams(boolean forFree) {
            ListIterator<TempBucketInputStream> i = this.tbis.listIterator();
            while (i.hasNext()) {
                TempBucketInputStream is = i.next();
                if (forFree) {
                    i.remove();
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught " + e + " closing " + is);
                    }
                    continue;
                }
                try {
                    is._maybeResetInputStream();
                }
                catch (IOException e) {
                    i.remove();
                    Closer.close(is);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void migrateToFileBucket() throws IOException {
            Bucket toMigrate = null;
            TempBucket tempBucket = this;
            synchronized (tempBucket) {
                if (!this.isRAMBucket() || this.hasBeenFreed) {
                    return;
                }
                toMigrate = this.currentBucket;
                Bucket tempFB = TempBucketFactory.this._makeFileBucket();
                if (this.os != null) {
                    this.os.flush();
                    Closer.close(this.os);
                    this.os = tempFB.getOutputStream();
                    if (this.currentSize > 0L) {
                        BucketTools.copyTo(toMigrate, this.os, this.currentSize);
                    }
                } else if (this.currentSize > 0L) {
                    OutputStream temp = tempFB.getOutputStream();
                    BucketTools.copyTo(toMigrate, temp, this.currentSize);
                    temp.close();
                }
                if (toMigrate.isReadOnly()) {
                    tempFB.setReadOnly();
                }
                this.closeInputStreams(false);
                this.currentBucket = tempFB;
            }
            if (TempBucketFactory.this.logMINOR) {
                Logger.minor(this, "We have migrated " + toMigrate.hashCode());
            }
            toMigrate.free();
            TempBucketFactory.this._hasFreed(toMigrate.size());
        }

        public final synchronized boolean isRAMBucket() {
            return this.currentBucket instanceof ArrayBucket;
        }

        @Override
        public synchronized OutputStream getOutputStream() throws IOException {
            if (this.osIndex > 0) {
                throw new IOException("Only one OutputStream per bucket!");
            }
            this.hasWritten = true;
            this.osIndex = (short)(this.osIndex + 1);
            TempBucketOutputStream os = new TempBucketOutputStream(this.osIndex);
            if (TempBucketFactory.this.logMINOR) {
                Logger.minor(this, "Got " + os + " for " + this, (Throwable)new Exception());
            }
            return os;
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            if (!this.hasWritten) {
                throw new IOException("No OutputStream has been openned! Why would you want an InputStream then?");
            }
            TempBucketInputStream is = new TempBucketInputStream(this.osIndex);
            this.tbis.add(is);
            if (TempBucketFactory.this.logMINOR) {
                Logger.minor(this, "Got " + is + " for " + this, (Throwable)new Exception());
            }
            return is;
        }

        @Override
        public synchronized String getName() {
            return this.currentBucket.getName();
        }

        @Override
        public synchronized long size() {
            return this.currentSize;
        }

        @Override
        public synchronized boolean isReadOnly() {
            return this.currentBucket.isReadOnly();
        }

        @Override
        public synchronized void setReadOnly() {
            this.currentBucket.setReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void free() {
            if (this.hasBeenFreed) {
                return;
            }
            this.hasBeenFreed = true;
            Closer.close(this.os);
            this.closeInputStreams(true);
            this.currentBucket.free();
            if (this.isRAMBucket()) {
                TempBucketFactory.this._hasFreed(this.currentSize);
                Queue queue = TempBucketFactory.this.ramBucketQueue;
                synchronized (queue) {
                    TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
                }
            }
        }

        @Override
        public Bucket createShadow() throws IOException {
            return this.currentBucket.createShadow();
        }

        @Override
        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void storeTo(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        public WeakReference<TempBucket> getReference() {
            return this.weakRef;
        }

        protected void finalize() {
            if (!this.hasBeenFreed) {
                this.free();
            }
        }

        private class TempBucketInputStream
        extends InputStream {
            private InputStream currentIS;
            private long index = 0L;
            private final short idx;

            TempBucketInputStream(short idx) throws IOException {
                this.idx = idx;
                this.currentIS = TempBucket.this.currentBucket.getInputStream();
            }

            public void _maybeResetInputStream() throws IOException {
                if (this.idx != TempBucket.this.osIndex) {
                    this.close();
                } else {
                    Closer.close(this.currentIS);
                    this.currentIS = TempBucket.this.currentBucket.getInputStream();
                    for (long toSkip = this.index; toSkip > 0L; toSkip -= this.currentIS.skip(toSkip)) {
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int read() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    int toReturn = this.currentIS.read();
                    if (toReturn != -1) {
                        ++this.index;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    return this.read(b, 0, b.length);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    int toReturn = this.currentIS.read(b, off, len);
                    if (toReturn > 0) {
                        this.index += (long)toReturn;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long skip(long n) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long skipped = this.currentIS.skip(n);
                    this.index += skipped;
                    return skipped;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int available() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    return this.currentIS.available();
                }
            }

            public boolean markSupported() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    Closer.close(this.currentIS);
                    TempBucket.this.tbis.remove(this);
                }
            }
        }

        private class TempBucketOutputStream
        extends OutputStream {
            boolean closed = false;

            TempBucketOutputStream(short idx) throws IOException {
                if (TempBucket.this.os == null) {
                    TempBucket.this.os = TempBucket.this.currentBucket.getOutputStream();
                }
            }

            private void _maybeMigrateRamBucket(long futureSize) throws IOException {
                if (TempBucket.this.isRAMBucket()) {
                    boolean shouldMigrate = false;
                    boolean isOversized = false;
                    if (futureSize >= Math.min(Integer.MAX_VALUE, TempBucketFactory.this.maxRAMBucketSize * 4L)) {
                        isOversized = true;
                        shouldMigrate = true;
                    } else if (futureSize - TempBucket.this.currentSize + TempBucketFactory.this.bytesInUse >= TempBucketFactory.this.maxRamUsed) {
                        shouldMigrate = true;
                    }
                    if (shouldMigrate) {
                        if (TempBucketFactory.this.logMINOR) {
                            if (isOversized) {
                                Logger.minor(this, "The bucket is over " + SizeUtil.formatSize(TempBucketFactory.this.maxRAMBucketSize * 4L) + ": we will force-migrate it to disk.");
                            } else {
                                Logger.minor(this, "The bucketpool is full: force-migrate before we go over the limit");
                            }
                        }
                        TempBucket.this.migrateToFileBucket();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void write(int b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long futureSize = TempBucket.this.currentSize + 1L;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(1L);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void write(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long futureSize = TempBucket.this.currentSize + (long)len;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b, off, len);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(len);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void flush() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    if (!this.closed) {
                        TempBucket.this.os.flush();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (this.closed) {
                        return;
                    }
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    TempBucket.this.os.flush();
                    TempBucket.this.os.close();
                    TempBucket.this.os = null;
                    this.closed = true;
                }
            }
        }
    }
}

