/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.crypt.RandomSource;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.DelayedFreeBucket;
import freenet.support.io.NullBucket;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempFileBucket;
import freenet.support.io.ReadOnlyFileSliceBucket;

public class SerializableToFieldSetBucketUtil {
    public static Bucket create(SimpleFieldSet fs, RandomSource random, PersistentFileTracker f) throws CannotCreateFromFieldSetException {
        if (fs == null) {
            if (Logger.shouldLog(4, SerializableToFieldSetBucketUtil.class)) {
                Logger.minor(SerializableToFieldSetBucketUtil.class, "fs = null", (Throwable)new Exception("debug"));
            }
            return null;
        }
        String type = fs.get("Type");
        if (Logger.shouldLog(4, SerializableToFieldSetBucketUtil.class)) {
            Logger.minor(SerializableToFieldSetBucketUtil.class, "Creating: " + type);
        }
        if (type == null) {
            throw new CannotCreateFromFieldSetException("No type");
        }
        if (type.equals("FileBucket")) {
            return BaseFileBucket.create(fs, f);
        }
        if (type.equals("PaddedEphemerallyEncryptedBucket")) {
            return new PaddedEphemerallyEncryptedBucket(fs, random, f);
        }
        if (type.equals("NullBucket")) {
            return new NullBucket();
        }
        if (type.equals("ReadOnlyFileSliceBucket")) {
            return new ReadOnlyFileSliceBucket(fs);
        }
        if (type.equals("DelayedFreeBucket")) {
            return new DelayedFreeBucket(fs, random, f);
        }
        if (type.equals("PersistentTempFileBucket")) {
            return PersistentTempFileBucket.create(fs, f);
        }
        throw new CannotCreateFromFieldSetException("Unrecognized type " + type);
    }
}

