/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.SegmentedBucketChainBucket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class SegmentedChainBucketSegment {
    private final ArrayList<Bucket> buckets;
    private final SegmentedBucketChainBucket bcb;

    public SegmentedChainBucketSegment(SegmentedBucketChainBucket bucket) {
        this.bcb = bucket;
        this.buckets = new ArrayList();
    }

    public void free() {
        for (Bucket bucket : this.buckets) {
            if (bucket == null) {
                Logger.error(this, "Bucket is null on " + this);
                continue;
            }
            bucket.free();
        }
    }

    public void storeTo(ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Storing segment " + this);
        }
        for (Bucket bucket : this.buckets) {
            bucket.storeTo(container);
        }
        container.ext().store(this.buckets, 1);
        container.ext().store((Object)this, 1);
    }

    public synchronized Bucket[] shallowCopyBuckets() {
        int sz = this.buckets.size();
        Bucket[] out = new Bucket[sz];
        for (int i = 0; i < sz; ++i) {
            out[i] = this.buckets.get(i);
        }
        return out;
    }

    public synchronized void shallowCopyBuckets(Bucket[] out, int index) {
        int sz = this.buckets.size();
        for (int i = 0; i < sz; ++i) {
            out[index++] = this.buckets.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream makeBucketStream(int bucketNo) throws IOException {
        if (bucketNo >= this.bcb.segmentSize) {
            throw new IllegalArgumentException("Too many buckets in segment");
        }
        Bucket b = this.bcb.bf.makeBucket(this.bcb.bucketSize);
        SegmentedChainBucketSegment segmentedChainBucketSegment = this;
        synchronized (segmentedChainBucketSegment) {
            if (this.buckets.size() != bucketNo) {
                throw new IllegalArgumentException("Next bucket should be " + this.buckets.size() + " but is " + bucketNo);
            }
            this.buckets.add(b);
        }
        return b.getOutputStream();
    }

    public int size() {
        return this.buckets.size();
    }

    void activateBuckets(ObjectContainer container) {
        container.activate(this.buckets, 1);
        for (Bucket bucket : this.buckets) {
            container.activate((Object)bucket, 1);
        }
    }

    public void clear(ObjectContainer container) {
        this.buckets.clear();
        container.delete(this.buckets);
        container.delete((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        for (Bucket bucket : this.buckets) {
            if (bucket == null) continue;
            container.activate((Object)bucket, 1);
            bucket.removeFrom(container);
        }
        container.delete(this.buckets);
        container.delete((Object)this);
    }
}

