/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketArrayWrapper;
import freenet.support.io.NotPersistentBucket;
import freenet.support.io.SegmentedBucketChainBucketKillJob;
import freenet.support.io.SegmentedChainBucketSegment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class SegmentedBucketChainBucket
implements NotPersistentBucket {
    private final ArrayList<SegmentedChainBucketSegment> segments;
    private boolean readOnly;
    public final long bucketSize;
    public final int segmentSize;
    private long size;
    private boolean freed;
    final BucketFactory bf;
    private transient DBJobRunner dbJobRunner;
    private transient SegmentedBucketChainBucketKillJob killMe;
    private transient boolean runningSegStore;
    private boolean clearing;

    public SegmentedBucketChainBucket(int blockSize, BucketFactory factory, DBJobRunner runner, int segmentSize2) {
        this.bucketSize = blockSize;
        this.bf = factory;
        this.dbJobRunner = runner;
        this.segmentSize = segmentSize2;
        this.segments = new ArrayList();
    }

    public Bucket createShadow() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            this.freed = true;
            this.clearing = false;
        }
        DBJob freeJob = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                SegmentedChainBucketSegment segment = null;
                if (!container.ext().isStored((Object)SegmentedBucketChainBucket.this)) {
                    Logger.error(this, "Bucket not stored in freeJob, already deleted???");
                    container.delete((Object)this);
                    return true;
                }
                Object object = this;
                synchronized (object) {
                    if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                        segment = (SegmentedChainBucketSegment)SegmentedBucketChainBucket.this.segments.remove(0);
                    }
                }
                if (segment != null) {
                    container.activate((Object)segment, 1);
                    if (Logger.shouldLog(4, SegmentedBucketChainBucket.this)) {
                        Logger.minor(SegmentedBucketChainBucket.this, "Freeing segment " + segment);
                    }
                    segment.activateBuckets(container);
                    segment.free();
                    segment.removeFrom(container);
                    object = this;
                    synchronized (object) {
                        if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                            try {
                                SegmentedBucketChainBucket.this.dbJobRunner.queue(this, 7, true);
                                SegmentedBucketChainBucket.this.dbJobRunner.queueRestartJob(this, 7, container, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            container.store((Object)this);
                            return true;
                        }
                    }
                }
                container.delete((Object)SegmentedBucketChainBucket.this.segments);
                container.delete((Object)SegmentedBucketChainBucket.this);
                container.delete((Object)this);
                object = SegmentedBucketChainBucket.this;
                synchronized (object) {
                    if (SegmentedBucketChainBucket.this.killMe == null) {
                        return true;
                    }
                }
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.removeRestartJob(SegmentedBucketChainBucket.this.killMe, 7, container);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                container.delete((Object)SegmentedBucketChainBucket.this.killMe);
                return true;
            }
        };
        try {
            this.dbJobRunner.runBlocking(freeJob, 7);
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Unable to free " + this + " because database is disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            if (this.freed || this.clearing) {
                throw new IOException("Freed");
            }
        }
        return new InputStream(){
            int segmentNo = -1;
            int bucketNo;
            SegmentedChainBucketSegment seg;
            Bucket[] buckets;
            InputStream is;
            private long bucketRead;
            private boolean closed;
            {
                this.bucketNo = SegmentedBucketChainBucket.this.segmentSize;
                this.seg = null;
                this.buckets = null;
                this.is = null;
                this.bucketRead = 0L;
            }

            public int read() throws IOException {
                byte[] b = new byte[1];
                if (this.read(b, 0, 1) <= 0) {
                    return -1;
                }
                return b[0];
            }

            public int read(byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buf, int offset, int length) throws IOException {
                int r;
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                if (this.bucketRead == SegmentedBucketChainBucket.this.bucketSize || this.is == null) {
                    if (this.is != null) {
                        this.is.close();
                    }
                    if (this.buckets != null) {
                        this.buckets[this.bucketNo] = null;
                    }
                    this.bucketRead = 0L;
                    ++this.bucketNo;
                    if (this.bucketNo == SegmentedBucketChainBucket.this.segmentSize || this.buckets == null) {
                        this.bucketNo = 0;
                        ++this.segmentNo;
                        this.seg = SegmentedBucketChainBucket.this.getSegment(this.segmentNo);
                        if (this.seg == null) {
                            return -1;
                        }
                        try {
                            this.buckets = SegmentedBucketChainBucket.this.getBuckets(this.seg);
                        }
                        catch (DatabaseDisabledException e) {
                            throw new IOException("Database disabled during read!");
                        }
                    }
                    if (this.bucketNo >= this.buckets.length) {
                        SegmentedBucketChainBucket e = SegmentedBucketChainBucket.this;
                        synchronized (e) {
                            if (this.segmentNo >= SegmentedBucketChainBucket.this.segments.size()) {
                                return -1;
                            }
                        }
                        try {
                            this.buckets = SegmentedBucketChainBucket.this.getBuckets(this.seg);
                        }
                        catch (DatabaseDisabledException e2) {
                            throw new IOException("Database disabled during read!");
                        }
                        if (this.bucketNo >= this.buckets.length) {
                            return -1;
                        }
                    }
                    this.is = this.buckets[this.bucketNo].getInputStream();
                }
                if ((r = this.is.read(buf, offset, length)) > 0) {
                    this.bucketRead += (long)r;
                }
                return r;
            }

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                if (this.is != null) {
                    this.is.close();
                }
                this.closed = true;
                this.is = null;
                this.seg = null;
                this.buckets = null;
            }
        };
    }

    protected synchronized SegmentedChainBucketSegment getSegment(int i) {
        return this.segments.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bucket[] getBuckets(final SegmentedChainBucketSegment seg) throws DatabaseDisabledException {
        final BucketArrayWrapper baw = new BucketArrayWrapper();
        this.dbJobRunner.runBlocking(new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                container.activate((Object)seg, 1);
                BucketArrayWrapper bucketArrayWrapper = baw;
                synchronized (bucketArrayWrapper) {
                    baw.buckets = seg.shallowCopyBuckets();
                }
                container.deactivate((Object)seg, 1);
                return false;
            }
        }, 7);
        BucketArrayWrapper bucketArrayWrapper = baw;
        synchronized (bucketArrayWrapper) {
            return baw.buckets;
        }
    }

    public String getName() {
        return "SegmentedBucketChainBucket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        SegmentedChainBucketSegment[] segs;
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            if (this.readOnly) {
                throw new IOException("Read-only");
            }
            if (this.freed || this.clearing) {
                throw new IOException("Freed");
            }
            this.size = 0L;
            segs = this.segments.toArray(new SegmentedChainBucketSegment[this.segments.size()]);
            this.segments.clear();
        }
        for (int i = 0; i < segs.length; ++i) {
            segs[i].free();
        }
        if (segs.length > 0) {
            try {
                this.dbJobRunner.runBlocking(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        for (int i = 0; i < segs.length; ++i) {
                            segs[i].removeFrom(container);
                        }
                        return true;
                    }
                }, 7);
            }
            catch (DatabaseDisabledException e) {
                throw new IOException("Database disabled");
            }
        }
        return new OutputStream(){
            int segmentNo = 0;
            int bucketNo = 0;
            SegmentedChainBucketSegment seg = SegmentedBucketChainBucket.this.makeSegment(this.segmentNo, null);
            OutputStream cur = this.seg.makeBucketStream(this.bucketNo);
            private long bucketLength;
            private boolean closed;

            public void write(int arg0) throws IOException {
                this.write(new byte[]{(byte)arg0});
            }

            public void write(byte[] buf) throws IOException {
                this.write(buf, 0, buf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void write(byte[] buf, int offset, int length) throws IOException {
                SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                // MONITORENTER : segmentedBucketChainBucket
                boolean ro = SegmentedBucketChainBucket.this.readOnly;
                // MONITOREXIT : segmentedBucketChainBucket
                if (ro) {
                    if (this.closed) throw new IOException("Read-only");
                    this.close();
                    throw new IOException("Read-only");
                }
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                while (length > 0) {
                    if (this.bucketLength == SegmentedBucketChainBucket.this.bucketSize) {
                        ++this.bucketNo;
                        this.cur.close();
                        if (this.bucketNo == SegmentedBucketChainBucket.this.segmentSize) {
                            this.bucketNo = 0;
                            ++this.segmentNo;
                            this.seg = SegmentedBucketChainBucket.this.makeSegment(this.segmentNo, this.seg);
                        }
                        this.cur = this.seg.makeBucketStream(this.bucketNo);
                        this.bucketLength = 0L;
                    }
                    int left = (int)Math.min(Integer.MAX_VALUE, SegmentedBucketChainBucket.this.bucketSize - this.bucketLength);
                    int write = Math.min(left, length);
                    this.cur.write(buf, offset, write);
                    offset += write;
                    length -= write;
                    this.bucketLength += (long)write;
                    Class<SegmentedBucketChainBucket> clazz = SegmentedBucketChainBucket.class;
                    // MONITORENTER : freenet.support.io.SegmentedBucketChainBucket.class
                    SegmentedBucketChainBucket.this.size += write;
                    // MONITOREXIT : clazz
                }
            }

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Closing " + this + " for " + SegmentedBucketChainBucket.this);
                }
                this.cur.close();
                this.closed = true;
                this.cur = null;
                final SegmentedChainBucketSegment oldSeg = this.seg;
                this.seg = null;
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.runBlocking(new DBJob(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean run(ObjectContainer container, ClientContext context) {
                            if (container.ext().isStored((Object)oldSeg) && !container.ext().isActive((Object)oldSeg)) {
                                Logger.error(this, "OLD SEGMENT STORED BUT NOT ACTIVE: " + oldSeg, new Exception("error"));
                                container.activate((Object)oldSeg, 1);
                            }
                            oldSeg.storeTo(container);
                            container.ext().store((Object)SegmentedBucketChainBucket.this.segments, 1);
                            container.ext().store((Object)SegmentedBucketChainBucket.this, 1);
                            container.deactivate((Object)oldSeg, 1);
                            SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                            synchronized (segmentedBucketChainBucket) {
                                if (SegmentedBucketChainBucket.this.killMe != null) {
                                    return true;
                                }
                                SegmentedBucketChainBucket.this.killMe = new SegmentedBucketChainBucketKillJob(SegmentedBucketChainBucket.this);
                            }
                            try {
                                SegmentedBucketChainBucket.this.killMe.scheduleRestart(container, context);
                            }
                            catch (DatabaseDisabledException databaseDisabledException) {
                                // empty catch block
                            }
                            return true;
                        }
                    }, 7);
                }
                catch (DatabaseDisabledException e) {
                    throw new IOException("Database disabled");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SegmentedChainBucketSegment makeSegment(int index, final SegmentedChainBucketSegment oldSeg) {
        SegmentedBucketChainBucket segmentedBucketChainBucket;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Make a segment for " + this + " index " + index + "old " + oldSeg);
        }
        if (oldSeg != null) {
            segmentedBucketChainBucket = this;
            synchronized (segmentedBucketChainBucket) {
                while (this.runningSegStore) {
                    Logger.normal(this, "Waiting for last segment-store job to finish on " + this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this.runningSegStore = true;
            }
            try {
                this.dbJobRunner.runBlocking(new DBJob(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean run(ObjectContainer container, ClientContext context) {
                        block15: {
                            SegmentedBucketChainBucket segmentedBucketChainBucket;
                            boolean bl;
                            block14: {
                                try {
                                    try {
                                        oldSeg.storeTo(container);
                                        container.ext().store((Object)SegmentedBucketChainBucket.this.segments, 1);
                                        container.ext().store((Object)SegmentedBucketChainBucket.this, 1);
                                        container.deactivate((Object)oldSeg, 1);
                                        SegmentedBucketChainBucket segmentedBucketChainBucket2 = SegmentedBucketChainBucket.this;
                                        synchronized (segmentedBucketChainBucket2) {
                                            if (SegmentedBucketChainBucket.this.killMe != null) {
                                                bl = true;
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 13] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                                                Object var7_6 = null;
                                                segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                                                break block14;
                                            }
                                            SegmentedBucketChainBucket.this.killMe = new SegmentedBucketChainBucketKillJob(SegmentedBucketChainBucket.this);
                                        }
                                        SegmentedBucketChainBucket.this.killMe.scheduleRestart(container, context);
                                        break block15;
                                    }
                                    catch (DatabaseDisabledException databaseDisabledException) {
                                        Object var7_8 = null;
                                        SegmentedBucketChainBucket segmentedBucketChainBucket3 = SegmentedBucketChainBucket.this;
                                        synchronized (segmentedBucketChainBucket3) {
                                            SegmentedBucketChainBucket.this.runningSegStore = false;
                                            SegmentedBucketChainBucket.this.notifyAll();
                                            return true;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var7_9 = null;
                                    SegmentedBucketChainBucket segmentedBucketChainBucket4 = SegmentedBucketChainBucket.this;
                                    synchronized (segmentedBucketChainBucket4) {
                                        SegmentedBucketChainBucket.this.runningSegStore = false;
                                        SegmentedBucketChainBucket.this.notifyAll();
                                        throw throwable;
                                    }
                                }
                            }
                            synchronized (segmentedBucketChainBucket) {
                                SegmentedBucketChainBucket.this.runningSegStore = false;
                                SegmentedBucketChainBucket.this.notifyAll();
                                return bl;
                            }
                        }
                        Object var7_7 = null;
                        SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                        synchronized (segmentedBucketChainBucket) {
                            SegmentedBucketChainBucket.this.runningSegStore = false;
                            SegmentedBucketChainBucket.this.notifyAll();
                            return true;
                        }
                    }
                }, 6);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught throwable: " + t, t);
                this.runningSegStore = false;
            }
        }
        segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            SegmentedChainBucketSegment seg = new SegmentedChainBucketSegment(this);
            if (this.segments.size() != index) {
                throw new IllegalArgumentException("Asked to add segment " + index + " but segments length is " + this.segments.size());
            }
            this.segments.add(seg);
            return seg;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void removeFrom(ObjectContainer container) {
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized long size() {
        return this.size;
    }

    public void storeTo(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    public Bucket[] getBuckets() {
        final BucketArrayWrapper baw = new BucketArrayWrapper();
        try {
            this.dbJobRunner.runBlocking(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    baw.buckets = SegmentedBucketChainBucket.this.getBuckets(container);
                    return false;
                }
            }, 7);
        }
        catch (DatabaseDisabledException e) {
            return null;
        }
        return baw.buckets;
    }

    protected synchronized Bucket[] getBuckets(ObjectContainer container) {
        int segs = this.segments.size();
        if (segs == 0) {
            return new Bucket[0];
        }
        SegmentedChainBucketSegment seg = this.segments.get(segs - 1);
        container.activate((Object)seg, 1);
        seg.activateBuckets(container);
        int size = (segs - 1) * this.segmentSize + seg.size();
        Bucket[] buckets = new Bucket[size];
        seg.shallowCopyBuckets(buckets, (segs - 1) * this.segmentSize);
        container.deactivate((Object)seg, 1);
        int pos = 0;
        for (int i = 0; i < segs - 1; ++i) {
            seg = this.segments.get(i);
            container.activate((Object)seg, 1);
            seg.activateBuckets(container);
            seg.shallowCopyBuckets(buckets, pos);
            container.deactivate((Object)seg, 1);
            pos += this.segmentSize;
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            this.clearing = true;
        }
        DBJob clearJob = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                if (!container.ext().isStored((Object)SegmentedBucketChainBucket.this)) {
                    Logger.error(this, "Bucket not stored in clearJob, already deleted???");
                    container.delete((Object)this);
                    return false;
                }
                SegmentedChainBucketSegment segment = null;
                Object object = this;
                synchronized (object) {
                    if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                        segment = (SegmentedChainBucketSegment)SegmentedBucketChainBucket.this.segments.remove(0);
                    }
                }
                if (segment != null) {
                    container.activate((Object)segment, 1);
                    if (Logger.shouldLog(4, SegmentedBucketChainBucket.this)) {
                        Logger.minor(SegmentedBucketChainBucket.this, "Clearing segment " + segment);
                    }
                    segment.clear(container);
                    object = this;
                    synchronized (object) {
                        if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                            try {
                                SegmentedBucketChainBucket.this.dbJobRunner.queue(this, 6, true);
                                SegmentedBucketChainBucket.this.dbJobRunner.queueRestartJob(this, 6, container, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            container.store((Object)SegmentedBucketChainBucket.this.segments);
                            container.store((Object)SegmentedBucketChainBucket.this);
                            return true;
                        }
                    }
                }
                container.delete((Object)SegmentedBucketChainBucket.this.segments);
                container.delete((Object)SegmentedBucketChainBucket.this);
                container.delete((Object)this);
                object = SegmentedBucketChainBucket.this;
                synchronized (object) {
                    if (SegmentedBucketChainBucket.this.killMe == null) {
                        return true;
                    }
                }
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.removeRestartJob(SegmentedBucketChainBucket.this.killMe, 7, container);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                container.delete((Object)SegmentedBucketChainBucket.this.killMe);
                return true;
            }
        };
        try {
            this.dbJobRunner.runBlocking(clearJob, 6);
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Unable to clear() on " + this + " because database is disabled");
        }
    }

    synchronized boolean removeContents(ObjectContainer container) {
        boolean logMINOR = Logger.shouldLog(4, this);
        while (this.segments.size() > 0) {
            Logger.normal(this, "Freeing unfinished unstored bucket " + this + " segments left " + this.segments.size());
            SegmentedChainBucketSegment seg = this.segments.remove(0);
            if (seg == null) continue;
            container.activate((Object)seg, 1);
            if (logMINOR) {
                Logger.minor(this, "Removing segment " + seg + " size " + seg.size());
            }
            if (this.clearing) {
                seg.clear(container);
            } else {
                seg.activateBuckets(container);
                seg.free();
                seg.removeFrom(container);
            }
            if (this.segments.size() <= 0) break;
            container.store(this.segments);
            container.store((Object)this);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Removed segments for " + this);
        }
        container.delete(this.segments);
        container.delete((Object)this);
        if (logMINOR) {
            Logger.minor(this, "Removed " + this);
        }
        this.freed = true;
        return false;
    }
}

