/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.SerializableToFieldSetBucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class ReadOnlyFileSliceBucket
implements Bucket,
SerializableToFieldSetBucket {
    private final File file;
    private final long startAt;
    private final long length;

    public ReadOnlyFileSliceBucket(File f, long startAt, long length) {
        this.file = new File(f.getPath());
        this.startAt = startAt;
        this.length = length;
    }

    public ReadOnlyFileSliceBucket(SimpleFieldSet fs) throws CannotCreateFromFieldSetException {
        String tmp = fs.get("Filename");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No filename");
        }
        this.file = new File(tmp);
        tmp = fs.get("Length");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No length");
        }
        try {
            this.length = Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt length " + tmp, e);
        }
        tmp = fs.get("Offset");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No offset");
        }
        try {
            this.startAt = Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt offset " + tmp, e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Bucket is read-only");
    }

    public InputStream getInputStream() throws IOException {
        return new MyInputStream();
    }

    public String getName() {
        return "ROFS:" + this.file.getAbsolutePath() + ':' + this.startAt + ':' + this.length;
    }

    public long size() {
        return this.length;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setReadOnly() {
    }

    public void free() {
    }

    public SimpleFieldSet toFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", "ReadOnlyFileSliceBucket");
        fs.putSingle("Filename", this.file.toString());
        fs.put("Offset", this.startAt);
        fs.put("Length", this.length);
        return fs;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.file);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.file, 5);
    }

    public Bucket createShadow() throws IOException {
        String fnam = new String(this.file.getPath());
        File newFile = new File(fnam);
        return new ReadOnlyFileSliceBucket(newFile, this.startAt, this.length);
    }

    public static class ReadOnlyFileSliceBucketException
    extends IOException {
        private static final long serialVersionUID = -1L;

        public ReadOnlyFileSliceBucketException(FileNotFoundException e) {
            super("File not found: " + e.getMessage());
            this.initCause(e);
        }

        public ReadOnlyFileSliceBucketException(String string) {
            super(string);
        }
    }

    private class MyInputStream
    extends InputStream {
        private RandomAccessFile f;
        private long ptr;

        MyInputStream() throws IOException {
            try {
                this.f = new RandomAccessFile(ReadOnlyFileSliceBucket.this.file, "r");
                this.f.seek(ReadOnlyFileSliceBucket.this.startAt);
                if (this.f.length() < ReadOnlyFileSliceBucket.this.startAt + ReadOnlyFileSliceBucket.this.length) {
                    throw new ReadOnlyFileSliceBucketException("File truncated? Length " + this.f.length() + " but start at " + ReadOnlyFileSliceBucket.this.startAt + " for " + ReadOnlyFileSliceBucket.this.length + " bytes");
                }
                this.ptr = 0L;
            }
            catch (FileNotFoundException e) {
                throw new ReadOnlyFileSliceBucketException(e);
            }
        }

        public int read() throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            int x = this.f.read();
            if (x != -1) {
                ++this.ptr;
            }
            return x;
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            len = (int)Math.min((long)len, ReadOnlyFileSliceBucket.this.length - this.ptr);
            int x = this.f.read(buf, offset, len);
            this.ptr += (long)x;
            return x;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public void close() throws IOException {
            this.f.close();
        }
    }
}

