/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Logger;
import freenet.support.io.RandomAccessThing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileWrapper
implements RandomAccessThing {
    final RandomAccessFile raf;

    public RandomAccessFileWrapper(RandomAccessFile raf) {
        this.raf = raf;
    }

    public RandomAccessFileWrapper(File filename, String mode) throws FileNotFoundException {
        this.raf = new RandomAccessFile(filename, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        RandomAccessFileWrapper randomAccessFileWrapper = this;
        synchronized (randomAccessFileWrapper) {
            this.raf.seek(fileOffset);
            this.raf.readFully(buf, bufOffset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        RandomAccessFileWrapper randomAccessFileWrapper = this;
        synchronized (randomAccessFileWrapper) {
            this.raf.seek(fileOffset);
            this.raf.write(buf, bufOffset, length);
        }
    }

    public long size() throws IOException {
        return this.raf.length();
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            Logger.error(this, "Could not close " + this.raf + " : " + e + " for " + this, e);
        }
    }
}

