/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.TempFileBucket;
import java.io.File;
import java.io.IOException;

public class PersistentTempFileBucket
extends TempFileBucket {
    public PersistentTempFileBucket(long id, FilenameGenerator generator) {
        this(id, generator, true);
    }

    protected PersistentTempFileBucket(long id, FilenameGenerator generator, boolean deleteOnFree) {
        super(id, generator, false, deleteOnFree);
    }

    protected boolean deleteOnFinalize() {
        return false;
    }

    protected boolean deleteOnExit() {
        return false;
    }

    public static Bucket create(SimpleFieldSet fs, PersistentFileTracker f) throws CannotCreateFromFieldSetException {
        String tmp = fs.get("Filename");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No filename");
        }
        File file = FileUtil.getCanonicalFile(new File(tmp));
        long id = f.getID(file);
        if (id == -1L) {
            throw new CannotCreateFromFieldSetException("Cannot derive persistent temp file id from filename " + file);
        }
        tmp = fs.get("Length");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No length");
        }
        try {
            long length = Long.parseLong(tmp);
            if (length != file.length()) {
                throw new CannotCreateFromFieldSetException("Invalid length: should be " + length + " actually " + file.length() + " on " + file);
            }
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt length " + tmp, e);
        }
        PersistentTempFileBucket bucket = new PersistentTempFileBucket(id, f.getGenerator(), true);
        if (file.exists()) {
            f.register(file);
        }
        return bucket;
    }

    public SimpleFieldSet toFieldSet() {
        if (this.deleteOnFinalize()) {
            return null;
        }
        SimpleFieldSet fs = super.toFieldSet();
        fs.putOverwrite("Type", "PersistentTempFileBucket");
        fs.put("FilenameID", this.filenameID);
        return fs;
    }

    public Bucket createShadow() throws IOException {
        PersistentTempFileBucket ret = new PersistentTempFileBucket(this.filenameID, this.generator, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }
}

