/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Ticker;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.FileUtil;
import freenet.support.io.PersistentBlobTempBucket;
import freenet.support.io.PersistentBlobTempBucketTag;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class PersistentBlobTempBucketFactory {
    private static volatile boolean logMINOR;
    public final long blockSize;
    private File storageFile;
    private transient RandomAccessFile raf;
    private transient HashSet<DBJob> freeJobs;
    transient FileChannel channel;
    private transient TreeMap<Long, PersistentBlobTempBucket> notCommittedBlobs;
    private transient TreeMap<Long, PersistentBlobTempBucketTag> freeSlots;
    private transient TreeMap<Long, PersistentBlobTempBucketTag> almostFreeSlots;
    private transient TreeMap<Long, PersistentBlobTempBucket> shadows;
    private transient DBJobRunner jobRunner;
    private transient Random weakRandomSource;
    private transient Ticker ticker;
    private final long nodeDBHandle;
    static final int MAX_FREE = 2048;
    private transient DBJob slotFinder;
    private long lastCheckedEnd = -1L;

    public PersistentBlobTempBucketFactory(long blockSize2, long nodeDBHandle2, File storageFile2) {
        this.blockSize = blockSize2;
        this.nodeDBHandle = nodeDBHandle2;
        this.storageFile = storageFile2;
    }

    void onInit(ObjectContainer container, DBJobRunner jobRunner2, Random fastWeakRandom, File storageFile2, long blockSize2, Ticker ticker) throws IOException {
        container.activate((Object)this.storageFile, 100);
        this.initSlotFinder();
        File oldFile = FileUtil.getCanonicalFile(new File(this.storageFile.getPath()));
        File newFile = FileUtil.getCanonicalFile(new File(storageFile2.getPath()));
        if (this.blockSize != blockSize2) {
            throw new IllegalStateException("My block size is " + blockSize2 + " but stored block size is " + this.blockSize + " for same file " + this.storageFile);
        }
        if (!oldFile.equals(newFile) && !(File.separatorChar != '\\' ? oldFile.getPath().equals(newFile.getPath()) : oldFile.getPath().toLowerCase().equals(newFile.getPath().toLowerCase()))) {
            if (this.storageFile.exists() && !FileUtil.moveTo(this.storageFile, storageFile2, false)) {
                throw new IOException("Unable to move temp blob file from " + this.storageFile + " to " + storageFile2);
            }
            this.storageFile = storageFile2;
            container.store((Object)this);
        }
        this.raf = new RandomAccessFile(this.storageFile, "rw");
        this.channel = this.raf.getChannel();
        this.notCommittedBlobs = new TreeMap();
        this.freeSlots = new TreeMap();
        this.almostFreeSlots = new TreeMap();
        this.shadows = new TreeMap();
        this.jobRunner = jobRunner2;
        this.weakRandomSource = fastWeakRandom;
        this.freeJobs = new HashSet();
        this.ticker = ticker;
        this.maybeShrink(container);
        if (logMINOR) {
            this.initRangeDump(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRangeDump(ObjectContainer container) {
        long size;
        try {
            size = this.channel.size();
        }
        catch (IOException e1) {
            Logger.error(this, "Unable to find size of temp blob storage file: " + e1, e1);
            return;
        }
        size -= size % this.blockSize;
        long blocks = size / this.blockSize;
        long ptr = blocks - 1L;
        long used = 0L;
        long rangeStart = Long.MIN_VALUE;
        PersistentBlobTempBucketTag firstInRange = null;
        for (long l = 0L; l < ptr; ++l) {
            PersistentBlobTempBucketTag tag;
            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
            synchronized (persistentBlobTempBucketFactory) {
                if (this.freeSlots.containsKey(l)) {
                    continue;
                }
                if (this.notCommittedBlobs.containsKey(l)) {
                    continue;
                }
                if (this.almostFreeSlots.containsKey(l)) {
                    continue;
                }
            }
            Query query = container.query();
            query.constrain(PersistentBlobTempBucketTag.class);
            query.descend("index").constrain((Object)l);
            ObjectSet tags = query.execute();
            if (tags.hasNext()) {
                tag = (PersistentBlobTempBucketTag)tags.next();
                if (!tag.isFree) {
                    ++used;
                }
                if (tag.bucket == null && !tag.isFree) {
                    Logger.error(this, "No bucket but flagged as not free: index " + l + " " + tag.bucket);
                }
                if (tag.bucket != null && tag.isFree) {
                    Logger.error(this, "Has bucket but flagged as free: index " + l + " " + tag.bucket);
                }
                if (!tag.isFree) {
                    if (rangeStart != Long.MIN_VALUE) continue;
                    rangeStart = l;
                    firstInRange = tag;
                    continue;
                }
                if (rangeStart == Long.MIN_VALUE) continue;
                System.out.println("Range: " + rangeStart + " to " + (l - 1L) + " first is " + firstInRange);
                rangeStart = Long.MIN_VALUE;
                firstInRange = null;
                continue;
            }
            Logger.error(this, "FOUND EMPTY SLOT: " + l + " when scanning the blob file because tags in database < length of file");
            tag = new PersistentBlobTempBucketTag(this, l);
            container.store((Object)tag);
        }
        if (rangeStart != Long.MIN_VALUE) {
            System.out.println("Range: " + rangeStart + " to " + (ptr - 1L));
        }
        System.err.println("Persistent blobs: Blocks: " + blocks + " used " + used);
    }

    public String getName() {
        return this.storageFile.getPath();
    }

    private void initSlotFinder() {
        this.slotFinder = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                Query query;
                boolean changedTags;
                long ptr;
                long blocks;
                long size;
                int added = 0;
                while (true) {
                    Object tag;
                    Object object;
                    PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = PersistentBlobTempBucketFactory.this;
                    synchronized (persistentBlobTempBucketFactory) {
                        if (PersistentBlobTempBucketFactory.this.freeSlots.size() > 2048) {
                            return false;
                        }
                    }
                    try {
                        size = PersistentBlobTempBucketFactory.this.channel.size();
                    }
                    catch (IOException e1) {
                        Logger.error(this, "Unable to find size of temp blob storage file: " + e1, e1);
                        return false;
                    }
                    size -= size % PersistentBlobTempBucketFactory.this.blockSize;
                    blocks = size / PersistentBlobTempBucketFactory.this.blockSize;
                    ptr = blocks - 1L;
                    changedTags = false;
                    for (long l = 0L; l < PersistentBlobTempBucketFactory.this.blockSize + 16383L; l += 16384L) {
                        Query query2 = container.query();
                        query2.constrain(PersistentBlobTempBucketTag.class);
                        query2.descend("isFree").constrain((Object)true).and(query2.descend("index").constrain((Object)l).smaller());
                        ObjectSet tags = query2.execute();
                        object = PersistentBlobTempBucketFactory.this;
                        synchronized (object) {
                            while (tags.hasNext()) {
                                tag = (PersistentBlobTempBucketTag)tags.next();
                                if (!((PersistentBlobTempBucketTag)tag).isFree) {
                                    Logger.error(this, "Tag not free! " + ((PersistentBlobTempBucketTag)tag).index);
                                    if (((PersistentBlobTempBucketTag)tag).bucket != null) continue;
                                    Logger.error(this, "Tag flagged non-free yet has no bucket for index " + ((PersistentBlobTempBucketTag)tag).index);
                                    ((PersistentBlobTempBucketTag)tag).isFree = true;
                                    container.store(tag);
                                    changedTags = true;
                                }
                                if (((PersistentBlobTempBucketTag)tag).bucket != null) {
                                    Logger.error(this, "Query returned tag with valid bucket!");
                                    continue;
                                }
                                if (((PersistentBlobTempBucketTag)tag).factory != PersistentBlobTempBucketFactory.this || PersistentBlobTempBucketFactory.this.notCommittedBlobs.containsKey(((PersistentBlobTempBucketTag)tag).index) || PersistentBlobTempBucketFactory.this.almostFreeSlots.containsKey(((PersistentBlobTempBucketTag)tag).index) || PersistentBlobTempBucketFactory.this.freeSlots.containsKey(((PersistentBlobTempBucketTag)tag).index)) continue;
                                if (((PersistentBlobTempBucketTag)tag).bucket != null) {
                                    Logger.error(this, "Bucket is occupied but not in notCommittedBlobs?!: " + tag + " : " + ((PersistentBlobTempBucketTag)tag).bucket);
                                    continue;
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Adding slot " + ((PersistentBlobTempBucketTag)tag).index + " to freeSlots (has a free tag and no taken tag)");
                                }
                                PersistentBlobTempBucketFactory.this.freeSlots.put(((PersistentBlobTempBucketTag)tag).index, tag);
                                if (++added <= 2048) continue;
                                return changedTags;
                            }
                            continue;
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Checking number of tags against file size...");
                    }
                    query = container.query();
                    query.constrain(PersistentBlobTempBucketTag.class);
                    ObjectSet tags = query.execute();
                    long inDB = tags.size();
                    if (logMINOR) {
                        Logger.minor(this, "Checked size.");
                    }
                    tags = null;
                    if (inDB < ptr) {
                        Logger.error(this, "Tags in database: " + inDB + " but size of file allows: " + ptr);
                        for (long l = 0L; l < ptr; ++l) {
                            tag = this;
                            synchronized (tag) {
                                if (PersistentBlobTempBucketFactory.this.freeSlots.containsKey(l)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.notCommittedBlobs.containsKey(l)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.almostFreeSlots.containsKey(l)) {
                                    continue;
                                }
                            }
                            query = container.query();
                            query.constrain(PersistentBlobTempBucketTag.class);
                            query.descend("index").constrain((Object)l);
                            tags = query.execute();
                            if (tags.hasNext()) continue;
                            Logger.error(this, "FOUND EMPTY SLOT: " + l + " when scanning the blob file because tags in database < length of file");
                            tag = new PersistentBlobTempBucketTag(PersistentBlobTempBucketFactory.this, l);
                            container.store(tag);
                            2 var18_21 = this;
                            synchronized (var18_21) {
                                PersistentBlobTempBucketFactory.this.freeSlots.put(ptr, tag);
                            }
                            changedTags = true;
                            if (++added <= 2048) continue;
                            return true;
                        }
                    }
                    DBJob freeJob = null;
                    object = this;
                    synchronized (object) {
                        if (!PersistentBlobTempBucketFactory.this.freeJobs.isEmpty()) {
                            freeJob = (DBJob)PersistentBlobTempBucketFactory.this.freeJobs.iterator().next();
                            PersistentBlobTempBucketFactory.this.freeJobs.remove(freeJob);
                        }
                    }
                    if (freeJob == null) break;
                    container.activate((Object)freeJob, 1);
                    System.err.println("Freeing some space by running " + freeJob);
                    if (logMINOR) {
                        Logger.minor(this, "Freeing some space by running " + freeJob);
                    }
                    freeJob.run(container, context);
                }
                long addBlocks = Math.min(8192L, blocks / 10L + 32L);
                long extendBy = addBlocks * PersistentBlobTempBucketFactory.this.blockSize;
                byte[] buf = new byte[4096];
                ByteBuffer buffer = ByteBuffer.wrap(buf);
                for (long written = 0L; written < extendBy; written += (long)PersistentBlobTempBucketFactory.this.channel.write(buffer, size + written)) {
                    PersistentBlobTempBucketFactory.this.weakRandomSource.nextBytes(buf);
                    int bytesLeft = (int)Math.min(extendBy - written, Integer.MAX_VALUE);
                    if (bytesLeft < buf.length) {
                        buffer.limit(bytesLeft);
                    }
                    try {
                        buffer.clear();
                        continue;
                    }
                    catch (IOException e) {
                        break;
                    }
                }
                query = container.query();
                query.constrain(PersistentBlobTempBucketTag.class);
                query.descend("index").constrain((Object)(blocks - 1L)).greater().and(query.descend("factory").constrain((Object)PersistentBlobTempBucketFactory.this));
                HashSet<Long> taken = null;
                ObjectSet results = query.execute();
                while (results.hasNext()) {
                    PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)results.next();
                    if (!tag.isFree) {
                        Logger.error(this, "Block already exists beyond the end of the file, yet is occupied: block " + tag.index);
                    }
                    if (taken == null) {
                        taken = new HashSet<Long>();
                    }
                    taken.add(tag.index);
                }
                int i = 0;
                while ((long)i < addBlocks) {
                    ptr = blocks + (long)i;
                    if (taken == null || !taken.contains(ptr)) {
                        PersistentBlobTempBucketTag tag = new PersistentBlobTempBucketTag(PersistentBlobTempBucketFactory.this, ptr);
                        container.store((Object)tag);
                        changedTags = true;
                        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = PersistentBlobTempBucketFactory.this;
                        synchronized (persistentBlobTempBucketFactory) {
                            if (logMINOR) {
                                Logger.minor(this, "Adding slot " + ptr + " to freeSlots while extending storage file");
                            }
                            PersistentBlobTempBucketFactory.this.freeSlots.put(ptr, tag);
                        }
                    }
                    ++i;
                }
                return changedTags;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentBlobTempBucket makeBucket() throws DatabaseDisabledException {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (!this.freeSlots.isEmpty()) {
                Long slot = this.freeSlots.firstKey();
                if (logMINOR) {
                    try {
                        if (slot * this.blockSize > this.channel.size()) {
                            Logger.error(this, "Free slot " + slot + " but file length is " + this.channel.size() + " = " + this.channel.size() / this.blockSize + " blocks");
                            return null;
                        }
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                PersistentBlobTempBucketTag tag = this.freeSlots.remove(slot);
                if (this.notCommittedBlobs.get(slot) != null || this.almostFreeSlots.get(slot) != null) {
                    Logger.error(this, "Slot " + slot + " already occupied by a not committed blob despite being in freeSlots!!");
                    return null;
                }
                PersistentBlobTempBucket bucket = new PersistentBlobTempBucket(this, this.blockSize, slot, tag, false);
                this.notCommittedBlobs.put(slot, bucket);
                if (logMINOR) {
                    Logger.minor(this, "Using slot " + slot + " for " + bucket);
                }
                return bucket;
            }
        }
        this.jobRunner.runBlocking(this.slotFinder, 7);
        persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (!this.freeSlots.isEmpty()) {
                Long slot = this.freeSlots.firstKey();
                if (logMINOR) {
                    try {
                        if (slot * this.blockSize > this.channel.size()) {
                            Logger.error(this, "Free slot " + slot + " but file length is " + this.channel.size() + " = " + this.channel.size() / this.blockSize + " blocks");
                            return null;
                        }
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                PersistentBlobTempBucketTag tag = this.freeSlots.remove(slot);
                if (this.notCommittedBlobs.get(slot) != null || this.almostFreeSlots.get(slot) != null) {
                    Logger.error(this, "Slot " + slot + " already occupied by a not committed blob despite being in freeSlots!!");
                    return null;
                }
                PersistentBlobTempBucket bucket = new PersistentBlobTempBucket(this, this.blockSize, slot, tag, false);
                this.notCommittedBlobs.put(slot, bucket);
                if (logMINOR) {
                    Logger.minor(this, "Using slot " + slot + " for " + bucket + " (after waiting)");
                }
                return bucket;
            }
        }
        Logger.error(this, "Returning null, unable to create a bucket for some reason, node will fallback to file-based buckets");
        return null;
    }

    public synchronized void freeBucket(long index, PersistentBlobTempBucket bucket) {
        PersistentBlobTempBucket shadow;
        if (logMINOR) {
            Logger.minor(this, "Freeing index " + index + " for " + bucket, (Throwable)new Exception("debug"));
        }
        this.notCommittedBlobs.remove(index);
        bucket.onFree();
        if (!bucket.persisted()) {
            this.freeSlots.put(index, bucket.getTag());
        }
        if ((shadow = this.shadows.get(index)) != null) {
            shadow.freed();
        }
    }

    public synchronized void remove(PersistentBlobTempBucket bucket, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing bucket " + bucket + " for slot " + bucket.getIndex() + " from database", (Throwable)new Exception("debug"));
        }
        long index = bucket.getIndex();
        PersistentBlobTempBucketTag tag = bucket.getTag();
        if (tag == null) {
            if (!container.ext().isActive((Object)bucket)) {
                Logger.error(this, "BUCKET NOT ACTIVE IN REMOVE: " + bucket, new Exception("error"));
                container.activate((Object)bucket, 1);
                tag = bucket.getTag();
                index = bucket.getIndex();
            } else {
                Logger.error(this, "NO TAG ON BUCKET REMOVING: " + bucket + " index " + index, new Exception("error"));
                Query query = container.query();
                query.constrain(PersistentBlobTempBucketTag.class);
                query.descend("index").constrain((Object)index);
                ObjectSet results = query.execute();
                if (!results.hasNext()) {
                    Logger.error(this, "TAG DOES NOT EXIST FOR INDEX " + index);
                } else {
                    tag = (PersistentBlobTempBucketTag)results.next();
                    if (tag.index != index) {
                        Logger.error(this, "INVALID INDEX: should be " + index + " but is " + tag.index);
                    }
                    if (tag.isFree) {
                        Logger.error(this, "FOUND TAG BUT IS FREE: " + tag);
                    }
                    if (tag.bucket == null) {
                        Logger.error(this, "FOUND TAG BUT NO BUCKET: " + tag);
                    } else if (tag.bucket == bucket) {
                        Logger.error(this, "TAG LINKS TO BUCKET BUT BUCKET DOESN'T LINK TO TAG");
                    } else {
                        Logger.error(this, "SERIOUS ERROR: TAG BELONGS TO A DIFFERENT BUCKET!!!");
                    }
                }
            }
        }
        container.activate((Object)tag, 1);
        if (!bucket.persisted()) {
            this.maybeShrink(container);
            return;
        }
        if (!bucket.freed()) {
            Logger.error(this, "Removing bucket " + bucket + " for slot " + index + " but not freed!", new Exception("debug"));
            this.notCommittedBlobs.put(index, bucket);
        } else {
            this.almostFreeSlots.put(index, tag);
        }
        tag.bucket = null;
        tag.isFree = true;
        container.store((Object)tag);
        container.delete((Object)bucket);
        bucket.onRemove();
        this.maybeShrink(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeShrink(ObjectContainer container) {
        long newBlocks;
        if (logMINOR) {
            Logger.minor(this, "maybeShrink()");
        }
        long now = System.currentTimeMillis();
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (now - this.lastCheckedEnd > 60000L) {
                double full;
                long lastAlmostFreed;
                long size;
                if (logMINOR) {
                    Logger.minor(this, "maybeShrink() inner");
                }
                try {
                    size = this.channel.size();
                }
                catch (IOException e1) {
                    Logger.error(this, "Unable to find size of temp blob storage file: " + e1, e1);
                    return false;
                }
                size -= size % this.blockSize;
                long blocks = size / this.blockSize;
                if (blocks <= 32L) {
                    if (logMINOR) {
                        Logger.minor(this, "Not shrinking, blob file not larger than a megabyte");
                    }
                    this.lastCheckedEnd = now;
                    this.queueMaybeShrink();
                    return false;
                }
                long lastNotCommitted = this.notCommittedBlobs.isEmpty() ? 0L : this.notCommittedBlobs.lastKey();
                long l = lastAlmostFreed = this.almostFreeSlots.isEmpty() ? 0L : this.almostFreeSlots.lastKey();
                if (lastNotCommitted < lastAlmostFreed) {
                    if (logMINOR) {
                        Logger.minor(this, "Last almost freed: " + lastAlmostFreed + " replacing last not committed: " + lastNotCommitted);
                    }
                    lastNotCommitted = lastAlmostFreed;
                }
                if ((full = (double)lastNotCommitted / (double)blocks) > 0.8) {
                    if (logMINOR) {
                        Logger.minor(this, "Not shrinking, last not committed block is at " + full * 100.0 + "% (" + lastNotCommitted + " of " + blocks + ")");
                    }
                    this.lastCheckedEnd = now;
                    this.queueMaybeShrink();
                    return false;
                }
                long lastCommitted = -1L;
                PersistentBlobTempBucketTag lastTag = null;
                PersistentBlobTempBucket lastBucket = null;
                ObjectSet tags = null;
                Query query = null;
                for (long threshold = blocks - 4096L; threshold >= -4095L; threshold -= 4096L) {
                    query = container.query();
                    query.constrain(PersistentBlobTempBucketTag.class);
                    query.descend("isFree").constrain((Object)false);
                    query.descend("index").orderDescending();
                    query.descend("index").constrain((Object)threshold).greater();
                    tags = query.execute();
                    lastTag = null;
                    while (tags.hasNext()) {
                        lastTag = (PersistentBlobTempBucketTag)tags.next();
                        if (lastTag.bucket != null) break;
                        Logger.error(this, "Last tag has no bucket! index " + lastTag.index);
                        lastTag.isFree = true;
                        container.store((Object)lastTag);
                    }
                    if (lastTag == null) continue;
                    lastBucket = lastTag.bucket;
                    lastCommitted = lastTag.index;
                    Logger.normal(this, "Last committed block is " + lastCommitted);
                    break;
                }
                if (lastCommitted == -1L) {
                    Logger.normal(this, "No used slots in persistent temp file (but last not committed = " + lastNotCommitted + ")");
                    lastCommitted = 0L;
                    query = null;
                }
                if ((full = (double)lastCommitted / (double)blocks) > 0.8) {
                    if (logMINOR) {
                        Logger.minor(this, "Not shrinking, last committed block is at " + full * 100.0 + "%");
                    }
                    this.lastCheckedEnd = now;
                    this.queueMaybeShrink();
                    int blocksMoved = 0;
                    while (true) {
                        boolean deactivateLastBucket;
                        boolean bl = deactivateLastBucket = !container.ext().isActive(lastBucket);
                        if (deactivateLastBucket) {
                            container.activate(lastBucket, 1);
                        }
                        if (this.freeSlots.isEmpty()) {
                            try {
                                this.jobRunner.queue(this.slotFinder, 3, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            this.queueMaybeShrink();
                            return false;
                        }
                        Long lFirstSlot = this.freeSlots.firstKey();
                        long firstSlot = lFirstSlot;
                        if (firstSlot >= lastCommitted) break;
                        ++blocksMoved;
                        PersistentBlobTempBucketTag newTag = this.freeSlots.remove(lFirstSlot);
                        PersistentBlobTempBucket shadow = null;
                        if (this.shadows.containsKey(lastCommitted)) {
                            shadow = this.shadows.get(lastCommitted);
                            this.shadows.remove(lastCommitted);
                            this.shadows.put(newTag.index, shadow);
                        }
                        PersistentBlobTempBucket persistentBlobTempBucket = lastBucket;
                        synchronized (persistentBlobTempBucket) {
                            if (shadow != null) {
                                PersistentBlobTempBucket persistentBlobTempBucket2 = shadow;
                                synchronized (persistentBlobTempBucket2) {
                                    if (!this.innerDefrag(lastBucket, shadow, lastTag, newTag, container)) {
                                        return false;
                                    }
                                }
                            } else if (!this.innerDefrag(lastBucket, shadow, lastTag, newTag, container)) {
                                return false;
                            }
                        }
                        if (deactivateLastBucket) {
                            container.deactivate((Object)lastBucket, 1);
                        }
                        if (blocksMoved >= 10) break;
                        lastTag = null;
                        while (tags.hasNext()) {
                            lastTag = (PersistentBlobTempBucketTag)tags.next();
                            if (lastTag.bucket != null) break;
                            Logger.error(this, "Last tag has no bucket! index " + lastTag.index);
                            lastTag.isFree = true;
                            container.store((Object)lastTag);
                        }
                        if (lastTag == null) break;
                        lastBucket = lastTag.bucket;
                        lastCommitted = lastTag.index;
                        Logger.normal(this, "Last committed block is now " + lastCommitted);
                    }
                    if (blocksMoved > 0) {
                        try {
                            this.raf.getFD().sync();
                            System.err.println("Moved " + blocksMoved + " in defrag and synced to disk");
                        }
                        catch (SyncFailedException e) {
                            System.err.println("Failed to sync to disk after defragging: " + e);
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            System.err.println("Failed to sync to disk after defragging: " + e);
                            e.printStackTrace();
                        }
                        this.jobRunner.setCommitThisTransaction();
                    }
                    query = null;
                }
                long lastBlock = Math.max(lastCommitted, lastNotCommitted);
                newBlocks = (long)((double)(lastBlock + 32L) * 1.1);
                if ((newBlocks = Math.max(newBlocks, 32L)) >= blocks) {
                    if (logMINOR) {
                        Logger.minor(this, "Not shrinking, would shrink from " + blocks + " to " + newBlocks);
                    }
                    this.lastCheckedEnd = now;
                    this.queueMaybeShrink();
                    return false;
                }
                System.err.println("Shrinking blob file from " + blocks + " to " + newBlocks);
                for (long l2 = newBlocks; l2 <= blocks; ++l2) {
                    this.freeSlots.remove(l2);
                }
                for (Long l3 : this.freeSlots.keySet()) {
                    if (l3 <= newBlocks) continue;
                    Logger.error(this, "Removing free slot " + l3 + " over the current block limit");
                }
            } else {
                return false;
            }
            this.lastCheckedEnd = now;
            this.queueMaybeShrink();
        }
        try {
            this.channel.truncate(newBlocks * this.blockSize);
        }
        catch (IOException e) {
            System.err.println("Shrinking blob file failed!");
            System.err.println(e);
            e.printStackTrace();
            Logger.error(this, "Shrinking blob file failed!: " + e, e);
        }
        Query query = container.query();
        query.constrain(PersistentBlobTempBucketTag.class);
        query.descend("index").constrain((Object)newBlocks).greater();
        ObjectSet tags = query.execute();
        while (tags.hasNext()) {
            container.delete(tags.next());
        }
        this.queueMaybeShrink();
        return true;
    }

    private boolean innerDefrag(PersistentBlobTempBucket lastBucket, PersistentBlobTempBucket shadow, PersistentBlobTempBucketTag lastTag, PersistentBlobTempBucketTag newTag, ObjectContainer container) {
        System.err.println("Attempting to defragment: moving " + lastTag.index + " to " + newTag.index);
        try {
            byte[] blob = this.readSlot(lastTag.index);
            this.writeSlot(newTag.index, blob);
        }
        catch (IOException e) {
            System.err.println("Failed to move bucket in defrag: " + e);
            e.printStackTrace();
            Logger.error(this, "Failed to move bucket in defrag: " + e, e);
            this.queueMaybeShrink();
            return false;
        }
        lastBucket.setIndex(newTag.index);
        lastBucket.setTag(newTag);
        newTag.bucket = lastBucket;
        newTag.isFree = false;
        lastTag.bucket = null;
        lastTag.isFree = true;
        if (shadow != null) {
            shadow.setIndex(newTag.index);
        }
        container.store((Object)newTag);
        container.store((Object)lastTag);
        container.store((Object)lastBucket);
        return true;
    }

    private void queueMaybeShrink() {
        this.ticker.queueTimedJob(new Runnable(){

            public void run() {
                try {
                    PersistentBlobTempBucketFactory.this.jobRunner.queue(new DBJob(){

                        public boolean run(ObjectContainer container, ClientContext context) {
                            return PersistentBlobTempBucketFactory.this.maybeShrink(container);
                        }
                    }, 4, true);
                }
                catch (DatabaseDisabledException databaseDisabledException) {
                    // empty catch block
                }
            }
        }, 61000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(PersistentBlobTempBucket bucket, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Storing bucket " + bucket + " for slot " + bucket.getIndex() + " to database");
        }
        long index = bucket.getIndex();
        PersistentBlobTempBucketTag tag = bucket.getTag();
        container.activate((Object)tag, 1);
        if (tag.bucket != null && tag.bucket != bucket) {
            Logger.error(this, "Slot " + index + " already occupied!: " + tag.bucket + " for " + tag.index);
            throw new IllegalStateException("Slot " + index + " already occupied!");
        }
        tag.bucket = bucket;
        tag.isFree = false;
        container.store((Object)tag);
        container.store((Object)bucket);
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.notCommittedBlobs.remove(index);
        }
    }

    public synchronized void postCommit() {
        int freeNow = this.freeSlots.size();
        int sz = freeNow + this.almostFreeSlots.size();
        if (sz > 2048) {
            Iterator<Map.Entry<Long, PersistentBlobTempBucketTag>> it = this.almostFreeSlots.entrySet().iterator();
            for (int i = freeNow; i < 2048 && it.hasNext(); ++i) {
                Map.Entry<Long, PersistentBlobTempBucketTag> entry = it.next();
                this.freeSlots.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.freeSlots.putAll(this.almostFreeSlots);
        }
        this.almostFreeSlots.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket createShadow(PersistentBlobTempBucket bucket) {
        long index = bucket.getIndex();
        Long i = index;
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (this.shadows.containsKey(i)) {
                return null;
            }
            PersistentBlobTempBucket shadow = new PersistentBlobTempBucket(this, this.blockSize, index, null, true);
            shadow.size = bucket.size;
            this.shadows.put(i, shadow);
            return shadow;
        }
    }

    public synchronized void freeShadow(long index, PersistentBlobTempBucket bucket) {
        PersistentBlobTempBucket temp = this.shadows.remove(index);
        if (temp != bucket) {
            Logger.error(this, "Freed wrong shadow: " + temp + " should be " + bucket);
            this.shadows.put(index, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlobFreeCallback(DBJob job) {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.freeJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlobFreeCallback(DBJob job) {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.freeJobs.remove(job);
        }
    }

    private byte[] readSlot(long index) throws IOException {
        if (this.blockSize > Integer.MAX_VALUE) {
            throw new IOException("Block size over Integer.MAX_VALUE, unable to defragment!");
        }
        byte[] data = new byte[(int)this.blockSize];
        ByteBuffer buf = ByteBuffer.wrap(data);
        int offset = 0;
        while ((long)offset < this.blockSize) {
            int read = this.channel.read(buf, this.blockSize * index + (long)offset);
            if (read < 0) {
                throw new EOFException();
            }
            if (read <= 0) continue;
            offset += read;
        }
        return data;
    }

    private void writeSlot(long index, byte[] blob) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(blob);
        int written = 0;
        while ((long)written < this.blockSize) {
            int w = this.channel.write(buf, this.blockSize * index + (long)written);
            written += w;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

