/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.PersistentBlobTempBucketFactory;
import freenet.support.io.PersistentBlobTempBucketTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class PersistentBlobTempBucket
implements Bucket {
    public final long blockSize;
    long size;
    public final PersistentBlobTempBucketFactory factory;
    private volatile long index;
    private boolean freed;
    private boolean readOnly;
    private boolean persisted;
    private final int hashCode;
    private PersistentBlobTempBucketTag tag;
    private boolean shadow;
    private int inputStreams;

    public int hashCode() {
        return this.hashCode;
    }

    public PersistentBlobTempBucket(PersistentBlobTempBucketFactory factory2, long blockSize2, long slot, PersistentBlobTempBucketTag tag, boolean shadow) {
        this.factory = factory2;
        this.blockSize = blockSize2;
        this.index = slot;
        this.hashCode = super.hashCode();
        if (tag == null && !shadow) {
            throw new NullPointerException();
        }
        if (shadow) {
            tag = null;
        }
        this.tag = tag;
        this.shadow = shadow;
        this.readOnly = shadow;
    }

    public Bucket createShadow() throws IOException {
        return this.factory.createShadow(this);
    }

    public void free() {
        if (this.shadow) {
            this.factory.freeShadow(this.index, this);
        } else {
            this.factory.freeBucket(this.index, this);
        }
    }

    public boolean freed() {
        return this.freed;
    }

    synchronized void onFree() {
        this.freed = true;
    }

    boolean persisted() {
        return this.persisted;
    }

    public InputStream getInputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        final FileChannel channel = this.factory.channel;
        return new InputStream(){
            private int offset;
            private boolean closed;
            {
                PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket2) {
                    PersistentBlobTempBucket.this.inputStreams++;
                }
            }

            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("closed");
                }
                byte[] buf = new byte[1];
                int res = this.read(buf);
                if (res == -1) {
                    return -1;
                }
                return buf[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buffer, int bufOffset, int length) throws IOException {
                int read;
                long max;
                if (this.closed) {
                    throw new IOException("closed");
                }
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    if (PersistentBlobTempBucket.this.freed) {
                        throw new IOException("Bucket freed during read");
                    }
                    max = Math.min(PersistentBlobTempBucket.this.blockSize, PersistentBlobTempBucket.this.size);
                }
                if (length == 0) {
                    return 0;
                }
                if (bufOffset < 0) {
                    return -1;
                }
                if ((long)(this.offset + length) >= max) {
                    length = (int)Math.min(max - (long)this.offset, Integer.MAX_VALUE);
                }
                if (length == 0) {
                    return -1;
                }
                if (length < 0) {
                    throw new IllegalStateException("offset=" + bufOffset + " length=" + length + " buf len = " + buffer.length + " my offset is " + this.offset + " my size is " + max + " for " + this + " for " + PersistentBlobTempBucket.this);
                }
                ByteBuffer buf = ByteBuffer.wrap(buffer, bufOffset, length);
                PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket2) {
                    read = channel.read(buf, PersistentBlobTempBucket.this.blockSize * PersistentBlobTempBucket.this.index + (long)this.offset);
                }
                if (read > 0) {
                    this.offset += read;
                }
                return read;
            }

            public int read(byte[] buffer) throws IOException {
                if (this.closed) {
                    throw new IOException("closed");
                }
                return this.read(buffer, 0, buffer.length);
            }

            public int available() {
                return (int)Math.min(PersistentBlobTempBucket.this.blockSize - (long)this.offset, Integer.MAX_VALUE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    PersistentBlobTempBucket.this.inputStreams--;
                }
            }
        };
    }

    public String getName() {
        return this.factory.getName() + ":" + this.index;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        if (this.shadow) {
            throw new IOException("Shadow");
        }
        if (this.readOnly) {
            throw new IOException("Read-only");
        }
        final FileChannel channel = this.factory.channel;
        return new OutputStream(){
            private int offset;

            public void write(int arg) throws IOException {
                byte[] buf = new byte[]{(byte)arg};
                this.write(buf, 0, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] buffer, int bufOffset, int length) throws IOException {
                int w;
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    if (PersistentBlobTempBucket.this.freed) {
                        throw new IOException("Bucket freed during write");
                    }
                    if (PersistentBlobTempBucket.this.readOnly) {
                        throw new IOException("Bucket made read only during write");
                    }
                }
                long remaining = PersistentBlobTempBucket.this.blockSize - (long)this.offset;
                if (remaining <= 0L) {
                    throw new IOException("Too big");
                }
                if ((long)length > remaining) {
                    throw new IOException("Writing too many bytes: written " + this.offset + " of " + PersistentBlobTempBucket.this.blockSize + " and now want to write " + length);
                }
                ByteBuffer buf = ByteBuffer.wrap(buffer, bufOffset, length);
                for (int written = 0; written < length; written += w) {
                    PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                    synchronized (persistentBlobTempBucket2) {
                        w = channel.write(buf, PersistentBlobTempBucket.this.blockSize * PersistentBlobTempBucket.this.index + (long)this.offset);
                        this.offset += w;
                        PersistentBlobTempBucket.this.size += (long)w;
                        continue;
                    }
                }
            }

            public void write(byte[] buffer) throws IOException {
                this.write(buffer, 0, buffer.length);
            }
        };
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTo(ObjectContainer container) {
        boolean p;
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            if (this.tag == null) {
                throw new NullPointerException();
            }
            p = this.persisted;
            this.persisted = true;
        }
        if (!p) {
            this.factory.store(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectCanNew(ObjectContainer container) {
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            if (this.persisted) {
                return true;
            }
        }
        Logger.error(this, "objectOnNew() called but we haven't been stored yet! for " + this + " for " + this.factory + " index " + this.index, new Exception("error"));
        return true;
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        if (this.inputStreams > 0) {
            Logger.error(this, "Deactivating when have active input streams!", new Exception("error"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container) {
        boolean p;
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            p = this.persisted;
        }
        if (p) {
            this.factory.remove(this, container);
        }
        container.delete((Object)this);
    }

    synchronized void onRemove() {
        this.persisted = false;
    }

    public synchronized long getIndex() {
        return this.index;
    }

    synchronized void setIndex(long index2) {
        this.index = index2;
    }

    synchronized void setTag(PersistentBlobTempBucketTag newTag) {
        this.tag = newTag;
    }

    public synchronized PersistentBlobTempBucketTag getTag() {
        return this.tag;
    }
}

