/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.PCFBMode;
import freenet.crypt.RandomSource;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.SerializableToFieldSetBucket;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.spaceroots.mantissa.random.MersenneTwister;

public class PaddedEphemerallyEncryptedBucket
implements Bucket,
SerializableToFieldSetBucket {
    private final Bucket bucket;
    private final int minPaddedSize;
    private final byte[] key;
    private final byte[] randomSeed;
    private long dataLength;
    private boolean readOnly;
    private int lastOutputStream;

    public PaddedEphemerallyEncryptedBucket(Bucket bucket, int minSize, RandomSource strongPRNG, Random weakPRNG) {
        this.bucket = bucket;
        if (bucket.size() != 0L) {
            throw new IllegalArgumentException("Bucket must be empty");
        }
        byte[] tempKey = new byte[32];
        this.randomSeed = new byte[32];
        weakPRNG.nextBytes(this.randomSeed);
        strongPRNG.nextBytes(tempKey);
        this.key = tempKey;
        this.minPaddedSize = minSize;
        this.readOnly = false;
        this.lastOutputStream = 0;
        this.dataLength = 0L;
    }

    public PaddedEphemerallyEncryptedBucket(Bucket bucket, int minSize, long knownSize, byte[] key, RandomSource origRandom) throws IOException {
        if (bucket.size() < knownSize) {
            throw new IOException("Bucket " + bucket + " is too small on disk - knownSize=" + knownSize + " but bucket.size=" + bucket.size() + " for " + bucket);
        }
        this.dataLength = knownSize;
        this.bucket = bucket;
        if (key.length != 32) {
            throw new IllegalArgumentException("Key wrong length: " + key.length);
        }
        this.randomSeed = new byte[32];
        origRandom.nextBytes(this.randomSeed);
        this.key = key;
        this.minPaddedSize = minSize;
        this.readOnly = false;
        this.lastOutputStream = 0;
    }

    public PaddedEphemerallyEncryptedBucket(SimpleFieldSet fs, RandomSource origRandom, PersistentFileTracker f) throws CannotCreateFromFieldSetException {
        String tmp = fs.get("DataLength");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No DataLength");
        }
        try {
            this.dataLength = Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt dataLength: " + tmp, e);
        }
        SimpleFieldSet underlying = fs.subset("Underlying");
        if (underlying == null) {
            throw new CannotCreateFromFieldSetException("No underlying bucket");
        }
        this.bucket = SerializableToFieldSetBucketUtil.create(underlying, origRandom, f);
        tmp = fs.get("DecryptKey");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No key");
        }
        this.key = HexUtil.hexToBytes(tmp);
        if (this.key.length != 32) {
            throw new IllegalArgumentException("Key wrong length: " + this.key.length);
        }
        tmp = fs.get("MinPaddedSize");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No MinPaddedSize!");
        }
        try {
            this.minPaddedSize = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt dataLength: " + tmp, e);
        }
        if (this.dataLength > this.bucket.size()) {
            throw new CannotCreateFromFieldSetException("Underlying bucket " + this.bucket + " is too small: should be " + this.dataLength + " actually " + this.bucket.size());
        }
        this.randomSeed = new byte[32];
        origRandom.nextBytes(this.randomSeed);
    }

    public PaddedEphemerallyEncryptedBucket(PaddedEphemerallyEncryptedBucket orig, Bucket newBucket) {
        this.dataLength = orig.dataLength;
        this.key = new byte[orig.key.length];
        System.arraycopy(orig.key, 0, this.key, 0, orig.key.length);
        this.randomSeed = null;
        this.setReadOnly();
        this.bucket = newBucket;
        this.minPaddedSize = orig.minPaddedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        OutputStream os = this.bucket.getOutputStream();
        PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = this;
        synchronized (paddedEphemerallyEncryptedBucket) {
            this.dataLength = 0L;
        }
        return new PaddedEphemerallyEncryptedOutputStream(os, ++this.lastOutputStream);
    }

    public InputStream getInputStream() throws IOException {
        return new PaddedEphemerallyEncryptedInputStream(this.bucket.getInputStream());
    }

    public synchronized long paddedLength() {
        long size = this.dataLength;
        if (size < (long)this.minPaddedSize) {
            size = this.minPaddedSize;
        }
        if (size == (long)this.minPaddedSize) {
            return size;
        }
        long min = this.minPaddedSize;
        long max = (long)this.minPaddedSize << 1;
        while (true) {
            if (max < 0L) {
                throw new Error("Impossible size: " + size + " - min=" + min + ", max=" + max);
            }
            if (size < min) {
                throw new IllegalStateException("???");
            }
            if (size >= min && size <= max) {
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Padded: " + max + " was: " + this.dataLength + " for " + this.getName());
                }
                return max;
            }
            min = max;
            max <<= 1;
        }
    }

    private synchronized Rijndael getRijndael() {
        Rijndael aes;
        try {
            aes = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        aes.initialize(this.key);
        return aes;
    }

    public String getName() {
        return "Encrypted:" + this.bucket.getName();
    }

    public String toString() {
        return super.toString() + ':' + this.bucket.toString();
    }

    public synchronized long size() {
        return this.dataLength;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public Bucket getUnderlying() {
        return this.bucket;
    }

    public void free() {
        this.bucket.free();
    }

    public byte[] getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet toFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", "PaddedEphemerallyEncryptedBucket");
        PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = this;
        synchronized (paddedEphemerallyEncryptedBucket) {
            fs.put("DataLength", this.dataLength);
        }
        if (this.key == null) {
            Logger.error(this, "Cannot serialize because no key");
            return null;
        }
        fs.putSingle("DecryptKey", HexUtil.bytesToHex(this.key));
        if (!(this.bucket instanceof SerializableToFieldSetBucket)) {
            Logger.error(this, "Cannot serialize underlying bucket: " + this.bucket);
            return null;
        }
        fs.put("Underlying", ((SerializableToFieldSetBucket)this.bucket).toFieldSet());
        fs.put("MinPaddedSize", this.minPaddedSize);
        return fs;
    }

    public void storeTo(ObjectContainer container) {
        this.bucket.storeTo(container);
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Removing from database: " + this);
        }
        this.bucket.removeFrom(container);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        Logger.minor(this, "Activating " + super.toString() + " bucket == null = " + (this.bucket == null));
        container.activate((Object)this.bucket, 1);
    }

    public Bucket createShadow() throws IOException {
        Bucket newUnderlying = this.bucket.createShadow();
        if (newUnderlying == null) {
            return null;
        }
        return new PaddedEphemerallyEncryptedBucket(this, newUnderlying);
    }

    private class PaddedEphemerallyEncryptedInputStream
    extends InputStream {
        final InputStream in;
        final PCFBMode pcfb;
        long ptr;

        public PaddedEphemerallyEncryptedInputStream(InputStream in) {
            this.in = in;
            Rijndael aes = PaddedEphemerallyEncryptedBucket.this.getRijndael();
            this.pcfb = PCFBMode.create(aes);
            this.ptr = 0L;
        }

        public int read() throws IOException {
            if (this.ptr >= PaddedEphemerallyEncryptedBucket.this.dataLength) {
                return -1;
            }
            int x = this.in.read();
            if (x == -1) {
                return x;
            }
            ++this.ptr;
            return this.pcfb.decipher(x);
        }

        public final int available() {
            int x = (int)Math.min(PaddedEphemerallyEncryptedBucket.this.dataLength - this.ptr, Integer.MAX_VALUE);
            return x < 0 ? 0 : x;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (length + offset > buf.length || offset < 0 || length < 0) {
                throw new ArrayIndexOutOfBoundsException("a=" + offset + ", b=" + length + ", length " + buf.length);
            }
            int x = this.available();
            if (x <= 0) {
                return -1;
            }
            int readBytes = this.in.read(buf, offset, length = Math.min(length, x));
            if (readBytes <= 0) {
                return readBytes;
            }
            this.ptr += (long)readBytes;
            this.pcfb.blockDecipher(buf, offset, readBytes);
            return readBytes;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public long skip(long bytes) throws IOException {
            long skipped;
            int x;
            byte[] buf = new byte[(int)Math.min(4096L, bytes)];
            for (skipped = 0L; skipped < bytes; skipped += (long)x) {
                x = this.read(buf, 0, (int)Math.min(bytes - skipped, (long)buf.length));
                if (x > 0) continue;
                return skipped;
            }
            return skipped;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private class PaddedEphemerallyEncryptedOutputStream
    extends OutputStream {
        final PCFBMode pcfb;
        final OutputStream out;
        final int streamNumber;
        private boolean closed;

        public PaddedEphemerallyEncryptedOutputStream(OutputStream out, int streamNumber) {
            this.out = out;
            PaddedEphemerallyEncryptedBucket.this.dataLength = 0L;
            this.streamNumber = streamNumber;
            Rijndael aes = PaddedEphemerallyEncryptedBucket.this.getRijndael();
            this.pcfb = PCFBMode.create(aes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            int toWrite = this.pcfb.encipher(b);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                this.out.write(toWrite);
                PaddedEphemerallyEncryptedBucket.this.dataLength++;
            }
        }

        public void write(byte[] buf) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            this.write(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            if (length == 0) {
                return;
            }
            byte[] enc = new byte[length];
            System.arraycopy(buf, offset, enc, 0, length);
            this.pcfb.blockEncipher(enc, 0, enc.length);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                this.out.write(enc, 0, enc.length);
                PaddedEphemerallyEncryptedBucket.this.dataLength += enc.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            block8: {
                block7: {
                    if (this.closed) {
                        return;
                    }
                    try {
                        if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                            Logger.normal(this, "Not padding out to length because have been superceded: " + PaddedEphemerallyEncryptedBucket.this.getName());
                            Object var13_1 = null;
                            this.closed = true;
                            break block7;
                        }
                        MersenneTwister random = new MersenneTwister(PaddedEphemerallyEncryptedBucket.this.randomSeed);
                        PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
                        synchronized (paddedEphemerallyEncryptedBucket) {
                            int left;
                            long finalLength = PaddedEphemerallyEncryptedBucket.this.paddedLength();
                            long padding = finalLength - PaddedEphemerallyEncryptedBucket.this.dataLength;
                            byte[] buf = new byte[4096];
                            for (long writtenPadding = 0L; writtenPadding < padding; writtenPadding += (long)left) {
                                left = (int)Math.min(padding - writtenPadding, (long)buf.length);
                                random.nextBytes(buf);
                                this.out.write(buf, 0, left);
                            }
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var13_3 = null;
                        this.closed = true;
                        this.out.flush();
                        this.out.close();
                        throw throwable;
                    }
                }
                this.out.flush();
                this.out.close();
                return;
            }
            Object var13_2 = null;
            this.closed = true;
            this.out.flush();
            this.out.close();
        }
    }
}

