/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class MultiReaderBucket {
    private final Bucket bucket;
    private ArrayList<Bucket> readers;
    private boolean closed;

    public MultiReaderBucket(Bucket underlying) {
        this.bucket = underlying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getReaderBucket() {
        MultiReaderBucket multiReaderBucket = this;
        synchronized (multiReaderBucket) {
            if (this.closed) {
                return null;
            }
            ReaderBucket d = new ReaderBucket();
            if (this.readers == null) {
                this.readers = new ArrayList(1);
            }
            this.readers.add(d);
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "getReaderBucket() returning " + d + " for " + this + " for " + this.bucket);
            }
            return d;
        }
    }

    class ReaderBucket
    implements Bucket {
        private boolean freed;

        ReaderBucket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free() {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "ReaderBucket " + this + " for " + MultiReaderBucket.this + " free()ing for " + MultiReaderBucket.this.bucket);
            }
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (this.freed) {
                    return;
                }
                this.freed = true;
                MultiReaderBucket.this.readers.remove(this);
                if (!MultiReaderBucket.this.readers.isEmpty()) {
                    return;
                }
                MultiReaderBucket.this.readers = null;
                if (MultiReaderBucket.this.closed) {
                    return;
                }
                MultiReaderBucket.this.closed = true;
            }
            MultiReaderBucket.this.bucket.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (this.freed || MultiReaderBucket.this.closed) {
                    throw new IOException("Already freed");
                }
            }
            return new ReaderBucketInputStream();
        }

        public String getName() {
            return MultiReaderBucket.this.bucket.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Read only");
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setReadOnly() {
        }

        public long size() {
            return MultiReaderBucket.this.bucket.size();
        }

        protected void finalize() {
            this.free();
        }

        public void storeTo(ObjectContainer container) {
            container.store((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeFrom(ObjectContainer container) {
            container.delete((Object)this);
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (!MultiReaderBucket.this.closed) {
                    return;
                }
            }
            MultiReaderBucket.this.bucket.removeFrom(container);
            container.delete((Object)MultiReaderBucket.this.readers);
            container.delete((Object)MultiReaderBucket.this);
        }

        public Bucket createShadow() throws IOException {
            return null;
        }

        private class ReaderBucketInputStream
        extends InputStream {
            InputStream is;

            ReaderBucketInputStream() throws IOException {
                this.is = MultiReaderBucket.this.bucket.getInputStream();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int read() throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int read(byte[] data, int offset, int length) throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read(data, offset, length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int read(byte[] data) throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read(data);
            }

            public final void close() throws IOException {
                this.is.close();
            }
        }
    }
}

