/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperManager;

public class FilenameGenerator {
    private transient Random random;
    private String prefix;
    private File tmpDir;

    public FilenameGenerator(Random random, boolean wipeFiles, File dir, String prefix) throws IOException {
        this.random = random;
        this.prefix = prefix;
        this.tmpDir = dir == null ? FileUtil.getCanonicalFile(new File(System.getProperty("java.io.tmpdir"))) : FileUtil.getCanonicalFile(dir);
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
        if (!(this.tmpDir.isDirectory() && this.tmpDir.canRead() && this.tmpDir.canWrite())) {
            throw new IOException("Not a directory or cannot read/write: " + this.tmpDir);
        }
        if (wipeFiles) {
            long wipedFiles = 0L;
            long wipeableFiles = 0L;
            long startWipe = System.currentTimeMillis();
            File[] filenames = this.tmpDir.listFiles();
            if (filenames != null) {
                for (int i = 0; i < filenames.length; ++i) {
                    WrapperManager.signalStarting((int)300000);
                    if (i % 1024 == 0 && i > 0) {
                        System.err.println("Deleted " + wipedFiles + " temp files (" + ((long)i - wipeableFiles) + " non-temp files in temp dir)");
                    }
                    File f = filenames[i];
                    String name = f.getName();
                    if ((File.separatorChar != '\\' || !name.toLowerCase().startsWith(prefix.toLowerCase())) && !name.startsWith(prefix)) continue;
                    ++wipeableFiles;
                    if (!f.delete() && f.exists()) {
                        System.err.println("Unable to delete temporary file " + f + " - permissions problem?");
                        continue;
                    }
                    ++wipedFiles;
                }
                long endWipe = System.currentTimeMillis();
                System.err.println("Deleted " + wipedFiles + " of " + wipeableFiles + " temporary files (" + ((long)filenames.length - wipeableFiles) + " non-temp files in temp directory) in " + TimeUtil.formatTime(endWipe - startWipe));
            }
        }
    }

    public long makeRandomFilename() {
        String filename;
        File ret;
        long randomFilename;
        while ((randomFilename = this.random.nextLong()) == -1L || (ret = new File(this.tmpDir, filename = this.prefix + Long.toHexString(randomFilename))).exists()) {
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Made random filename: " + ret, (Throwable)new Exception("debug"));
        }
        return randomFilename;
    }

    public File getFilename(long id) {
        return new File(this.tmpDir, this.prefix + Long.toHexString(id));
    }

    public File makeRandomFile() throws IOException {
        File file;
        while (!(file = this.getFilename(this.makeRandomFilename())).createNewFile()) {
        }
        return file;
    }

    public boolean matches(File file) {
        return this.getID(file) != -1L;
    }

    public long getID(File file) {
        if (!FileUtil.getCanonicalFile(file.getParentFile()).equals(this.tmpDir)) {
            Logger.error(this, "Not the same dir: parent=" + FileUtil.getCanonicalFile(file.getParentFile()) + " but tmpDir=" + this.tmpDir);
            return -1L;
        }
        String name = file.getName();
        if (!name.startsWith(this.prefix)) {
            Logger.error(this, "Does not start with prefix: " + name + " prefix " + this.prefix);
            return -1L;
        }
        try {
            return Fields.hexToLong(name.substring(this.prefix.length()));
        }
        catch (NumberFormatException e) {
            Logger.error(this, "Cannot getID: " + e + " from " + name.substring(this.prefix.length()), e);
            return -1L;
        }
    }

    public File getDir() {
        return this.tmpDir;
    }

    public void init(File dir, String prefix, Random random) throws IOException {
        this.random = random;
        File oldDir = FileUtil.getCanonicalFile(new File(this.tmpDir.getPath()));
        File newDir = FileUtil.getCanonicalFile(dir);
        System.err.println("Old: " + oldDir + " prefix " + this.prefix + " from " + this.tmpDir + " old path " + this.tmpDir.getPath() + " old parent " + this.tmpDir.getParent());
        System.err.println("New: " + newDir + " prefix " + prefix + " from " + dir);
        if (newDir.exists() && newDir.isDirectory() && newDir.canWrite() && newDir.canRead() && !oldDir.exists()) {
            System.err.println("Assuming the user has moved the data from " + oldDir + " to " + newDir);
            this.tmpDir = newDir;
            return;
        }
        if (oldDir.equals(newDir) && this.prefix.equals(prefix)) {
            Logger.normal(this, "Initialised FilenameGenerator successfully - no change in dir and prefix: dir=" + dir + " prefix=" + prefix);
        } else if (!oldDir.equals(newDir) && this.prefix.equals(prefix)) {
            if (!dir.exists() && oldDir.renameTo(dir)) {
                this.tmpDir = dir;
                String msg = "Successfully renamed persistent temporary directory from " + this.tmpDir + " to " + dir;
                Logger.error(this, msg);
                System.err.println(msg);
            } else {
                if (!dir.exists() && !dir.mkdir()) {
                    System.err.println("Unable to create new temporary directory: " + dir);
                    throw new IOException("Unable to create new temporary directory: " + dir);
                }
                if (!dir.canRead() || !dir.canWrite()) {
                    System.err.println("Unable to read and write new temporary directory: " + dir);
                    throw new IOException("Unable to read and write new temporary directory: " + dir);
                }
                int moved = 0;
                int failed = 0;
                File[] list = this.tmpDir.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    File f = list[i];
                    String name = f.getName();
                    if (!name.startsWith(prefix)) continue;
                    if (FileUtil.moveTo(f, new File(dir, name), true)) {
                        ++moved;
                        continue;
                    }
                    ++failed;
                }
                if (failed > 0) {
                    System.err.println("WARNING: Not all files successfully moved changing temp dir: " + failed + " failed.");
                    System.err.println("WARNING: Some persistent downloads etc may fail.");
                }
            }
        } else {
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Unable to create new temporary directory: " + dir);
                throw new IOException("Unable to create new temporary directory: " + dir);
            }
            if (!dir.canRead() || !dir.canWrite()) {
                System.err.println("Unable to read and write new temporary directory: " + dir);
                throw new IOException("Unable to read and write new temporary directory: " + dir);
            }
            int moved = 0;
            int failed = 0;
            File[] list = this.tmpDir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                String newName;
                File f = list[i];
                String name = f.getName();
                if (!name.startsWith(this.prefix) || !FileUtil.moveTo(f, new File(dir, newName = prefix + name.substring(this.prefix.length())), true)) continue;
                ++moved;
            }
            if (failed > 0) {
                System.err.println("WARNING: Not all files successfully moved changing temp dir: " + failed + " failed.");
                System.err.println("WARNING: Some persistent downloads etc may fail.");
            }
        }
    }
}

