/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.DefaultMIMETypes;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public final class FileUtil {
    private static final int BUFFER_SIZE = 4096;

    private static final long roundup_2n(long val, int blocksize) {
        int mask = blocksize - 1;
        return val + (long)mask & (long)(~mask);
    }

    public static long estimateUsage(File file, long flen) {
        long blockUsage = FileUtil.roundup_2n(flen, 4096);
        String filename = file.getName();
        int nameLength = filename.getBytes().length + 100;
        long filenameUsage = FileUtil.roundup_2n(nameLength, 512);
        long extra = FileUtil.roundup_2n(flen, 1024) / 1024L * 50L;
        return blockUsage + filenameUsage + extra;
    }

    public static boolean isParent(File poss, File filename) {
        File canon = FileUtil.getCanonicalFile(poss);
        File canonFile = FileUtil.getCanonicalFile(filename);
        if (FileUtil.isParentInner(poss, filename)) {
            return true;
        }
        if (FileUtil.isParentInner(poss, canonFile)) {
            return true;
        }
        if (FileUtil.isParentInner(canon, filename)) {
            return true;
        }
        return FileUtil.isParentInner(canon, canonFile);
    }

    private static boolean isParentInner(File possParent, File filename) {
        do {
            if (!filename.equals(possParent)) continue;
            return true;
        } while ((filename = filename.getParentFile()) != null);
        return false;
    }

    public static File getCanonicalFile(File file) {
        File result;
        file = new File(file.getPath());
        try {
            result = file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            result = file.getAbsoluteFile();
        }
        return result;
    }

    public static String readUTF(File file) throws FileNotFoundException, IOException {
        return FileUtil.readUTF(file, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUTF(File file, long offset) throws FileNotFoundException, IOException {
        StringBuilder result = new StringBuilder();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(file);
            FileUtil.skipFully(fis, offset);
            bis = new BufferedInputStream(fis);
            isr = new InputStreamReader((InputStream)bis, "UTF-8");
            char[] buf = new char[4096];
            int length = 0;
            while ((length = isr.read(buf)) > 0) {
                result.append(buf, 0, length);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Closer.close(isr);
            Closer.close(bis);
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(isr);
        Closer.close(bis);
        Closer.close(fis);
        return result.toString();
    }

    public static void skipFully(InputStream is, long skip) throws IOException {
        long x;
        for (long skipped = 0L; skipped < skip; skipped += x) {
            x = is.skip(skip - skipped);
            if (x > 0L) continue;
            throw new IOException("Unable to skip " + (skip - skipped) + " bytes");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTo(InputStream input, File target) throws FileNotFoundException, IOException {
        File file;
        FileOutputStream fos;
        block10: {
            DataInputStream dis = null;
            fos = null;
            file = File.createTempFile("temp", ".tmp", target.getParentFile());
            if (Logger.shouldLog(4, FileUtil.class)) {
                Logger.minor(FileUtil.class, "Writing to " + file + " to be renamed to " + target);
            }
            try {
                dis = new DataInputStream(input);
                fos = new FileOutputStream(file);
                int len = 0;
                byte[] buffer = new byte[4096];
                while ((len = dis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                Object var8_8 = null;
                if (dis == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (dis != null) {
                    dis.close();
                }
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            dis.close();
        }
        if (fos != null) {
            fos.close();
        }
        if (FileUtil.renameTo(file, target)) {
            return true;
        }
        file.delete();
        return false;
    }

    public static boolean renameTo(File orig, File dest) {
        if (orig.equals(dest)) {
            throw new IllegalArgumentException("Huh? the two file descriptors are the same!");
        }
        if (!orig.exists()) {
            throw new IllegalArgumentException("Original doesn't exist!");
        }
        if (!orig.renameTo(dest)) {
            if (!dest.delete() && dest.exists()) {
                Logger.error("FileUtil", "Could not delete " + dest + " - check permissions");
            }
            if (!orig.renameTo(dest)) {
                Logger.error("FileUtil", "Could not rename " + orig + " to " + dest + (dest.exists() ? " (target exists)" : "") + (orig.exists() ? " (source exists)" : "") + " - check permissions");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveTo(File orig, File dest, boolean overwrite) {
        if (orig.equals(dest)) {
            throw new IllegalArgumentException("Huh? the two file descriptors are the same!");
        }
        if (!orig.exists()) {
            throw new IllegalArgumentException("Original doesn't exist!");
        }
        if (dest.exists()) {
            if (overwrite) {
                dest.delete();
            } else {
                System.err.println("Not overwriting " + dest + " - already exists moving " + orig);
                return false;
            }
        }
        if (!orig.renameTo(dest)) {
            boolean bl;
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                is = new FileInputStream(orig);
                os = new FileOutputStream(dest);
                FileUtil.copy(is, os, orig.length());
                ((InputStream)is).close();
                is = null;
                ((OutputStream)os).close();
                os = null;
                orig.delete();
                bl = true;
                Object var8_7 = null;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    dest.delete();
                    Logger.error(FileUtil.class, "Move failed from " + orig + " to " + dest + " : " + e, e);
                    System.err.println("Move failed from " + orig + " to " + dest + " : " + e);
                    e.printStackTrace();
                    bl2 = false;
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    Closer.close(is);
                    Closer.close(os);
                    throw throwable;
                }
                Closer.close(is);
                Closer.close(os);
                return bl2;
            }
            Closer.close(is);
            Closer.close(os);
            return bl;
        }
        return true;
    }

    public static String sanitize(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/' || c == '\\' || c == '%' || c == '>' || c == '<' || c == ':' || c == '\'' || c == '\"') continue;
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isLetter(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append(' ');
                continue;
            }
            if (c != '-' && c != '_' && c != '.') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitize(String filename, String mimeType) {
        String oldExt;
        filename = FileUtil.sanitize(filename);
        if (mimeType == null) {
            return filename;
        }
        if (filename.indexOf(46) >= 0 && DefaultMIMETypes.isValidExt(mimeType, oldExt = filename.substring(filename.lastIndexOf(46)))) {
            return filename;
        }
        String defaultExt = DefaultMIMETypes.getExtension(filename);
        if (defaultExt == null) {
            return filename;
        }
        return filename + '.' + defaultExt;
    }

    public static long findLength(InputStream source) throws IOException {
        long length = 0L;
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read > -1) {
            read = source.read(buffer);
            if (read == -1) continue;
            length += (long)read;
        }
        return length;
    }

    public static void copy(InputStream source, OutputStream destination, long length) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        for (long remaining = length; remaining == -1L || remaining > 0L; remaining -= (long)read) {
            read = source.read(buffer, 0, remaining > 4096L || remaining == -1L ? 4096 : (int)remaining);
            if (read == -1) {
                if (length == -1L) {
                    return;
                }
                throw new EOFException("stream reached eof");
            }
            destination.write(buffer, 0, read);
        }
    }

    public static boolean removeAll(File wd) {
        if (!wd.isDirectory()) {
            System.err.println("DELETING FILE " + wd);
            if (!wd.delete() && wd.exists()) {
                Logger.error(FileUtil.class, "Could not delete file: " + wd);
                return false;
            }
        } else {
            File[] subfiles = wd.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                if (FileUtil.removeAll(subfiles[i])) continue;
                return false;
            }
            if (!wd.delete()) {
                Logger.error(FileUtil.class, "Could not delete directory: " + wd);
            }
        }
        return true;
    }
}

