/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.SerializableToFieldSetBucket;
import java.io.File;
import java.io.IOException;

public class FileBucket
extends BaseFileBucket
implements Bucket,
SerializableToFieldSetBucket {
    protected final File file;
    protected boolean readOnly;
    protected boolean deleteOnFinalize;
    protected boolean deleteOnFree;
    protected final boolean deleteOnExit;
    protected final boolean createFileOnly;

    public FileBucket(File file, boolean readOnly, boolean createFileOnly, boolean deleteOnFinalize, boolean deleteOnExit, boolean deleteOnFree) {
        super(file, deleteOnExit);
        if (file == null) {
            throw new NullPointerException();
        }
        File origFile = file;
        if (origFile == (file = file.getAbsoluteFile())) {
            file = new File(file.getPath());
        }
        this.readOnly = readOnly;
        this.createFileOnly = createFileOnly;
        this.file = file;
        this.deleteOnFinalize = deleteOnFinalize;
        this.deleteOnFree = deleteOnFree;
        this.deleteOnExit = deleteOnExit;
        this.fileRestartCounter = 0L;
    }

    public synchronized File getFile() {
        return this.file;
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized void dontDeleteOnFinalize() {
        this.deleteOnFinalize = false;
    }

    protected boolean createFileOnly() {
        return this.createFileOnly;
    }

    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    protected boolean deleteOnFinalize() {
        return this.deleteOnFinalize;
    }

    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        Logger.minor(this, "Removing " + this);
        container.activate((Object)this.file, 5);
        container.delete((Object)this.file);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.file, 5);
    }

    public Bucket createShadow() throws IOException {
        String fnam = this.file.getPath();
        File newFile = new File(fnam);
        return new FileBucket(newFile, true, false, false, false, false);
    }
}

