/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.RandomSource;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempBucketFactory;
import freenet.support.io.SerializableToFieldSetBucket;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DelayedFreeBucket
implements Bucket,
SerializableToFieldSetBucket {
    private final PersistentFileTracker factory;
    Bucket bucket;
    boolean freed;
    boolean removed;
    boolean reallyRemoved;
    private transient int _activationCount = 0;

    public boolean toFree() {
        return this.freed;
    }

    public boolean toRemove() {
        return this.removed;
    }

    public DelayedFreeBucket(PersistentTempBucketFactory factory, Bucket bucket) {
        this.factory = factory;
        this.bucket = bucket;
        if (bucket == null) {
            throw new NullPointerException();
        }
    }

    public DelayedFreeBucket(SimpleFieldSet fs, RandomSource random, PersistentFileTracker f) throws CannotCreateFromFieldSetException {
        this.factory = f;
        this.freed = false;
        this.bucket = SerializableToFieldSetBucketUtil.create(fs.subset("Underlying"), random, f);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        return this.bucket.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        return this.bucket.getInputStream();
    }

    public String getName() {
        return this.bucket.getName();
    }

    public long size() {
        return this.bucket.size();
    }

    public boolean isReadOnly() {
        return this.bucket.isReadOnly();
    }

    public void setReadOnly() {
        this.bucket.setReadOnly();
    }

    public Bucket getUnderlying() {
        if (this.freed) {
            return null;
        }
        return this.bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        DelayedFreeBucket delayedFreeBucket = this;
        synchronized (delayedFreeBucket) {
            if (this.freed) {
                return;
            }
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Freeing " + this + " underlying=" + this.bucket, (Throwable)new Exception("debug"));
            }
            this.factory.delayedFreeBucket(this);
            this.freed = true;
        }
    }

    public SimpleFieldSet toFieldSet() {
        if (this.freed) {
            Logger.error(this, "Cannot serialize because already freed: " + this);
            return null;
        }
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", "DelayedFreeBucket");
        if (!(this.bucket instanceof SerializableToFieldSetBucket)) {
            Logger.error(this, "Cannot serialize underlying bucket: " + this.bucket);
            return null;
        }
        fs.put("Underlying", ((SerializableToFieldSetBucket)this.bucket).toFieldSet());
        return fs;
    }

    public void storeTo(ObjectContainer container) {
        this.bucket.storeTo(container);
        container.store((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Removing from database: " + this);
        }
        DelayedFreeBucket delayedFreeBucket = this;
        synchronized (delayedFreeBucket) {
            boolean wasQueued;
            boolean bl = wasQueued = this.freed || this.removed;
            if (!this.freed) {
                Logger.error(this, "Asking to remove from database but not freed: " + this, new Exception("error"));
            }
            this.removed = true;
            if (!wasQueued) {
                this.factory.delayedFreeBucket(this);
            }
        }
    }

    public String toString() {
        return super.toString() + ":" + this.bucket;
    }

    public void objectOnActivate(ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Activating " + super.toString() + " : " + this.bucket.getClass());
        }
        if (this.bucket == this) {
            Logger.error(this, "objectOnActivate on DelayedFreeBucket: wrapping self!!!");
            return;
        }
        container.activate((Object)this.bucket, 1);
    }

    public Bucket createShadow() throws IOException {
        return this.bucket.createShadow();
    }

    public void realFree() {
        this.bucket.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realRemoveFrom(ObjectContainer container) {
        DelayedFreeBucket delayedFreeBucket = this;
        synchronized (delayedFreeBucket) {
            if (this.reallyRemoved) {
                Logger.error(this, "Calling realRemoveFrom() twice on " + this);
            }
            this.reallyRemoved = true;
        }
        this.bucket.removeFrom(container);
        container.delete((Object)this);
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.reallyRemoved) {
            Logger.error(this, "objectCanNew() on " + this + " but really removed = " + this.reallyRemoved + " already freed=" + this.freed + " removed=" + this.removed, new Exception("debug"));
            return false;
        }
        assert (this.bucket != null);
        return true;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.reallyRemoved) {
            Logger.error(this, "objectCanUpdate() on " + this + " but really removed = " + this.reallyRemoved + " already freed=" + this.freed + " removed=" + this.removed, new Exception("debug"));
            return false;
        }
        assert (this.bucket != null);
        return true;
    }
}

