/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.io.RandomAccessThing;
import java.io.IOException;

public class ByteArrayRandomAccessThing
implements RandomAccessThing {
    private final byte[] data;
    private boolean readOnly;

    public ByteArrayRandomAccessThing(byte[] padded) {
        this.data = padded;
    }

    public void close() {
    }

    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IOException("Cannot read before zero");
        }
        if (fileOffset + (long)length > (long)this.data.length) {
            throw new IOException("Cannot read after end: trying to read from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.data.length);
        }
        System.arraycopy(this.data, (int)fileOffset, buf, bufOffset, length);
    }

    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IOException("Cannot write before zero");
        }
        if (fileOffset + (long)length > (long)this.data.length) {
            throw new IOException("Cannot write after end: trying to write from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.data.length);
        }
        if (this.readOnly) {
            throw new IOException("Read-only");
        }
        System.arraycopy(buf, bufOffset, this.data, (int)fileOffset, length);
    }

    public long size() throws IOException {
        return this.data.length;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }
}

