/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.SHA256;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketChainBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.SegmentedBucketChainBucket;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.spaceroots.mantissa.random.MersenneTwister;

public class BucketTools {
    static final int BLOCK_SIZE = 4096;

    public static final void copy(Bucket src, Bucket dst) throws IOException {
        OutputStream out = dst.getOutputStream();
        InputStream in = src.getInputStream();
        ReadableByteChannel readChannel = Channels.newChannel(in);
        WritableByteChannel writeChannel = Channels.newChannel(out);
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        while (readChannel.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                writeChannel.write(buffer);
            }
            buffer.clear();
        }
        writeChannel.close();
        readChannel.close();
    }

    public static final void zeroPad(Bucket b, long size) throws IOException {
        long nRequired;
        OutputStream out = b.getOutputStream();
        byte[] buffer = new byte[16384];
        for (long count = 0L; count < size; count += nRequired) {
            nRequired = buffer.length;
            if (nRequired > size - count) {
                nRequired = size - count;
            }
            out.write(buffer, 0, (int)nRequired);
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void paddedCopy(Bucket from, Bucket to, long nBytes, int blockSize) throws IOException {
        OutputStream out;
        block14: {
            if (nBytes > (long)blockSize) {
                throw new IllegalArgumentException("nBytes > blockSize");
            }
            out = null;
            InputStream in = null;
            try {
                long count;
                long nRead;
                out = to.getOutputStream();
                byte[] buffer = new byte[16384];
                in = from.getInputStream();
                for (count = 0L; count != nBytes; count += nRead) {
                    long nRequired = nBytes - count;
                    if (nRequired > (long)buffer.length) {
                        nRequired = buffer.length;
                    }
                    if ((nRead = (long)in.read(buffer, 0, (int)nRequired)) == -1L) {
                        throw new IOException("Not enough data in source bucket.");
                    }
                    out.write(buffer, 0, (int)nRead);
                }
                if (count < (long)blockSize) {
                    long padLength = buffer.length;
                    if (padLength > (long)blockSize - nBytes) {
                        padLength = (long)blockSize - nBytes;
                    }
                    int i = 0;
                    while ((long)i < padLength) {
                        buffer[i] = 0;
                        ++i;
                    }
                    while (count != (long)blockSize) {
                        long nRequired = (long)blockSize - count;
                        if ((long)blockSize - count > (long)buffer.length) {
                            nRequired = buffer.length;
                        }
                        out.write(buffer, 0, (int)nRequired);
                        count += nRequired;
                    }
                }
                Object var15_12 = null;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
    }

    public static Bucket[] makeBuckets(BucketFactory bf, int count, int size) throws IOException {
        Bucket[] ret = new Bucket[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = bf.makeBucket(size);
        }
        return ret;
    }

    public static final int[] nullIndices(Bucket[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            list.add(i);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static final int[] nonNullIndices(Bucket[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            list.add(i);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static final Bucket[] nonNullBuckets(Bucket[] array) {
        ArrayList<Bucket> list = new ArrayList<Bucket>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            list.add(array[i]);
        }
        Bucket[] ret = new Bucket[list.size()];
        return list.toArray(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toByteArray(Bucket bucket) throws IOException {
        long size = bucket.size();
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        byte[] data = new byte[(int)size];
        InputStream is = bucket.getInputStream();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(is);
            dis.readFully(data);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Closer.close(dis);
            Closer.close(is);
            throw throwable;
        }
        Closer.close(dis);
        Closer.close(is);
        return data;
    }

    public static int toByteArray(Bucket bucket, byte[] output) throws IOException {
        int n;
        int moved;
        long size = bucket.size();
        if (size > (long)output.length) {
            throw new IllegalArgumentException("Data does not fit in provided buffer");
        }
        InputStream is = null;
        try {
            is = bucket.getInputStream();
            moved = 0;
            while (true) {
                if ((long)moved != size) break block6;
                n = moved;
                Object var9_6 = null;
                if (is == null) break block7;
                break;
            }
        }
        catch (Throwable throwable) {
            block10: {
                Object var9_8 = null;
                if (is == null) break block10;
                is.close();
            }
            throw throwable;
        }
        {
            int x;
            block8: {
                int n2;
                block9: {
                    block6: {
                        block7: {
                            is.close();
                        }
                        return n;
                    }
                    x = is.read(output, moved, (int)(size - (long)moved));
                    if (x != -1) break block8;
                    n2 = moved;
                    Object var9_7 = null;
                    if (is == null) break block9;
                    is.close();
                }
                return n2;
            }
            moved += x;
            continue;
        }
    }

    public static Bucket makeImmutableBucket(BucketFactory bucketFactory, byte[] data) throws IOException {
        return BucketTools.makeImmutableBucket(bucketFactory, data, data.length);
    }

    public static Bucket makeImmutableBucket(BucketFactory bucketFactory, byte[] data, int length) throws IOException {
        Bucket bucket = bucketFactory.makeBucket(length);
        OutputStream os = bucket.getOutputStream();
        os.write(data, 0, length);
        os.close();
        bucket.setReadOnly();
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] hash(Bucket data) throws IOException {
        byte[] byArray;
        InputStream is = data.getInputStream();
        try {
            MessageDigest md = SHA256.getMessageDigest();
            try {
                byte[] retval;
                long bytesRead;
                int readBytes;
                long bucketLength = data.size();
                byte[] buf = new byte[4096];
                for (bytesRead = 0L; (bytesRead < bucketLength || bucketLength == -1L) && (readBytes = is.read(buf)) >= 0; bytesRead += (long)readBytes) {
                    if (readBytes <= 0) continue;
                    md.update(buf, 0, readBytes);
                }
                if (bytesRead < bucketLength && bucketLength > 0L) {
                    throw new EOFException();
                }
                if (bytesRead != bucketLength && bucketLength > 0L) {
                    throw new IOException("Read " + bytesRead + " but bucket length " + bucketLength + " on " + data + '!');
                }
                byArray = retval = md.digest();
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                SHA256.returnMessageDigest(md);
                throw throwable;
            }
            SHA256.returnMessageDigest(md);
            Object var13_11 = null;
            if (is == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyTo(Bucket decodedData, OutputStream os, long truncateLength) throws IOException {
        long l;
        if (truncateLength == 0L) {
            return 0L;
        }
        if (truncateLength < 0L) {
            truncateLength = Long.MAX_VALUE;
        }
        InputStream is = decodedData.getInputStream();
        try {
            long moved;
            int bytes;
            byte[] buf = new byte[4096];
            for (moved = 0L; moved < truncateLength; moved += (long)bytes) {
                bytes = (int)Math.min((long)buf.length, truncateLength - moved);
                if (bytes <= 0) {
                    throw new IllegalStateException("bytes=" + bytes + ", truncateLength=" + truncateLength + ", moved=" + moved);
                }
                if ((bytes = is.read(buf, 0, bytes)) <= 0) {
                    if (truncateLength == Long.MAX_VALUE) break;
                    IOException ioException = new IOException("Could not move required quantity of data in copyTo: " + bytes + " (moved " + moved + " of " + truncateLength + "): unable to read from " + is);
                    ioException.printStackTrace();
                    throw ioException;
                }
                os.write(buf, 0, bytes);
            }
            l = moved;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            is.close();
            os.flush();
            throw throwable;
        }
        is.close();
        os.flush();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFrom(Bucket bucket, InputStream is, long truncateLength) throws IOException {
        OutputStream os = bucket.getOutputStream();
        byte[] buf = new byte[4096];
        if (truncateLength < 0L) {
            truncateLength = Long.MAX_VALUE;
        }
        try {
            int bytes;
            for (long moved = 0L; moved < truncateLength; moved += (long)bytes) {
                bytes = (int)Math.min((long)buf.length, truncateLength - moved);
                if (bytes <= 0) {
                    throw new IllegalStateException("bytes=" + bytes + ", truncateLength=" + truncateLength + ", moved=" + moved);
                }
                if ((bytes = is.read(buf, 0, bytes)) <= 0) {
                    if (truncateLength == Long.MAX_VALUE) break;
                    IOException ioException = new IOException("Could not move required quantity of data in copyFrom: " + bytes + " (moved " + moved + " of " + truncateLength + "): unable to read from " + is);
                    ioException.printStackTrace();
                    throw ioException;
                }
                os.write(buf, 0, bytes);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bucket[] split(Bucket origData, int splitSize, BucketFactory bf, boolean freeData, boolean persistent, ObjectContainer container) throws IOException {
        Bucket[] buckets;
        block22: {
            InputStream is;
            block21: {
                long length;
                Bucket data;
                if (origData instanceof FileBucket) {
                    if (freeData) {
                        Logger.error(BucketTools.class, "Asked to free data when splitting a FileBucket ?!?!? Not freeing as this would clobber the split result...");
                    }
                    Bucket[] buckets2 = ((FileBucket)origData).split(splitSize);
                    if (!persistent) return buckets2;
                    Bucket[] arr$ = buckets2;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (i$ < len$) {
                        Bucket bucket = arr$[i$];
                        bucket.storeTo(container);
                        ++i$;
                    }
                    return buckets2;
                }
                if (origData instanceof BucketChainBucket) {
                    if (persistent) {
                        throw new IllegalArgumentException("Splitting a BucketChainBucket but persistent = true!");
                    }
                    data = (BucketChainBucket)origData;
                    if (((BucketChainBucket)data).bucketSize == (long)splitSize) {
                        Bucket[] buckets3 = ((BucketChainBucket)data).getBuckets();
                        if (!freeData) return buckets3;
                        ((BucketChainBucket)data).clear();
                        return buckets3;
                    }
                    Logger.error(BucketTools.class, "Incompatible split size splitting a BucketChainBucket: his split size is " + ((BucketChainBucket)data).bucketSize + " but mine is " + splitSize + " - we will copy the data, but this suggests a bug", new Exception("debug"));
                }
                if (origData instanceof SegmentedBucketChainBucket) {
                    data = (SegmentedBucketChainBucket)origData;
                    if (((SegmentedBucketChainBucket)data).bucketSize == (long)splitSize) {
                        Bucket[] buckets4 = ((SegmentedBucketChainBucket)data).getBuckets();
                        if (freeData) {
                            ((SegmentedBucketChainBucket)data).clear();
                        }
                        if (!persistent) return buckets4;
                        if (!freeData) return buckets4;
                        ((SegmentedBucketChainBucket)data).removeFrom(container);
                        return buckets4;
                    }
                    Logger.error(BucketTools.class, "Incompatible split size splitting a BucketChainBucket: his split size is " + ((SegmentedBucketChainBucket)data).bucketSize + " but mine is " + splitSize + " - we will copy the data, but this suggests a bug", new Exception("debug"));
                }
                if ((length = origData.size()) > Integer.MAX_VALUE * (long)splitSize) {
                    throw new IllegalArgumentException("Way too big!: " + length + " for " + splitSize);
                }
                int bucketCount = (int)(length / (long)splitSize);
                if (length % (long)splitSize > 0L) {
                    ++bucketCount;
                }
                if (Logger.shouldLog(4, BucketTools.class)) {
                    Logger.minor(BucketTools.class, "Splitting bucket " + origData + " of size " + length + " into " + bucketCount + " buckets");
                }
                buckets = new Bucket[bucketCount];
                is = origData.getInputStream();
                DataInputStream dis = null;
                try {
                    int len;
                    dis = new DataInputStream(is);
                    long remainingLength = length;
                    byte[] buf = new byte[splitSize];
                    for (int i = 0; i < bucketCount; remainingLength -= (long)len, ++i) {
                        Object var20_28;
                        Bucket bucket;
                        len = (int)Math.min((long)splitSize, remainingLength);
                        buckets[i] = bucket = bf.makeBucket(len);
                        dis.readFully(buf, 0, len);
                        OutputStream os = bucket.getOutputStream();
                        try {
                            os.write(buf, 0, len);
                            var20_28 = null;
                        }
                        catch (Throwable throwable) {
                            var20_28 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                    }
                    Object var22_30 = null;
                    if (dis == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var22_31 = null;
                    if (dis != null) {
                        dis.close();
                        throw throwable;
                    }
                    is.close();
                    throw throwable;
                }
                dis.close();
                break block22;
            }
            is.close();
        }
        if (freeData) {
            origData.free();
        }
        if (persistent && freeData) {
            origData.removeFrom(container);
        }
        if (!persistent) return buckets;
        Bucket[] arr$ = buckets;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            Bucket bucket = arr$[i$];
            bucket.storeTo(container);
            ++i$;
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket pad(Bucket oldBucket, int blockLength, BucketFactory bf, int length) throws IOException {
        Bucket bucket;
        byte[] hash = BucketTools.hash(oldBucket);
        Bucket b = bf.makeBucket(blockLength);
        MersenneTwister mt = new MersenneTwister(hash);
        OutputStream os = b.getOutputStream();
        try {
            int thisCycle;
            BucketTools.copyTo(oldBucket, os, length);
            byte[] buf = new byte[4096];
            for (int x = length; x < blockLength; x += thisCycle) {
                int remaining = blockLength - x;
                thisCycle = Math.min(remaining, buf.length);
                mt.nextBytes(buf);
                os.write(buf, 0, thisCycle);
            }
            os.close();
            os = null;
            if (b.size() != (long)blockLength) {
                throw new IllegalStateException("The bucket's size is " + b.size() + " whereas it should be " + blockLength + '!');
            }
            bucket = b;
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Closer.close(os);
            throw throwable;
        }
        Closer.close(os);
        return bucket;
    }
}

