/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.FileBucket;
import freenet.support.io.FileExistsException;
import freenet.support.io.FileUtil;
import freenet.support.io.NullInputStream;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempFileBucket;
import freenet.support.io.ReadOnlyFileSliceBucket;
import freenet.support.io.SerializableToFieldSetBucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class BaseFileBucket
implements Bucket,
SerializableToFieldSetBucket {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    protected long length;
    protected long fileRestartCounter;
    private boolean freed;
    private transient Vector<Object> streams;
    protected static String tempDir;

    public BaseFileBucket(File file, boolean deleteOnExit) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.length = file.length();
        if (deleteOnExit) {
            this.setDeleteOnExit(file);
        }
    }

    protected void setDeleteOnExit(File file) {
        try {
            file.deleteOnExit();
        }
        catch (NullPointerException e) {
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                Logger.normal(this, "NullPointerException setting deleteOnExit while shutting down - buggy JVM code: " + e, e);
            }
            Logger.error(this, "Caught " + e + " doing deleteOnExit() for " + file + " - JVM bug ????");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        BaseFileBucket baseFileBucket = this;
        synchronized (baseFileBucket) {
            File file = this.getFile();
            if (this.freed) {
                throw new IOException("File already freed: " + this);
            }
            if (this.isReadOnly()) {
                throw new IOException("Bucket is read-only: " + this);
            }
            if (this.createFileOnly() && file.exists()) {
                throw new FileExistsException(file);
            }
            if (this.streams != null && !this.streams.isEmpty()) {
                Logger.error(this, "Streams open on " + this + " while opening an output stream!: " + this.streams, new Exception("debug"));
            }
            File tempfile = this.createFileOnly() ? this.getTempfile() : file;
            long streamNumber = ++this.fileRestartCounter;
            FileBucketOutputStream os = new FileBucketOutputStream(tempfile, streamNumber);
            if (logDEBUG) {
                Logger.debug(this, "Creating " + os, new Exception("debug"));
            }
            this.addStream(os);
            return os;
        }
    }

    private synchronized void addStream(Object stream) {
        if (this.streams == null) {
            this.streams = new Vector(1, 1);
        }
        this.streams.add(stream);
    }

    private synchronized void removeStream(Object stream) {
        if (this.streams == null) {
            return;
        }
        this.streams.remove(stream);
        if (this.streams.isEmpty()) {
            this.streams = null;
        }
    }

    protected abstract boolean createFileOnly();

    protected abstract boolean deleteOnExit();

    protected abstract boolean deleteOnFinalize();

    protected abstract boolean deleteOnFree();

    protected File getTempfile() throws IOException {
        File file = this.getFile();
        File f = File.createTempFile(file.getName(), ".freenet-tmp", file.getParentFile());
        if (this.deleteOnExit()) {
            f.deleteOnExit();
        }
        return f;
    }

    protected synchronized void resetLength() {
        this.length = 0L;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.freed) {
            throw new IOException("File already freed: " + this);
        }
        File file = this.getFile();
        if (!file.exists()) {
            Logger.normal(this, "File does not exist: " + file + " for " + this);
            return new NullInputStream();
        }
        FileBucketInputStream is = new FileBucketInputStream(file);
        this.addStream(is);
        if (logDEBUG) {
            Logger.debug(this, "Creating " + is, new Exception("debug"));
        }
        return is;
    }

    public synchronized String getName() {
        return this.getFile().getName();
    }

    public synchronized long size() {
        return this.length;
    }

    protected synchronized void deleteFile() {
        if (logMINOR) {
            Logger.minor(this, "Deleting " + this.getFile() + " for " + this, (Throwable)new Exception("debug"));
        }
        this.getFile().delete();
    }

    protected void finalize() {
        if (this.deleteOnFinalize()) {
            this.free(true);
        }
    }

    public static final synchronized String getTempDir() {
        return tempDir;
    }

    public static final synchronized void setTempDir(String dirName) {
        File dir = new File(dirName);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad Temp Directory: " + dir.getAbsolutePath());
        }
        tempDir = dirName;
    }

    public synchronized Bucket[] split(int splitSize) {
        if (this.length > Integer.MAX_VALUE * (long)splitSize) {
            throw new IllegalArgumentException("Way too big!: " + this.length + " for " + splitSize);
        }
        int bucketCount = (int)(this.length / (long)splitSize);
        if (this.length % (long)splitSize > 0L) {
            ++bucketCount;
        }
        Bucket[] buckets = new Bucket[bucketCount];
        File file = this.getFile();
        for (int i = 0; i < buckets.length; ++i) {
            long startAt = 1L * (long)i * (long)splitSize;
            long endAt = Math.min(startAt + (long)splitSize * 1L, this.length);
            long len = endAt - startAt;
            buckets[i] = new ReadOnlyFileSliceBucket(file, startAt, len);
        }
        return buckets;
    }

    public void free() {
        this.free(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(boolean forceFree) {
        Object[] toClose;
        if (logMINOR) {
            Logger.minor(this, "Freeing " + this, (Throwable)new Exception("debug"));
        }
        BaseFileBucket baseFileBucket = this;
        synchronized (baseFileBucket) {
            if (this.freed) {
                return;
            }
            this.freed = true;
            toClose = this.streams == null ? null : this.streams.toArray();
            this.streams = null;
        }
        if (toClose != null) {
            Logger.error(this, "Streams open free()ing " + this + " : " + Arrays.toString(toClose), new Exception("debug"));
            for (int i = 0; i < toClose.length; ++i) {
                try {
                    if (toClose[i] instanceof FileBucketOutputStream) {
                        ((FileBucketOutputStream)toClose[i]).close();
                        continue;
                    }
                    ((FileBucketInputStream)toClose[i]).close();
                    continue;
                }
                catch (IOException e) {
                    Logger.error(this, "Caught closing stream in free(): " + e, e);
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught closing stream in free(): " + t, t);
                }
            }
        }
        File file = this.getFile();
        if ((this.deleteOnFree() || forceFree) && file.exists()) {
            Logger.debug(this, "Deleting bucket " + file.getName(), new Exception("debug"));
            this.deleteFile();
            if (file.exists()) {
                Logger.error(this, "Delete failed on bucket " + file.getName());
            }
        }
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        sb.append(this.getFile().getPath());
        sb.append(":streams=");
        sb.append(this.streams == null ? 0 : this.streams.size());
        return sb.toString();
    }

    public abstract File getFile();

    public synchronized SimpleFieldSet toFieldSet() {
        if (this.deleteOnFinalize()) {
            return null;
        }
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", "FileBucket");
        fs.putSingle("Filename", this.getFile().toString());
        fs.put("Length", this.size());
        return fs;
    }

    public static Bucket create(SimpleFieldSet fs, PersistentFileTracker f) throws CannotCreateFromFieldSetException {
        String tmp = fs.get("Filename");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No filename");
        }
        File file = FileUtil.getCanonicalFile(new File(tmp));
        if (f.matches(file)) {
            return PersistentTempFileBucket.create(fs, f);
        }
        tmp = fs.get("Length");
        if (tmp == null) {
            throw new CannotCreateFromFieldSetException("No length");
        }
        try {
            long length = Fields.parseLong(tmp, -1L);
            if (length != file.length()) {
                throw new CannotCreateFromFieldSetException("Invalid length: should be " + length + " actually " + file.length() + " on " + file);
            }
        }
        catch (NumberFormatException e) {
            throw new CannotCreateFromFieldSetException("Corrupt length " + tmp, e);
        }
        FileBucket bucket = new FileBucket(file, false, true, false, false, false);
        if (file.exists()) {
            f.register(file);
        }
        return bucket;
    }

    static {
        String os;
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
        tempDir = null;
        tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null && (os = System.getProperty("os.name")) != null) {
            String[] candidates = null;
            if (os.equalsIgnoreCase("Linux") || os.equalsIgnoreCase("FreeBSD")) {
                String[] linuxCandidates;
                candidates = linuxCandidates = new String[]{"/tmp", "/var/tmp"};
            } else if (os.equalsIgnoreCase("Windows")) {
                String[] windowsCandidates = new String[]{"C:\\TEMP", "C:\\WINDOWS\\TEMP"};
                candidates = windowsCandidates;
            }
            if (candidates != null) {
                for (int i = 0; i < candidates.length; ++i) {
                    File path = new File(candidates[i]);
                    if (!path.exists() || !path.isDirectory() || !path.canWrite()) continue;
                    tempDir = candidates[i];
                    break;
                }
            }
        }
        if (tempDir == null) {
            tempDir = System.getProperty("user.dir");
        }
    }

    class FileBucketInputStream
    extends FileInputStream {
        boolean closed;

        public FileBucketInputStream(File f) throws IOException {
            super(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FileBucketInputStream fileBucketInputStream = this;
            synchronized (fileBucketInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            BaseFileBucket.this.removeStream(this);
            super.close();
        }

        public String toString() {
            return super.toString() + ":" + BaseFileBucket.this.toString();
        }
    }

    class FileBucketOutputStream
    extends FileOutputStream {
        private long restartCount;
        private File tempfile;
        private boolean closed;

        protected FileBucketOutputStream(File tempfile, long restartCount) throws FileNotFoundException {
            super(tempfile, false);
            if (logMINOR) {
                Logger.minor(this, "Writing to " + tempfile + " for " + BaseFileBucket.this.getFile() + " : " + this);
            }
            this.tempfile = tempfile;
            BaseFileBucket.this.resetLength();
            this.restartCount = restartCount;
            this.closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void confirmWriteSynchronized() throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                if (BaseFileBucket.this.fileRestartCounter > this.restartCount) {
                    throw new IllegalStateException("writing to file after restart");
                }
                if (BaseFileBucket.this.freed) {
                    throw new IOException("writing to file after it has been freed");
                }
            }
            if (BaseFileBucket.this.isReadOnly()) {
                throw new IOException("File is read-only");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b);
                BaseFileBucket.this.length += (long)b.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b, off, len);
                BaseFileBucket.this.length += (long)len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b);
                ++BaseFileBucket.this.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            File file;
            FileBucketOutputStream fileBucketOutputStream = this;
            synchronized (fileBucketOutputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                file = BaseFileBucket.this.getFile();
            }
            BaseFileBucket.this.removeStream(this);
            if (logMINOR) {
                Logger.minor(this, "Closing " + BaseFileBucket.this);
            }
            try {
                super.close();
            }
            catch (IOException e) {
                if (logMINOR) {
                    Logger.minor(this, "Failed closing " + BaseFileBucket.this + " : " + e, (Throwable)e);
                }
                if (BaseFileBucket.this.createFileOnly()) {
                    this.tempfile.delete();
                }
                throw e;
            }
            if (BaseFileBucket.this.createFileOnly()) {
                if (file.exists()) {
                    if (logMINOR) {
                        Logger.minor(this, "File exists creating file for " + this);
                    }
                    this.tempfile.delete();
                    throw new FileExistsException(file);
                }
                if (!this.tempfile.renameTo(file)) {
                    if (logMINOR) {
                        Logger.minor(this, "Cannot rename file for " + this);
                    }
                    if (file.exists()) {
                        throw new FileExistsException(file);
                    }
                    this.tempfile.delete();
                    if (logMINOR) {
                        Logger.minor(this, "Deleted, cannot rename file for " + this);
                    }
                    throw new IOException("Cannot rename file");
                }
            }
        }

        public String toString() {
            return super.toString() + ":" + BaseFileBucket.this.toString();
        }
    }
}

