/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ArrayBucket
implements Bucket {
    private volatile byte[] data = new byte[0];
    private String name;
    private boolean readOnly;

    public ArrayBucket() {
        this("ArrayBucket");
    }

    public ArrayBucket(byte[] initdata) {
        this("ArrayBucket");
        this.data = initdata;
    }

    public ArrayBucket(String name) {
        this.name = name;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        return new ArrayBucketOutputStream();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return new String(this.data);
    }

    public long size() {
        return this.data.length;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void free() {
        this.data = new byte[0];
    }

    public byte[] toByteArray() {
        long sz = this.size();
        int size = (int)sz;
        byte[] buf = new byte[size];
        System.arraycopy(this.data, 0, buf, 0, size);
        return buf;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this.data);
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.data);
        container.delete((Object)this);
    }

    public Bucket createShadow() throws IOException {
        return null;
    }

    static /* synthetic */ byte[] access$002(ArrayBucket x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class ArrayBucketOutputStream
    extends ByteArrayOutputStream {
        private boolean hasBeenClosed = false;

        public synchronized void close() throws IOException {
            if (this.hasBeenClosed) {
                return;
            }
            ArrayBucket.access$002(ArrayBucket.this, super.toByteArray());
            if (ArrayBucket.this.readOnly) {
                throw new IOException("Read only");
            }
            this.hasBeenClosed = true;
        }
    }
}

