/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.Closer;
import freenet.support.io.CountedInputStream;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZMACompressor
implements Compressor {
    static final int propSize = 5;
    static final byte[] props = new byte[5];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        Bucket output = bf.makeBucket(maxWriteLength);
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Compressing " + data + " size " + data.size() + " to new bucket " + output);
        }
        CountedInputStream cis = null;
        CountedOutputStream cos = null;
        try {
            cis = new CountedInputStream(new BufferedInputStream(data.getInputStream()));
            cos = new CountedOutputStream(new BufferedOutputStream(output.getOutputStream()));
            Encoder encoder = new Encoder();
            encoder.SetEndMarkerMode(true);
            encoder.SetDictionarySize(0x100000);
            encoder.Code((InputStream)cis, (OutputStream)cos, -1L, -1L, null);
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Output: " + output + " size " + output.size() + " read " + cis.count() + " written " + cos.written());
            }
            cis.close();
            cos.close();
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            Closer.close(cis);
            Closer.close(cos);
            throw throwable;
        }
        Closer.close(cis);
        Closer.close(cos);
        return output;
    }

    public Bucket decompress(Bucket data, BucketFactory bf, long maxLength, long maxCheckSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
        Bucket output = preferred != null ? preferred : bf.makeBucket(maxLength);
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Decompressing " + data + " size " + data.size() + " to new bucket " + output);
        }
        CountedInputStream is = new CountedInputStream(new BufferedInputStream(data.getInputStream()));
        CountedOutputStream os = new CountedOutputStream(new BufferedOutputStream(output.getOutputStream()));
        this.decompress(is, os, maxLength, maxCheckSizeLength);
        os.close();
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Output: " + output + " size " + output.size() + " read " + is.count() + " written " + os.written());
        }
        return output;
    }

    private void decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        Decoder decoder = new Decoder();
        decoder.SetDecoderProperties(props);
        decoder.Code(is, os, maxLength);
    }

    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            this.decompress(bais, baos, (long)output.length, -1L);
            bytes = baos.size();
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }

    static {
        LZMACompressor.props[0] = 93;
        LZMACompressor.props[1] = 0;
        LZMACompressor.props[2] = 0;
        LZMACompressor.props[3] = 16;
        LZMACompressor.props[4] = 0;
    }
}

