/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.Closer;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressor
implements Compressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        DeflaterOutputStream gos;
        BufferedOutputStream os;
        Bucket output;
        block13: {
            if (maxReadLength < 0L) {
                throw new IllegalArgumentException();
            }
            output = bf.makeBucket(maxWriteLength);
            InputStream is = null;
            os = null;
            gos = null;
            try {
                block12: {
                    is = data.getInputStream();
                    os = new BufferedOutputStream(output.getOutputStream());
                    CountedOutputStream cos = new CountedOutputStream(os);
                    gos = new GZIPOutputStream(cos);
                    long read = 0L;
                    byte[] buffer = new byte[32768];
                    do {
                        int l;
                        int x;
                        int n = x = (l = (int)Math.min((long)buffer.length, maxReadLength - read)) == 0 ? -1 : is.read(buffer, 0, l);
                        if (x <= -1) break block12;
                        if (x == 0) {
                            throw new IOException("Returned zero from read()");
                        }
                        ((GZIPOutputStream)gos).write(buffer, 0, x);
                        read += (long)x;
                    } while (cos.written() <= maxWriteLength);
                    throw new CompressionOutputSizeException();
                }
                gos.flush();
                Object var18_14 = null;
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                Object var18_15 = null;
                if (is != null) {
                    is.close();
                }
                if (gos != null) {
                    gos.close();
                } else if (os != null) {
                    ((OutputStream)os).close();
                }
                throw throwable;
            }
            is.close();
        }
        if (gos != null) {
            gos.close();
        } else if (os != null) {
            ((OutputStream)os).close();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket decompress(Bucket data, BucketFactory bf, long maxLength, long maxCheckSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
        Bucket bucket;
        OutputStream os;
        block4: {
            Bucket output = preferred != null ? preferred : bf.makeBucket(maxLength);
            InputStream is = null;
            os = null;
            try {
                is = data.getInputStream();
                os = output.getOutputStream();
                this.decompress(is, os, maxLength, maxCheckSizeLength);
                os.close();
                os = null;
                is.close();
                is = null;
                bucket = output;
                Object var13_10 = null;
                if (is == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var13_11 = null;
                    if (is != null) {
                        Closer.close(is);
                    }
                    if (os == null) break block5;
                    Closer.close(os);
                }
                throw throwable;
            }
            Closer.close(is);
        }
        if (os != null) {
            Closer.close(os);
        }
        return bucket;
    }

    private long decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        GZIPInputStream gis = new GZIPInputStream(is);
        long written = 0L;
        byte[] buffer = new byte[4096];
        while (true) {
            int x;
            int l;
            if ((l = (int)Math.min((long)buffer.length, maxLength - written)) < (x = gis.read(buffer, 0, buffer.length))) {
                Logger.normal(this, "l=" + l + ", x=" + x + ", written=" + written + ", maxLength=" + maxLength + " throwing a CompressionOutputSizeException");
                if (maxCheckSizeBytes > 0L) {
                    written += (long)x;
                    while (true) {
                        if ((x = gis.read(buffer, 0, l = (int)Math.min((long)buffer.length, maxLength + maxCheckSizeBytes - written))) <= -1) {
                            throw new CompressionOutputSizeException(written);
                        }
                        if (x == 0) {
                            throw new IOException("Returned zero from read()");
                        }
                        written += (long)x;
                    }
                }
                throw new CompressionOutputSizeException();
            }
            if (x <= -1) {
                return written;
            }
            if (x == 0) {
                throw new IOException("Returned zero from read()");
            }
            os.write(buffer, 0, x);
            written += (long)x;
        }
    }

    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            bytes = (int)this.decompress(bais, baos, (long)output.length, -1L);
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }
}

