/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.Bzip2Compressor;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.GzipCompressor;
import freenet.support.compress.LZMACompressor;
import java.io.IOException;

public interface Compressor {
    public Bucket compress(Bucket var1, BucketFactory var2, long var3, long var5) throws IOException, CompressionOutputSizeException;

    public Bucket decompress(Bucket var1, BucketFactory var2, long var3, long var5, Bucket var7) throws IOException, CompressionOutputSizeException;

    public int decompress(byte[] var1, int var2, int var3, byte[] var4) throws CompressionOutputSizeException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COMPRESSOR_TYPE implements Compressor
    {
        GZIP("GZIP", new GzipCompressor(), 0),
        BZIP2("BZIP2", new Bzip2Compressor(), 1),
        LZMA("LZMA", new LZMACompressor(), 2);

        public final String name;
        public final Compressor compressor;
        public final short metadataID;

        private COMPRESSOR_TYPE(String name, Compressor c, short metadataID) {
            this.name = name;
            this.compressor = c;
            this.metadataID = metadataID;
        }

        public static COMPRESSOR_TYPE getCompressorByMetadataID(short id) {
            COMPRESSOR_TYPE[] values;
            for (COMPRESSOR_TYPE current : values = COMPRESSOR_TYPE.values()) {
                if (current.metadataID != id) continue;
                return current;
            }
            return null;
        }

        @Override
        public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
            if (this.compressor == null && this.name != null) {
                return this.getOfficial().compress(data, bf, maxReadLength, maxWriteLength);
            }
            return this.compressor.compress(data, bf, maxReadLength, maxWriteLength);
        }

        @Override
        public Bucket decompress(Bucket data, BucketFactory bucketFactory, long maxLength, long maxEstimateSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
            if (this.compressor == null && this.name != null) {
                return this.getOfficial().decompress(data, bucketFactory, maxLength, maxEstimateSizeLength, preferred);
            }
            return this.compressor.decompress(data, bucketFactory, maxLength, maxEstimateSizeLength, preferred);
        }

        @Override
        public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
            if (this.compressor == null && this.name != null) {
                return this.getOfficial().decompress(dbuf, i, j, output);
            }
            return this.compressor.decompress(dbuf, i, j, output);
        }

        private Compressor getOfficial() {
            if (this.name.equals("GZIP")) {
                return GZIP;
            }
            if (this.name.equals("BZIP2")) {
                return BZIP2;
            }
            if (this.name.equals("LZMA")) {
                return LZMA;
            }
            return null;
        }

        public boolean objectCanDeactivate(ObjectContainer container) {
            return !this.isOfficial();
        }

        public boolean objectCanActivate(ObjectContainer container) {
            return !this.isOfficial();
        }

        public boolean isOfficial() {
            return this == GZIP || this == BZIP2 || this == LZMA;
        }
    }
}

