/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class Bzip2Compressor
implements Compressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        OutputStream os;
        Bucket output;
        block9: {
            if (maxReadLength <= 0L) {
                throw new IllegalArgumentException();
            }
            output = bf.makeBucket(maxWriteLength);
            InputStream is = null;
            os = null;
            CBZip2OutputStream bz2os = null;
            try {
                block8: {
                    is = data.getInputStream();
                    os = output.getOutputStream();
                    CountedOutputStream cos = new CountedOutputStream(os);
                    bz2os = new CBZip2OutputStream((OutputStream)new BufferedOutputStream(cos));
                    long read = 0L;
                    byte[] buffer = new byte[32768];
                    do {
                        int l;
                        int x;
                        int n = x = (l = (int)Math.min((long)buffer.length, maxReadLength - read)) == 0 ? -1 : is.read(buffer, 0, buffer.length);
                        if (x <= -1) break block8;
                        if (x == 0) {
                            throw new IOException("Returned zero from read()");
                        }
                        bz2os.write(buffer, 0, x);
                        read += (long)x;
                    } while (cos.written() <= maxWriteLength);
                    throw new CompressionOutputSizeException();
                }
                bz2os.flush();
                bz2os.close();
                os = null;
                Object var18_14 = null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                Object var18_15 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
        return output;
    }

    public Bucket decompress(Bucket data, BucketFactory bf, long maxLength, long maxCheckSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
        Bucket output = preferred != null ? preferred : bf.makeBucket(maxLength);
        InputStream is = data.getInputStream();
        OutputStream os = output.getOutputStream();
        this.decompress(is, os, maxLength, maxCheckSizeLength);
        os.close();
        is.close();
        return output;
    }

    private long decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        CBZip2InputStream bz2is = new CBZip2InputStream(is);
        long written = 0L;
        byte[] buffer = new byte[4096];
        while (true) {
            int x;
            int l;
            if ((l = (int)Math.min((long)buffer.length, maxLength - written)) < (x = bz2is.read(buffer, 0, buffer.length))) {
                Logger.normal(this, "l=" + l + ", x=" + x + ", written=" + written + ", maxLength=" + maxLength + " throwing a CompressionOutputSizeException");
                if (maxCheckSizeBytes > 0L) {
                    written += (long)x;
                    while (true) {
                        if ((x = bz2is.read(buffer, 0, l = (int)Math.min((long)buffer.length, maxLength + maxCheckSizeBytes - written))) <= -1) {
                            throw new CompressionOutputSizeException(written);
                        }
                        if (x == 0) {
                            throw new IOException("Returned zero from read()");
                        }
                        written += (long)x;
                    }
                }
                throw new CompressionOutputSizeException();
            }
            if (x <= -1) {
                return written;
            }
            if (x == 0) {
                throw new IOException("Returned zero from read()");
            }
            os.write(buffer, 0, x);
            written += (long)x;
        }
    }

    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            bytes = (int)this.decompress(bais, baos, (long)output.length, -1L);
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }
}

