/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.IndexableUpdatableSortedLinkedListItem;
import freenet.support.Logger;
import freenet.support.UpdatableSortedLinkedList;
import freenet.support.UpdatableSortedLinkedListKilledException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatableSortedLinkedListWithForeignIndex<T extends IndexableUpdatableSortedLinkedListItem<T>>
extends UpdatableSortedLinkedList<T> {
    final HashMap<Object, T> map = new HashMap();

    @Override
    public synchronized void add(T item) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        T i = item;
        if (this.map.get(i.indexValue()) != null) {
            Logger.error(this, "Ignoring duplicate: " + i + " was already present: " + this.map.get(i.indexValue()));
            return;
        }
        super.add(i);
        this.map.put(i.indexValue(), item);
        this.checkList();
    }

    @Override
    public synchronized T remove(T item) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        this.map.remove(item.indexValue());
        return (T)((IndexableUpdatableSortedLinkedListItem)super.remove(item));
    }

    public synchronized T get(Object key) {
        return (T)((IndexableUpdatableSortedLinkedListItem)this.map.get(key));
    }

    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean contains(IndexableUpdatableSortedLinkedListItem<?> item) {
        return this.containsKey(item.indexValue());
    }

    public synchronized T removeByKey(Object key) throws UpdatableSortedLinkedListKilledException {
        if (this.killed) {
            throw new UpdatableSortedLinkedListKilledException();
        }
        IndexableUpdatableSortedLinkedListItem item = (IndexableUpdatableSortedLinkedListItem)this.map.get(key);
        if (item != null) {
            this.remove((T)item);
        }
        this.checkList();
        return (T)item;
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        super.clear();
    }
}

